/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.main;

import com.bysquare.BysquareQREncoder;
import com.bysquare.Header;
import com.bysquare.UnknownDocumentException;
import com.bysquare.document.BysquareDocument;
import com.bysquare.logo.Logo;
import com.bysquare.main.BaseMain;
import com.bysquare.sequence.SequenceDecoder;
import com.bysquare.utilities.IOUtils;
import com.bysquare.xml.BysquarePersister;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncoderMain
extends BaseMain {
    boolean decode;
    private boolean encode;
    private BysquareQREncoder encoder = new BysquareQREncoder();
    private InputType inputType = InputType.XML;
    private boolean lineId;
    boolean lines;
    private Header.Type logoType = Header.Type.Pay;
    private BysquarePersister persister = new BysquarePersister();
    boolean sequence;
    private boolean invoiceId;
    String prefix;

    public static void main(String[] stringArray) {
        new EncoderMain().execute(stringArray);
    }

    @Override
    void execute(String[] stringArray) {
        block12: {
            super.execute(stringArray);
            if (this.encode || this.decode) {
                try {
                    if (this.lines) {
                        this.processLines();
                        break block12;
                    }
                    this.processInput();
                }
                catch (Exception exception) {
                    this.print(exception);
                    System.exit(1);
                }
            } else {
                BufferedImage bufferedImage = null;
                try {
                    switch (this.inputType) {
                        case BASE32HEX: {
                            bufferedImage = this.encoder.qrEncodeBase32hex(IOUtils.toBytes(System.in));
                            break;
                        }
                        case IMAGE: {
                            bufferedImage = this.encoder.wrapQRImage(ImageIO.read(System.in), this.logoType);
                            break;
                        }
                        case XML: {
                            bufferedImage = this.encoder.qrEncodeXML(System.in);
                        }
                    }
                    ImageIO.write(bufferedImage, "PNG", System.out);
                }
                catch (Exception exception) {
                    this.print(exception);
                    System.exit(1);
                }
            }
        }
    }

    @Override
    boolean parse(String string, String string2) {
        if (string.equals("decode") || string.equals("d")) {
            throw new UnsupportedOperationException("Decoding is supported only in the full version.");
        }
        if (string.equals("encode") || string.equals("e")) {
            this.encode = true;
        } else if (string.equals("lines") || string.equals("s")) {
            this.lines = true;
        } else if (string.equals("line-id")) {
            this.lineId = true;
        } else if (string.equals("sequence")) {
            this.sequence = true;
        } else if (string.equals("invoice-id")) {
            this.invoiceId = true;
        } else if (string.equals("size")) {
            this.encoder.setImageSize(Integer.parseInt(string2));
        } else if (string.equals("no-logo")) {
            this.encoder.setUseLogo(false);
        } else if (string.equals("logo-dir") || string.equals("l")) {
            this.encoder.setLogoDirectory(new File(string2));
        } else if (string.equals("input-type") || string.equals("i")) {
            this.inputType = InputType.valueOf(string2.toUpperCase());
        } else if (string.equals("type") || string.equals("t")) {
            String string3 = string2.substring(0, 1).toUpperCase();
            String string4 = string2.substring(1, string2.length()).toLowerCase();
            this.logoType = Header.Type.valueOf(string3 + string4);
        } else if (string.equals("rotation") || string.equals("r")) {
            this.encoder.setLogoRotation(Logo.Rotation.valueOf(string2.toUpperCase()));
        } else if (string.equals("variation") || string.equals("v")) {
            this.encoder.setLogoVariation(Logo.Variation.valueOf(string2.toUpperCase()));
        } else if (string.equals("no-frame")) {
            this.encoder.setLogoFrame(false);
        } else {
            return super.parse(string, string2);
        }
        return true;
    }

    private Class<? extends BysquareDocument> parseDocumentClass(String string) throws UnknownDocumentException {
        int n2;
        int n3;
        int n4 = string.indexOf(9);
        int n5 = string.indexOf(9, n4 + 1);
        if (n4 < 0 || n5 < 0) {
            throw new UnknownDocumentException("Header not found.");
        }
        if (this.invoiceId) {
            n3 = string.indexOf(9, n5 + 1);
            this.prefix = n3 > 0 ? string.substring(n5 + 1, n3) + "\t" : "";
        }
        try {
            n3 = Integer.parseInt(string.substring(0, n4));
            n2 = Integer.parseInt(string.substring(n4 + 1, n5));
        }
        catch (Exception exception) {
            throw new UnknownDocumentException("Error parsing header.");
        }
        return Header.find(n3, 0, n2).getDocumentClass();
    }

    void processInput() throws Exception {
        this.processLine(IOUtils.toString(System.in));
    }

    void processLine(String string) throws Exception {
        BysquareDocument bysquareDocument;
        Object object;
        if (this.sequence) {
            object = SequenceDecoder.getInstance(this.parseDocumentClass(string));
            int n2 = string.indexOf(9, string.indexOf(9) + 1);
            string = string.substring(n2 + 1);
            bysquareDocument = ((SequenceDecoder)object).decode(string);
        } else {
            bysquareDocument = (BysquareDocument)((Object)this.persister.read(BysquareDocument.class, string));
        }
        object = this.encoder.encodeDocument(bysquareDocument);
        if (this.prefix != null) {
            System.out.print(this.prefix);
        }
        System.out.write((byte[])object);
    }

    private void processLines() throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while ((string = bufferedReader.readLine()) != null) {
            int n2;
            if ((string = string.trim()).length() == 0) continue;
            this.prefix = null;
            if (this.lineId && (n2 = string.indexOf(58)) > -1) {
                this.prefix = string.substring(0, n2 + 1);
                string = string.substring(n2 + 1);
            }
            try {
                this.processLine(string);
                System.out.println();
            }
            catch (Exception exception) {
                if (this.prefix != null) {
                    System.err.print(this.prefix);
                }
                this.print(exception, true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InputType {
        BASE32HEX,
        IMAGE,
        XML;

    }
}

