/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.invoice.Contact;
import com.bysquare.document.invoice.CustomerParty;
import com.bysquare.document.invoice.InvoiceBase;
import com.bysquare.document.invoice.MonetarySummary;
import com.bysquare.document.invoice.Party;
import com.bysquare.document.invoice.PaymentMean;
import com.bysquare.document.invoice.PostalAddress;
import com.bysquare.document.invoice.SingleInvoiceLine;
import com.bysquare.document.invoice.SupplierParty;
import com.bysquare.document.invoice.TaxCategorySummaries;
import com.bysquare.document.invoice.TaxCategorySummary;
import com.bysquare.sequence.SequenceDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvoiceBaseDecoder
extends SequenceDecoder {
    InvoiceBaseDecoder(Class<? extends BysquareDocument> clazz) {
        super(clazz);
    }

    private Contact decodeContact() {
        Contact contact = new Contact();
        contact.setName(this.nextString());
        contact.setTelephone(this.nextString());
        contact.setEMail(this.nextString());
        return contact.isEmpty() ? null : contact;
    }

    private void decodeParty(Party party) {
        party.setPartyName(this.nextString());
        party.setCompanyTaxID(this.nextString());
        party.setCompanyVATID(this.nextString());
        party.setCompanyRegisterID(this.nextString());
    }

    private PostalAddress decodePostalAddress() {
        PostalAddress postalAddress = new PostalAddress();
        postalAddress.setStreetName(this.nextString());
        postalAddress.setBuildingNumber(this.nextString());
        postalAddress.setCityName(this.nextString());
        postalAddress.setPostalZone(this.nextString());
        postalAddress.setState(this.nextString());
        postalAddress.setCountry(this.nextString());
        return postalAddress;
    }

    private SupplierParty decodeSupplierParty() {
        SupplierParty supplierParty = new SupplierParty();
        this.decodeParty(supplierParty);
        supplierParty.setPostalAddress(this.decodePostalAddress());
        supplierParty.setContact(this.decodeContact());
        return supplierParty;
    }

    private CustomerParty decodeCustomerParty() {
        CustomerParty customerParty = new CustomerParty();
        this.decodeParty(customerParty);
        customerParty.setPartyIdentification(this.nextString());
        return customerParty;
    }

    private SingleInvoiceLine decodeSingleInvoiceLine() {
        SingleInvoiceLine singleInvoiceLine = new SingleInvoiceLine();
        singleInvoiceLine.setOrderLineID(this.nextString());
        singleInvoiceLine.setDeliveryNoteLineID(this.nextString());
        singleInvoiceLine.setItemName(this.nextString());
        singleInvoiceLine.setItemEANCode(this.nextString());
        singleInvoiceLine.setPeriodFromDate(this.nextDate());
        singleInvoiceLine.setPeriodToDate(this.nextDate());
        singleInvoiceLine.setInvoicedQuantity(this.nextDouble());
        return singleInvoiceLine.isEmpty() ? null : singleInvoiceLine;
    }

    private TaxCategorySummary decodeTaxCategorySummary() {
        TaxCategorySummary taxCategorySummary = new TaxCategorySummary();
        taxCategorySummary.setClassifiedTaxCategory(this.nextDouble());
        taxCategorySummary.setTaxExclusiveAmount(this.nextDouble());
        taxCategorySummary.setTaxAmount(this.nextDouble());
        taxCategorySummary.setAlreadyClaimedTaxExclusiveAmount(this.nextDouble());
        taxCategorySummary.setAlreadyClaimedTaxAmount(this.nextDouble());
        return taxCategorySummary;
    }

    private TaxCategorySummaries decodeTaxCategorySummaries() {
        TaxCategorySummaries taxCategorySummaries = new TaxCategorySummaries();
        int n2 = this.nextInt();
        while (n2-- > 0) {
            taxCategorySummaries.add(this.decodeTaxCategorySummary());
        }
        return taxCategorySummaries;
    }

    private MonetarySummary decodeMonetarySummary() {
        MonetarySummary monetarySummary = new MonetarySummary();
        monetarySummary.setPayableRoundingAmount(this.nextDouble());
        monetarySummary.setPaidDepositsAmount(this.nextDouble());
        return monetarySummary;
    }

    @Override
    protected InvoiceBase decode() {
        InvoiceBase invoiceBase = (InvoiceBase)this.newDocument();
        invoiceBase.setInvoiceID(this.nextString());
        invoiceBase.setIssueDate(this.nextDate());
        invoiceBase.setTaxPointDate(this.nextDate());
        invoiceBase.setOrderID(this.nextString());
        invoiceBase.setDeliveryNoteID(this.nextString());
        invoiceBase.setLocalCurrencyCode(this.nextString());
        invoiceBase.setForeignCurrencyCode(this.nextString());
        invoiceBase.setCurrRate(this.nextDouble());
        invoiceBase.setReferenceCurrRate(this.nextDouble());
        invoiceBase.setSupplierParty(this.decodeSupplierParty());
        invoiceBase.setCustomerParty(this.decodeCustomerParty());
        invoiceBase.setNumberOfInvoiceLines(this.nextInteger());
        invoiceBase.setInvoiceDescription(this.nextString());
        invoiceBase.setSingleInvoiceLine(this.decodeSingleInvoiceLine());
        invoiceBase.setTaxCategorySummaries(this.decodeTaxCategorySummaries());
        invoiceBase.setMonetarySummary(this.decodeMonetarySummary());
        invoiceBase.setPaymentMeans(this.nextEnumList(PaymentMean.class));
        return invoiceBase;
    }
}

