/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;

public class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final String DEFAULT_CHARSET_NAME = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            IOUtils.copy(fileInputStream, fileOutputStream);
        }
        finally {
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int n2;
        char[] cArray = new char[1024];
        while ((n2 = reader.read(cArray, 0, cArray.length)) > 0) {
            writer.write(cArray, 0, n2);
        }
    }

    public static byte[] toBytes(ByteArrayOutputStream byteArrayOutputStream) {
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            byte[] byArray = IOUtils.toBytes(fileInputStream);
            return byArray;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static byte[] toBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, byteArrayOutputStream);
        return IOUtils.toBytes(byteArrayOutputStream);
    }

    public static byte[] toBytes(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IOUtils.copy(reader, stringWriter);
        return IOUtils.toBytes(stringWriter.toString());
    }

    public static byte[] toBytes(String string) {
        try {
            return string.getBytes(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static InputStream toInputStream(byte[] byArray) {
        return new ByteArrayInputStream(byArray);
    }

    public static InputStream toInputStream(ByteArrayOutputStream byteArrayOutputStream) {
        return IOUtils.toInputStream(IOUtils.toBytes(byteArrayOutputStream));
    }

    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(IOUtils.toBytes(string));
    }

    public static String toString(byte[] byArray) {
        try {
            return new String(byArray, DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static String toString(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            return byteArrayOutputStream.toString(DEFAULT_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return byteArrayOutputStream.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string = IOUtils.toString(fileInputStream);
            return string;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public static String toString(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        IOUtils.copy(inputStream, byteArrayOutputStream);
        return IOUtils.toString(byteArrayOutputStream);
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter(1024);
        IOUtils.copy(reader, stringWriter);
        return IOUtils.toString(stringWriter);
    }

    public static String toString(StringWriter stringWriter) {
        return stringWriter.toString();
    }

    public static void tryClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String string) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), DEFAULT_CHARSET);
        try {
            outputStreamWriter.write(string);
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    public static byte[] copyOf(byte[] byArray, int n2) {
        return IOUtils.copyOfRange(byArray, 0, n2);
    }

    public static byte[] copyOfRange(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }
}

