/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;

public final class DefaultGridSampler
extends GridSampler {
    @Override
    public BitMatrix sampleGrid(BitMatrix image, int dimensionX, int dimensionY, float p1ToX, float p1ToY, float p2ToX, float p2ToY, float p3ToX, float p3ToY, float p4ToX, float p4ToY, float p1FromX, float p1FromY, float p2FromX, float p2FromY, float p3FromX, float p3FromY, float p4FromX, float p4FromY) throws NotFoundException {
        PerspectiveTransform transform = PerspectiveTransform.quadrilateralToQuadrilateral(p1ToX, p1ToY, p2ToX, p2ToY, p3ToX, p3ToY, p4ToX, p4ToY, p1FromX, p1FromY, p2FromX, p2FromY, p3FromX, p3FromY, p4FromX, p4FromY);
        return this.sampleGrid(image, dimensionX, dimensionY, transform);
    }

    @Override
    public BitMatrix sampleGrid(BitMatrix image, int dimensionX, int dimensionY, PerspectiveTransform transform) throws NotFoundException {
        if (dimensionX <= 0 || dimensionY <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bits = new BitMatrix(dimensionX, dimensionY);
        float[] points = new float[dimensionX << 1];
        for (int y = 0; y < dimensionY; ++y) {
            int x2;
            int max = points.length;
            float iValue = (float)y + 0.5f;
            for (x2 = 0; x2 < max; x2 += 2) {
                points[x2] = (float)(x2 >> 1) + 0.5f;
                points[x2 + 1] = iValue;
            }
            transform.transformPoints(points);
            DefaultGridSampler.checkAndNudgePoints(image, points);
            try {
                for (x2 = 0; x2 < max; x2 += 2) {
                    if (!image.get((int)points[x2], (int)points[x2 + 1])) continue;
                    bits.set(x2 >> 1, y);
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        return bits;
    }
}

