/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.Binarizer;
import com.google.zxing.LuminanceSource;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource source) {
        super(source);
    }

    @Override
    public BitArray getBlackRow(int y, BitArray row) throws NotFoundException {
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        if (row == null || row.getSize() < width) {
            row = new BitArray(width);
        } else {
            row.clear();
        }
        this.initArrays(width);
        byte[] localLuminances = source.getRow(y, this.luminances);
        int[] localBuckets = this.buckets;
        for (int x2 = 0; x2 < width; ++x2) {
            int pixel = localLuminances[x2] & 0xFF;
            int n2 = pixel >> 3;
            localBuckets[n2] = localBuckets[n2] + 1;
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        int left = localLuminances[0] & 0xFF;
        int center = localLuminances[1] & 0xFF;
        for (int x3 = 1; x3 < width - 1; ++x3) {
            int right = localLuminances[x3 + 1] & 0xFF;
            int luminance = (center << 2) - left - right >> 1;
            if (luminance < blackPoint) {
                row.set(x3);
            }
            left = center;
            center = right;
        }
        return row;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int pixel;
        int x2;
        LuminanceSource source = this.getLuminanceSource();
        int width = source.getWidth();
        int height = source.getHeight();
        BitMatrix matrix = new BitMatrix(width, height);
        this.initArrays(width);
        int[] localBuckets = this.buckets;
        for (int y = 1; y < 5; ++y) {
            int row = height * y / 5;
            byte[] localLuminances = source.getRow(row, this.luminances);
            int right = (width << 2) / 5;
            for (x2 = width / 5; x2 < right; ++x2) {
                pixel = localLuminances[x2] & 0xFF;
                int n2 = pixel >> 3;
                localBuckets[n2] = localBuckets[n2] + 1;
            }
        }
        int blackPoint = GlobalHistogramBinarizer.estimateBlackPoint(localBuckets);
        byte[] localLuminances = source.getMatrix();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (x2 = 0; x2 < width; ++x2) {
                pixel = localLuminances[offset + x2] & 0xFF;
                if (pixel >= blackPoint) continue;
                matrix.set(x2, y);
            }
        }
        return matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource source) {
        return new GlobalHistogramBinarizer(source);
    }

    private void initArrays(int luminanceSize) {
        if (this.luminances.length < luminanceSize) {
            this.luminances = new byte[luminanceSize];
        }
        for (int x2 = 0; x2 < 32; ++x2) {
            this.buckets[x2] = 0;
        }
    }

    private static int estimateBlackPoint(int[] buckets) throws NotFoundException {
        int numBuckets = buckets.length;
        int maxBucketCount = 0;
        int firstPeak = 0;
        int firstPeakSize = 0;
        for (int x2 = 0; x2 < numBuckets; ++x2) {
            if (buckets[x2] > firstPeakSize) {
                firstPeak = x2;
                firstPeakSize = buckets[x2];
            }
            if (buckets[x2] <= maxBucketCount) continue;
            maxBucketCount = buckets[x2];
        }
        int secondPeak = 0;
        int secondPeakScore = 0;
        for (int x3 = 0; x3 < numBuckets; ++x3) {
            int distanceToBiggest = x3 - firstPeak;
            int score = buckets[x3] * distanceToBiggest * distanceToBiggest;
            if (score <= secondPeakScore) continue;
            secondPeak = x3;
            secondPeakScore = score;
        }
        if (firstPeak > secondPeak) {
            int temp = firstPeak;
            firstPeak = secondPeak;
            secondPeak = temp;
        }
        if (secondPeak - firstPeak <= numBuckets >> 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int bestValley = secondPeak - 1;
        int bestValleyScore = -1;
        for (int x4 = secondPeak - 1; x4 > firstPeak; --x4) {
            int fromFirst = x4 - firstPeak;
            int score = fromFirst * fromFirst * (secondPeak - x4) * (maxBucketCount - buckets[x4]);
            if (score <= bestValleyScore) continue;
            bestValley = x4;
            bestValleyScore = score;
        }
        return bestValley << 3;
    }
}

