/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.detector.MathUtils;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 30;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    public WhiteRectangleDetector(BitMatrix image) throws NotFoundException {
        this.image = image;
        this.height = image.getHeight();
        this.width = image.getWidth();
        this.leftInit = this.width - 30 >> 1;
        this.rightInit = this.width + 30 >> 1;
        this.upInit = this.height - 30 >> 1;
        this.downInit = this.height + 30 >> 1;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public WhiteRectangleDetector(BitMatrix image, int initSize, int x2, int y) throws NotFoundException {
        this.image = image;
        this.height = image.getHeight();
        this.width = image.getWidth();
        int halfsize = initSize >> 1;
        this.leftInit = x2 - halfsize;
        this.rightInit = x2 + halfsize;
        this.upInit = y - halfsize;
        this.downInit = y + halfsize;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public ResultPoint[] detect() throws NotFoundException {
        int left = this.leftInit;
        int right = this.rightInit;
        int up = this.upInit;
        int down = this.downInit;
        boolean sizeExceeded = false;
        boolean aBlackPointFoundOnBorder = true;
        boolean atLeastOneBlackPointFoundOnBorder = false;
        while (aBlackPointFoundOnBorder) {
            aBlackPointFoundOnBorder = false;
            boolean rightBorderNotWhite = true;
            while (rightBorderNotWhite && right < this.width) {
                rightBorderNotWhite = this.containsBlackPoint(up, down, right, false);
                if (!rightBorderNotWhite) continue;
                ++right;
                aBlackPointFoundOnBorder = true;
            }
            if (right >= this.width) {
                sizeExceeded = true;
                break;
            }
            boolean bottomBorderNotWhite = true;
            while (bottomBorderNotWhite && down < this.height) {
                bottomBorderNotWhite = this.containsBlackPoint(left, right, down, true);
                if (!bottomBorderNotWhite) continue;
                ++down;
                aBlackPointFoundOnBorder = true;
            }
            if (down >= this.height) {
                sizeExceeded = true;
                break;
            }
            boolean leftBorderNotWhite = true;
            while (leftBorderNotWhite && left >= 0) {
                leftBorderNotWhite = this.containsBlackPoint(up, down, left, false);
                if (!leftBorderNotWhite) continue;
                --left;
                aBlackPointFoundOnBorder = true;
            }
            if (left < 0) {
                sizeExceeded = true;
                break;
            }
            boolean topBorderNotWhite = true;
            while (topBorderNotWhite && up >= 0) {
                topBorderNotWhite = this.containsBlackPoint(left, right, up, true);
                if (!topBorderNotWhite) continue;
                --up;
                aBlackPointFoundOnBorder = true;
            }
            if (up < 0) {
                sizeExceeded = true;
                break;
            }
            if (!aBlackPointFoundOnBorder) continue;
            atLeastOneBlackPointFoundOnBorder = true;
        }
        if (!sizeExceeded && atLeastOneBlackPointFoundOnBorder) {
            int maxSize = right - left;
            ResultPoint z = null;
            for (int i2 = 1; i2 < maxSize && (z = this.getBlackPointOnSegment(left, down - i2, left + i2, down)) == null; ++i2) {
            }
            if (z == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint t2 = null;
            for (int i3 = 1; i3 < maxSize && (t2 = this.getBlackPointOnSegment(left, up + i3, left + i3, up)) == null; ++i3) {
            }
            if (t2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint x2 = null;
            for (int i4 = 1; i4 < maxSize && (x2 = this.getBlackPointOnSegment(right, up + i4, right - i4, up)) == null; ++i4) {
            }
            if (x2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint y = null;
            for (int i5 = 1; i5 < maxSize && (y = this.getBlackPointOnSegment(right, down - i5, right - i5, down)) == null; ++i5) {
            }
            if (y == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges(y, z, x2, t2);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private ResultPoint getBlackPointOnSegment(float aX, float aY, float bX, float bY) {
        int dist = MathUtils.round(MathUtils.distance(aX, aY, bX, bY));
        float xStep = (bX - aX) / (float)dist;
        float yStep = (bY - aY) / (float)dist;
        for (int i2 = 0; i2 < dist; ++i2) {
            int y;
            int x2 = MathUtils.round(aX + (float)i2 * xStep);
            if (!this.image.get(x2, y = MathUtils.round(aY + (float)i2 * yStep))) continue;
            return new ResultPoint(x2, y);
        }
        return null;
    }

    private ResultPoint[] centerEdges(ResultPoint y, ResultPoint z, ResultPoint x2, ResultPoint t2) {
        float yi = y.getX();
        float yj = y.getY();
        float zi = z.getX();
        float zj = z.getY();
        float xi = x2.getX();
        float xj = x2.getY();
        float ti = t2.getX();
        float tj = t2.getY();
        if (yi < (float)this.width / 2.0f) {
            return new ResultPoint[]{new ResultPoint(ti - 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj + 1.0f), new ResultPoint(xi - 1.0f, xj - 1.0f), new ResultPoint(yi + 1.0f, yj - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(ti + 1.0f, tj + 1.0f), new ResultPoint(zi + 1.0f, zj - 1.0f), new ResultPoint(xi - 1.0f, xj + 1.0f), new ResultPoint(yi - 1.0f, yj - 1.0f)};
    }

    private boolean containsBlackPoint(int a2, int b2, int fixed, boolean horizontal) {
        if (horizontal) {
            for (int x2 = a2; x2 <= b2; ++x2) {
                if (!this.image.get(x2, fixed)) continue;
                return true;
            }
        } else {
            for (int y = a2; y <= b2; ++y) {
                if (!this.image.get(fixed, y)) continue;
                return true;
            }
        }
        return false;
    }
}

