/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.GenericGFPoly;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF field) {
        this.field = field;
    }

    public void decode(int[] received, int twoS) throws ReedSolomonException {
        GenericGFPoly poly = new GenericGFPoly(this.field, received);
        int[] syndromeCoefficients = new int[twoS];
        boolean noError = true;
        for (int i2 = 0; i2 < twoS; ++i2) {
            int eval;
            syndromeCoefficients[syndromeCoefficients.length - 1 - i2] = eval = poly.evaluateAt(this.field.exp(i2 + this.field.getGeneratorBase()));
            if (eval == 0) continue;
            noError = false;
        }
        if (noError) {
            return;
        }
        GenericGFPoly syndrome = new GenericGFPoly(this.field, syndromeCoefficients);
        GenericGFPoly[] sigmaOmega = this.runEuclideanAlgorithm(this.field.buildMonomial(twoS, 1), syndrome, twoS);
        GenericGFPoly sigma = sigmaOmega[0];
        GenericGFPoly omega = sigmaOmega[1];
        int[] errorLocations = this.findErrorLocations(sigma);
        int[] errorMagnitudes = this.findErrorMagnitudes(omega, errorLocations);
        for (int i3 = 0; i3 < errorLocations.length; ++i3) {
            int position = received.length - 1 - this.field.log(errorLocations[i3]);
            if (position < 0) {
                throw new ReedSolomonException("Bad error location");
            }
            received[position] = GenericGF.addOrSubtract(received[position], errorMagnitudes[i3]);
        }
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly a2, GenericGFPoly b2, int R) throws ReedSolomonException {
        if (a2.getDegree() < b2.getDegree()) {
            GenericGFPoly temp = a2;
            a2 = b2;
            b2 = temp;
        }
        GenericGFPoly rLast = a2;
        GenericGFPoly r2 = b2;
        GenericGFPoly tLast = this.field.getZero();
        GenericGFPoly t2 = this.field.getOne();
        while (r2.getDegree() >= R / 2) {
            GenericGFPoly rLastLast = rLast;
            GenericGFPoly tLastLast = tLast;
            rLast = r2;
            tLast = t2;
            if (rLast.isZero()) {
                throw new ReedSolomonException("r_{i-1} was zero");
            }
            r2 = rLastLast;
            GenericGFPoly q2 = this.field.getZero();
            int denominatorLeadingTerm = rLast.getCoefficient(rLast.getDegree());
            int dltInverse = this.field.inverse(denominatorLeadingTerm);
            while (r2.getDegree() >= rLast.getDegree() && !r2.isZero()) {
                int degreeDiff = r2.getDegree() - rLast.getDegree();
                int scale = this.field.multiply(r2.getCoefficient(r2.getDegree()), dltInverse);
                q2 = q2.addOrSubtract(this.field.buildMonomial(degreeDiff, scale));
                r2 = r2.addOrSubtract(rLast.multiplyByMonomial(degreeDiff, scale));
            }
            t2 = q2.multiply(tLast).addOrSubtract(tLastLast);
            if (r2.getDegree() < rLast.getDegree()) continue;
            throw new IllegalStateException("Division algorithm failed to reduce polynomial?");
        }
        int sigmaTildeAtZero = t2.getCoefficient(0);
        if (sigmaTildeAtZero == 0) {
            throw new ReedSolomonException("sigmaTilde(0) was zero");
        }
        int inverse = this.field.inverse(sigmaTildeAtZero);
        GenericGFPoly sigma = t2.multiply(inverse);
        GenericGFPoly omega = r2.multiply(inverse);
        return new GenericGFPoly[]{sigma, omega};
    }

    private int[] findErrorLocations(GenericGFPoly errorLocator) throws ReedSolomonException {
        int numErrors = errorLocator.getDegree();
        if (numErrors == 1) {
            return new int[]{errorLocator.getCoefficient(1)};
        }
        int[] result = new int[numErrors];
        int e2 = 0;
        for (int i2 = 1; i2 < this.field.getSize() && e2 < numErrors; ++i2) {
            if (errorLocator.evaluateAt(i2) != 0) continue;
            result[e2] = this.field.inverse(i2);
            ++e2;
        }
        if (e2 != numErrors) {
            throw new ReedSolomonException("Error locator degree does not match number of roots");
        }
        return result;
    }

    private int[] findErrorMagnitudes(GenericGFPoly errorEvaluator, int[] errorLocations) {
        int s2 = errorLocations.length;
        int[] result = new int[s2];
        for (int i2 = 0; i2 < s2; ++i2) {
            int xiInverse = this.field.inverse(errorLocations[i2]);
            int denominator = 1;
            for (int j2 = 0; j2 < s2; ++j2) {
                if (i2 == j2) continue;
                int term = this.field.multiply(errorLocations[j2], xiInverse);
                int termPlus1 = (term & 1) == 0 ? term | 1 : term & 0xFFFFFFFE;
                denominator = this.field.multiply(denominator, termPlus1);
            }
            result[i2] = this.field.multiply(errorEvaluator.evaluateAt(xiInverse), this.field.inverse(denominator));
            if (this.field.getGeneratorBase() == 0) continue;
            result[i2] = this.field.multiply(result[i2], xiInverse);
        }
        return result;
    }
}

