/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.awt.geom;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.FlatteningPathIterator;
import com.itextpdf.awt.geom.IllegalPathStateException;
import com.itextpdf.awt.geom.PathIterator;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.awt.geom.Rectangle;
import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.awt.geom.Shape;
import com.itextpdf.awt.geom.gl.Crossing;
import com.itextpdf.awt.geom.misc.Messages;
import java.util.NoSuchElementException;

public final class GeneralPath
implements Shape,
Cloneable {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    private static final int BUFFER_SIZE = 10;
    private static final int BUFFER_CAPACITY = 10;
    byte[] types;
    float[] points;
    int typeSize;
    int pointSize;
    int rule;
    static int[] pointShift = new int[]{2, 2, 4, 6, 0};

    public GeneralPath() {
        this(1, 10);
    }

    public GeneralPath(int rule) {
        this(rule, 10);
    }

    public GeneralPath(int rule, int initialCapacity) {
        this.setWindingRule(rule);
        this.types = new byte[initialCapacity];
        this.points = new float[initialCapacity * 2];
    }

    public GeneralPath(Shape shape) {
        this(1, 10);
        PathIterator p2 = shape.getPathIterator(null);
        this.setWindingRule(p2.getWindingRule());
        this.append(p2, false);
    }

    public void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException(Messages.getString("awt.209"));
        }
        this.rule = rule;
    }

    public int getWindingRule() {
        return this.rule;
    }

    void checkBuf(int pointCount, boolean checkMove) {
        Object[] tmp;
        if (checkMove && this.typeSize == 0) {
            throw new IllegalPathStateException(Messages.getString("awt.20A"));
        }
        if (this.typeSize == this.types.length) {
            tmp = new byte[this.typeSize + 10];
            System.arraycopy(this.types, 0, tmp, 0, this.typeSize);
            this.types = tmp;
        }
        if (this.pointSize + pointCount > this.points.length) {
            tmp = new float[this.pointSize + Math.max(20, pointCount)];
            System.arraycopy(this.points, 0, tmp, 0, this.pointSize);
            this.points = tmp;
        }
    }

    public void moveTo(float x2, float y) {
        if (this.typeSize > 0 && this.types[this.typeSize - 1] == 0) {
            this.points[this.pointSize - 2] = x2;
            this.points[this.pointSize - 1] = y;
        } else {
            this.checkBuf(2, false);
            this.types[this.typeSize++] = 0;
            this.points[this.pointSize++] = x2;
            this.points[this.pointSize++] = y;
        }
    }

    public void lineTo(float x2, float y) {
        this.checkBuf(2, true);
        this.types[this.typeSize++] = 1;
        this.points[this.pointSize++] = x2;
        this.points[this.pointSize++] = y;
    }

    public void quadTo(float x1, float y1, float x2, float y2) {
        this.checkBuf(4, true);
        this.types[this.typeSize++] = 2;
        this.points[this.pointSize++] = x1;
        this.points[this.pointSize++] = y1;
        this.points[this.pointSize++] = x2;
        this.points[this.pointSize++] = y2;
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.checkBuf(6, true);
        this.types[this.typeSize++] = 3;
        this.points[this.pointSize++] = x1;
        this.points[this.pointSize++] = y1;
        this.points[this.pointSize++] = x2;
        this.points[this.pointSize++] = y2;
        this.points[this.pointSize++] = x3;
        this.points[this.pointSize++] = y3;
    }

    public void closePath() {
        if (this.typeSize == 0 || this.types[this.typeSize - 1] != 4) {
            this.checkBuf(0, true);
            this.types[this.typeSize++] = 4;
        }
    }

    public void append(Shape shape, boolean connect) {
        PathIterator p2 = shape.getPathIterator(null);
        this.append(p2, connect);
    }

    public void append(PathIterator path, boolean connect) {
        while (!path.isDone()) {
            float[] coords = new float[6];
            switch (path.currentSegment(coords)) {
                case 0: {
                    if (!connect || this.typeSize == 0) {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    if (this.types[this.typeSize - 1] != 4 && this.points[this.pointSize - 2] == coords[0] && this.points[this.pointSize - 1] == coords[1]) break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            path.next();
            connect = false;
        }
    }

    public Point2D getCurrentPoint() {
        if (this.typeSize == 0) {
            return null;
        }
        int j2 = this.pointSize - 2;
        if (this.types[this.typeSize - 1] == 4) {
            byte type;
            for (int i2 = this.typeSize - 2; i2 > 0 && (type = this.types[i2]) != 0; --i2) {
                j2 -= pointShift[type];
            }
        }
        return new Point2D.Float(this.points[j2], this.points[j2 + 1]);
    }

    public void reset() {
        this.typeSize = 0;
        this.pointSize = 0;
    }

    public void transform(AffineTransform t2) {
        t2.transform(this.points, 0, this.points, 0, this.pointSize / 2);
    }

    public Shape createTransformedShape(AffineTransform t2) {
        GeneralPath p2 = (GeneralPath)this.clone();
        if (t2 != null) {
            p2.transform(t2);
        }
        return p2;
    }

    public Rectangle2D getBounds2D() {
        float rx1;
        float ry1;
        float rx2;
        float ry2;
        if (this.pointSize == 0) {
            ry2 = 0.0f;
            rx2 = 0.0f;
            ry1 = 0.0f;
            rx1 = 0.0f;
        } else {
            int i2 = this.pointSize - 1;
            ry1 = ry2 = this.points[i2--];
            rx1 = rx2 = this.points[i2--];
            while (i2 > 0) {
                float y = this.points[i2--];
                int n2 = i2--;
                float x2 = this.points[n2];
                if (x2 < rx1) {
                    rx1 = x2;
                } else if (x2 > rx2) {
                    rx2 = x2;
                }
                if (y < ry1) {
                    ry1 = y;
                    continue;
                }
                if (!(y > ry2)) continue;
                ry2 = y;
            }
        }
        return new Rectangle2D.Float(rx1, ry1, rx2 - rx1, ry2 - ry1);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    boolean isInside(int cross) {
        if (this.rule == 1) {
            return Crossing.isInsideNonZero(cross);
        }
        return Crossing.isInsideEvenOdd(cross);
    }

    public boolean contains(double px, double py) {
        return this.isInside(Crossing.crossShape(this, px, py));
    }

    public boolean contains(double rx, double ry, double rw, double rh) {
        int cross = Crossing.intersectShape(this, rx, ry, rw, rh);
        return cross != 255 && this.isInside(cross);
    }

    public boolean intersects(double rx, double ry, double rw, double rh) {
        int cross = Crossing.intersectShape(this, rx, ry, rw, rh);
        return cross == 255 || this.isInside(cross);
    }

    public boolean contains(Point2D p2) {
        return this.contains(p2.getX(), p2.getY());
    }

    public boolean contains(Rectangle2D r2) {
        return this.contains(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public boolean intersects(Rectangle2D r2) {
        return this.intersects(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform t2) {
        return new Iterator(this, t2);
    }

    public PathIterator getPathIterator(AffineTransform t2, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(t2), flatness);
    }

    public Object clone() {
        try {
            GeneralPath p2 = (GeneralPath)super.clone();
            p2.types = (byte[])this.types.clone();
            p2.points = (float[])this.points.clone();
            return p2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    class Iterator
    implements PathIterator {
        int typeIndex;
        int pointIndex;
        GeneralPath p;
        AffineTransform t;

        Iterator(GeneralPath path) {
            this(path, null);
        }

        Iterator(GeneralPath path, AffineTransform at) {
            this.p = path;
            this.t = at;
        }

        public int getWindingRule() {
            return this.p.getWindingRule();
        }

        public boolean isDone() {
            return this.typeIndex >= this.p.typeSize;
        }

        public void next() {
            ++this.typeIndex;
        }

        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            byte type = this.p.types[this.typeIndex];
            int count = pointShift[type];
            for (int i2 = 0; i2 < count; ++i2) {
                coords[i2] = this.p.points[this.pointIndex + i2];
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count / 2);
            }
            this.pointIndex += count;
            return type;
        }

        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            byte type = this.p.types[this.typeIndex];
            int count = pointShift[type];
            System.arraycopy(this.p.points, this.pointIndex, coords, 0, count);
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, count / 2);
            }
            this.pointIndex += count;
            return type;
        }
    }
}

