/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.controller.PdfReaderController;
import com.itextpdf.rups.model.ObjectLoader;
import com.itextpdf.rups.model.TreeNodeFactory;
import com.itextpdf.rups.view.PageSelectionListener;
import com.itextpdf.rups.view.itext.PageEnumerator;
import com.itextpdf.rups.view.itext.treenodes.PdfObjectTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfPageTreeNode;
import com.itextpdf.rups.view.itext.treenodes.PdfTrailerTreeNode;
import com.itextpdf.rups.view.models.JTableAutoModel;
import com.itextpdf.rups.view.models.JTableAutoModelInterface;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfPageLabels;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;

public class PagesTable
extends JTable
implements JTableAutoModelInterface,
Observer {
    protected ArrayList<PdfPageTreeNode> list = new ArrayList();
    protected PdfReaderController controller;
    protected PageSelectionListener listener;
    private static final long serialVersionUID = -6523261089453886508L;

    public PagesTable(PdfReaderController controller, PageSelectionListener listener) {
        this.controller = controller;
        this.listener = listener;
    }

    public void update(Observable observable, Object obj) {
        if (obj == null) {
            this.list = new ArrayList();
            this.repaint();
            return;
        }
        if (obj instanceof ObjectLoader) {
            ObjectLoader loader = (ObjectLoader)obj;
            String[] pagelabels = PdfPageLabels.getPageLabels(loader.getReader());
            int i2 = 0;
            TreeNodeFactory factory = loader.getNodes();
            PdfTrailerTreeNode trailer = this.controller.getPdfTree().getRoot();
            PdfObjectTreeNode catalog = factory.getChildNode(trailer, PdfName.ROOT);
            PageEnumerator p2 = new PageEnumerator((PdfDictionary)catalog.getPdfObject(), factory);
            while (p2.hasMoreElements()) {
                PdfPageTreeNode child = (PdfPageTreeNode)p2.nextElement();
                StringBuffer buf = new StringBuffer("Page ");
                buf.append(++i2);
                if (pagelabels != null) {
                    buf.append(" ( ");
                    buf.append(pagelabels[i2 - 1]);
                    buf.append(" )");
                }
                child.setUserObject(buf.toString());
                this.list.add(child);
            }
        }
        this.setModel(new JTableAutoModel(this));
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.list.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.getRowCount() == 0) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return "Object " + this.list.get(rowIndex).getNumber();
            }
            case 1: {
                return this.list.get(rowIndex);
            }
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Object";
            }
            case 1: {
                return "Page";
            }
        }
        return null;
    }

    public void valueChanged(ListSelectionEvent evt) {
        int selectedRow;
        if (evt != null) {
            super.valueChanged(evt);
        }
        if (this.controller == null) {
            return;
        }
        if (this.getRowCount() > 0 && (selectedRow = this.getSelectedRow()) >= 0) {
            this.controller.selectNode(this.list.get(selectedRow));
            if (this.listener != null) {
                this.listener.gotoPage(this.getSelectedRow() + 1);
            }
        }
    }
}

