/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.CFFFont;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFFFontSubset
extends CFFFont {
    static final String[] SubrsFunctions = new String[]{"RESERVED_0", "hstem", "RESERVED_2", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "RESERVED_9", "callsubr", "return", "escape", "RESERVED_13", "endchar", "RESERVED_15", "RESERVED_16", "RESERVED_17", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "shortint", "callgsubr", "vhcurveto", "hvcurveto"};
    static final String[] SubrsEscapeFuncs = new String[]{"RESERVED_0", "RESERVED_1", "RESERVED_2", "and", "or", "not", "RESERVED_6", "RESERVED_7", "RESERVED_8", "abs", "add", "sub", "div", "RESERVED_13", "neg", "eq", "RESERVED_16", "RESERVED_17", "drop", "RESERVED_19", "put", "get", "ifelse", "random", "mul", "RESERVED_25", "sqrt", "dup", "exch", "index", "roll", "RESERVED_31", "RESERVED_32", "RESERVED_33", "hflex", "flex", "hflex1", "flex1", "RESERVED_REST"};
    static final byte ENDCHAR_OP = 14;
    static final byte RETURN_OP = 11;
    HashMap<Integer, int[]> GlyphsUsed;
    ArrayList<Integer> glyphsInList;
    HashSet<Integer> FDArrayUsed = new HashSet();
    HashMap<Integer, int[]>[] hSubrsUsed;
    ArrayList<Integer>[] lSubrsUsed;
    HashMap<Integer, int[]> hGSubrsUsed = new HashMap();
    ArrayList<Integer> lGSubrsUsed = new ArrayList();
    HashMap<Integer, int[]> hSubrsUsedNonCID = new HashMap();
    ArrayList<Integer> lSubrsUsedNonCID = new ArrayList();
    byte[][] NewLSubrsIndex;
    byte[] NewSubrsIndexNonCID;
    byte[] NewGSubrsIndex;
    byte[] NewCharStringsIndex;
    int GBias = 0;
    LinkedList<CFFFont.Item> OutputList;
    int NumOfHints = 0;

    public CFFFontSubset(RandomAccessFileOrArray rf, HashMap<Integer, int[]> GlyphsUsed) {
        super(rf);
        this.GlyphsUsed = GlyphsUsed;
        this.glyphsInList = new ArrayList<Integer>(GlyphsUsed.keySet());
        for (int i2 = 0; i2 < this.fonts.length; ++i2) {
            this.seek(this.fonts[i2].charstringsOffset);
            this.fonts[i2].nglyphs = this.getCard16();
            this.seek(this.stringIndexOffset);
            this.fonts[i2].nstrings = this.getCard16() + standardStrings.length;
            this.fonts[i2].charstringsOffsets = this.getIndex(this.fonts[i2].charstringsOffset);
            if (this.fonts[i2].fdselectOffset >= 0) {
                this.readFDSelect(i2);
                this.BuildFDArrayUsed(i2);
            }
            if (this.fonts[i2].isCID) {
                this.ReadFDArray(i2);
            }
            this.fonts[i2].CharsetLength = this.CountCharset(this.fonts[i2].charsetOffset, this.fonts[i2].nglyphs);
        }
    }

    int CountCharset(int Offset2, int NumofGlyphs) {
        int Length2 = 0;
        this.seek(Offset2);
        char format = this.getCard8();
        switch (format) {
            case '\u0000': {
                Length2 = 1 + 2 * NumofGlyphs;
                break;
            }
            case '\u0001': {
                Length2 = 1 + 3 * this.CountRange(NumofGlyphs, 1);
                break;
            }
            case '\u0002': {
                Length2 = 1 + 4 * this.CountRange(NumofGlyphs, 2);
                break;
            }
        }
        return Length2;
    }

    int CountRange(int NumofGlyphs, int Type2) {
        char nLeft;
        int num = 0;
        for (int i2 = 1; i2 < NumofGlyphs; i2 += nLeft + '\u0001') {
            ++num;
            char Sid = this.getCard16();
            nLeft = Type2 == 1 ? this.getCard8() : this.getCard16();
        }
        return num;
    }

    protected void readFDSelect(int Font2) {
        int NumOfGlyphs = this.fonts[Font2].nglyphs;
        int[] FDSelect = new int[NumOfGlyphs];
        this.seek(this.fonts[Font2].fdselectOffset);
        this.fonts[Font2].FDSelectFormat = this.getCard8();
        switch (this.fonts[Font2].FDSelectFormat) {
            case 0: {
                for (int i2 = 0; i2 < NumOfGlyphs; ++i2) {
                    FDSelect[i2] = this.getCard8();
                }
                this.fonts[Font2].FDSelectLength = this.fonts[Font2].nglyphs + 1;
                break;
            }
            case 3: {
                int nRanges = this.getCard16();
                int l2 = 0;
                char first = this.getCard16();
                for (int i3 = 0; i3 < nRanges; ++i3) {
                    char fd = this.getCard8();
                    char last = this.getCard16();
                    int steps = last - first;
                    for (int k2 = 0; k2 < steps; ++k2) {
                        FDSelect[l2] = fd;
                        ++l2;
                    }
                    first = last;
                }
                this.fonts[Font2].FDSelectLength = 3 + nRanges * 3 + 2;
                break;
            }
        }
        this.fonts[Font2].FDSelect = FDSelect;
    }

    protected void BuildFDArrayUsed(int Font2) {
        int[] FDSelect = this.fonts[Font2].FDSelect;
        for (int i2 = 0; i2 < this.glyphsInList.size(); ++i2) {
            int glyph = this.glyphsInList.get(i2);
            int FD = FDSelect[glyph];
            this.FDArrayUsed.add(FD);
        }
    }

    protected void ReadFDArray(int Font2) {
        this.seek(this.fonts[Font2].fdarrayOffset);
        this.fonts[Font2].FDArrayCount = this.getCard16();
        this.fonts[Font2].FDArrayOffsize = this.getCard8();
        if (this.fonts[Font2].FDArrayOffsize < 4) {
            ++this.fonts[Font2].FDArrayOffsize;
        }
        this.fonts[Font2].FDArrayOffsets = this.getIndex(this.fonts[Font2].fdarrayOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] Process(String fontName) throws IOException {
        try {
            byte[] Ret;
            int j2;
            this.buf.reOpen();
            for (j2 = 0; j2 < this.fonts.length && !fontName.equals(this.fonts[j2].name); ++j2) {
            }
            if (j2 == this.fonts.length) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.gsubrIndexOffset >= 0) {
                this.GBias = this.CalcBias(this.gsubrIndexOffset, j2);
            }
            this.BuildNewCharString(j2);
            this.BuildNewLGSubrs(j2);
            byte[] byArray = Ret = this.BuildNewFile(j2);
            return byArray;
        }
        finally {
            try {
                this.buf.close();
            }
            catch (Exception e2) {}
        }
    }

    protected int CalcBias(int Offset2, int Font2) {
        this.seek(Offset2);
        char nSubrs = this.getCard16();
        if (this.fonts[Font2].CharstringType == 1) {
            return 0;
        }
        if (nSubrs < '\u04d8') {
            return 107;
        }
        if (nSubrs < '\u846c') {
            return 1131;
        }
        return 32768;
    }

    protected void BuildNewCharString(int FontIndex) throws IOException {
        this.NewCharStringsIndex = this.BuildNewIndex(this.fonts[FontIndex].charstringsOffsets, this.GlyphsUsed, (byte)14);
    }

    protected void BuildNewLGSubrs(int Font2) throws IOException {
        if (this.fonts[Font2].isCID) {
            this.hSubrsUsed = new HashMap[this.fonts[Font2].fdprivateOffsets.length];
            this.lSubrsUsed = new ArrayList[this.fonts[Font2].fdprivateOffsets.length];
            this.NewLSubrsIndex = new byte[this.fonts[Font2].fdprivateOffsets.length][];
            this.fonts[Font2].PrivateSubrsOffset = new int[this.fonts[Font2].fdprivateOffsets.length];
            this.fonts[Font2].PrivateSubrsOffsetsArray = new int[this.fonts[Font2].fdprivateOffsets.length][];
            ArrayList<Integer> FDInList = new ArrayList<Integer>(this.FDArrayUsed);
            for (int j2 = 0; j2 < FDInList.size(); ++j2) {
                int FD = FDInList.get(j2);
                this.hSubrsUsed[FD] = new HashMap();
                this.lSubrsUsed[FD] = new ArrayList();
                this.BuildFDSubrsOffsets(Font2, FD);
                if (this.fonts[Font2].PrivateSubrsOffset[FD] < 0) continue;
                this.BuildSubrUsed(Font2, FD, this.fonts[Font2].PrivateSubrsOffset[FD], this.fonts[Font2].PrivateSubrsOffsetsArray[FD], this.hSubrsUsed[FD], this.lSubrsUsed[FD]);
                this.NewLSubrsIndex[FD] = this.BuildNewIndex(this.fonts[Font2].PrivateSubrsOffsetsArray[FD], this.hSubrsUsed[FD], (byte)11);
            }
        } else if (this.fonts[Font2].privateSubrs >= 0) {
            this.fonts[Font2].SubrsOffsets = this.getIndex(this.fonts[Font2].privateSubrs);
            this.BuildSubrUsed(Font2, -1, this.fonts[Font2].privateSubrs, this.fonts[Font2].SubrsOffsets, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID);
        }
        this.BuildGSubrsUsed(Font2);
        if (this.fonts[Font2].privateSubrs >= 0) {
            this.NewSubrsIndexNonCID = this.BuildNewIndex(this.fonts[Font2].SubrsOffsets, this.hSubrsUsedNonCID, (byte)11);
        }
        this.NewGSubrsIndex = this.BuildNewIndex(this.gsubrOffsets, this.hGSubrsUsed, (byte)11);
    }

    protected void BuildFDSubrsOffsets(int Font2, int FD) {
        this.fonts[Font2].PrivateSubrsOffset[FD] = -1;
        this.seek(this.fonts[Font2].fdprivateOffsets[FD]);
        while (this.getPosition() < this.fonts[Font2].fdprivateOffsets[FD] + this.fonts[Font2].fdprivateLengths[FD]) {
            this.getDictItem();
            if (this.key != "Subrs") continue;
            this.fonts[Font2].PrivateSubrsOffset[FD] = (Integer)this.args[0] + this.fonts[Font2].fdprivateOffsets[FD];
        }
        if (this.fonts[Font2].PrivateSubrsOffset[FD] >= 0) {
            this.fonts[Font2].PrivateSubrsOffsetsArray[FD] = this.getIndex(this.fonts[Font2].PrivateSubrsOffset[FD]);
        }
    }

    protected void BuildSubrUsed(int Font2, int FD, int SubrOffset, int[] SubrsOffsets, HashMap<Integer, int[]> hSubr, ArrayList<Integer> lSubr) {
        int End2;
        int Start2;
        int i2;
        int LBias = this.CalcBias(SubrOffset, Font2);
        for (i2 = 0; i2 < this.glyphsInList.size(); ++i2) {
            int glyph = this.glyphsInList.get(i2);
            Start2 = this.fonts[Font2].charstringsOffsets[glyph];
            End2 = this.fonts[Font2].charstringsOffsets[glyph + 1];
            if (FD >= 0) {
                this.EmptyStack();
                this.NumOfHints = 0;
                int GlyphFD = this.fonts[Font2].FDSelect[glyph];
                if (GlyphFD != FD) continue;
                this.ReadASubr(Start2, End2, this.GBias, LBias, hSubr, lSubr, SubrsOffsets);
                continue;
            }
            this.ReadASubr(Start2, End2, this.GBias, LBias, hSubr, lSubr, SubrsOffsets);
        }
        for (i2 = 0; i2 < lSubr.size(); ++i2) {
            int Subr = lSubr.get(i2);
            if (Subr >= SubrsOffsets.length - 1 || Subr < 0) continue;
            Start2 = SubrsOffsets[Subr];
            End2 = SubrsOffsets[Subr + 1];
            this.ReadASubr(Start2, End2, this.GBias, LBias, hSubr, lSubr, SubrsOffsets);
        }
    }

    protected void BuildGSubrsUsed(int Font2) {
        int LBias = 0;
        int SizeOfNonCIDSubrsUsed = 0;
        if (this.fonts[Font2].privateSubrs >= 0) {
            LBias = this.CalcBias(this.fonts[Font2].privateSubrs, Font2);
            SizeOfNonCIDSubrsUsed = this.lSubrsUsedNonCID.size();
        }
        for (int i2 = 0; i2 < this.lGSubrsUsed.size(); ++i2) {
            int Subr = this.lGSubrsUsed.get(i2);
            if (Subr >= this.gsubrOffsets.length - 1 || Subr < 0) continue;
            int Start2 = this.gsubrOffsets[Subr];
            int End2 = this.gsubrOffsets[Subr + 1];
            if (this.fonts[Font2].isCID) {
                this.ReadASubr(Start2, End2, this.GBias, 0, this.hGSubrsUsed, this.lGSubrsUsed, null);
                continue;
            }
            this.ReadASubr(Start2, End2, this.GBias, LBias, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID, this.fonts[Font2].SubrsOffsets);
            if (SizeOfNonCIDSubrsUsed >= this.lSubrsUsedNonCID.size()) continue;
            for (int j2 = SizeOfNonCIDSubrsUsed; j2 < this.lSubrsUsedNonCID.size(); ++j2) {
                int LSubr = this.lSubrsUsedNonCID.get(j2);
                if (LSubr >= this.fonts[Font2].SubrsOffsets.length - 1 || LSubr < 0) continue;
                int LStart = this.fonts[Font2].SubrsOffsets[LSubr];
                int LEnd = this.fonts[Font2].SubrsOffsets[LSubr + 1];
                this.ReadASubr(LStart, LEnd, this.GBias, LBias, this.hSubrsUsedNonCID, this.lSubrsUsedNonCID, this.fonts[Font2].SubrsOffsets);
            }
            SizeOfNonCIDSubrsUsed = this.lSubrsUsedNonCID.size();
        }
    }

    protected void ReadASubr(int begin, int end, int GBias, int LBias, HashMap<Integer, int[]> hSubr, ArrayList<Integer> lSubr, int[] LSubrsOffsets) {
        this.EmptyStack();
        this.NumOfHints = 0;
        this.seek(begin);
        while (this.getPosition() < end) {
            int Subr;
            this.ReadCommand();
            int pos = this.getPosition();
            Object TopElement = null;
            if (this.arg_count > 0) {
                TopElement = this.args[this.arg_count - 1];
            }
            int NumOfArgs = this.arg_count;
            this.HandelStack();
            if (this.key == "callsubr") {
                if (NumOfArgs <= 0) continue;
                Subr = (Integer)TopElement + LBias;
                if (!hSubr.containsKey(Subr)) {
                    hSubr.put(Subr, null);
                    lSubr.add(Subr);
                }
                this.CalcHints(LSubrsOffsets[Subr], LSubrsOffsets[Subr + 1], LBias, GBias, LSubrsOffsets);
                this.seek(pos);
                continue;
            }
            if (this.key == "callgsubr") {
                if (NumOfArgs <= 0) continue;
                Subr = (Integer)TopElement + GBias;
                if (!this.hGSubrsUsed.containsKey(Subr)) {
                    this.hGSubrsUsed.put(Subr, null);
                    this.lGSubrsUsed.add(Subr);
                }
                this.CalcHints(this.gsubrOffsets[Subr], this.gsubrOffsets[Subr + 1], LBias, GBias, LSubrsOffsets);
                this.seek(pos);
                continue;
            }
            if (this.key == "hstem" || this.key == "vstem" || this.key == "hstemhm" || this.key == "vstemhm") {
                this.NumOfHints += NumOfArgs / 2;
                continue;
            }
            if (this.key != "hintmask" && this.key != "cntrmask") continue;
            int SizeOfMask = this.NumOfHints / 8;
            if (this.NumOfHints % 8 != 0 || SizeOfMask == 0) {
                ++SizeOfMask;
            }
            for (int i2 = 0; i2 < SizeOfMask; ++i2) {
                this.getCard8();
            }
        }
    }

    protected void HandelStack() {
        int StackHandel = this.StackOpp();
        if (StackHandel < 2) {
            if (StackHandel == 1) {
                this.PushStack();
            } else {
                StackHandel *= -1;
                for (int i2 = 0; i2 < StackHandel; ++i2) {
                    this.PopStack();
                }
            }
        } else {
            this.EmptyStack();
        }
    }

    protected int StackOpp() {
        if (this.key == "ifelse") {
            return -3;
        }
        if (this.key == "roll" || this.key == "put") {
            return -2;
        }
        if (this.key == "callsubr" || this.key == "callgsubr" || this.key == "add" || this.key == "sub" || this.key == "div" || this.key == "mul" || this.key == "drop" || this.key == "and" || this.key == "or" || this.key == "eq") {
            return -1;
        }
        if (this.key == "abs" || this.key == "neg" || this.key == "sqrt" || this.key == "exch" || this.key == "index" || this.key == "get" || this.key == "not" || this.key == "return") {
            return 0;
        }
        if (this.key == "random" || this.key == "dup") {
            return 1;
        }
        return 2;
    }

    protected void EmptyStack() {
        for (int i2 = 0; i2 < this.arg_count; ++i2) {
            this.args[i2] = null;
        }
        this.arg_count = 0;
    }

    protected void PopStack() {
        if (this.arg_count > 0) {
            this.args[this.arg_count - 1] = null;
            --this.arg_count;
        }
    }

    protected void PushStack() {
        ++this.arg_count;
    }

    protected void ReadCommand() {
        this.key = null;
        boolean gotKey = false;
        while (!gotKey) {
            char w2;
            char second;
            char first;
            char b0 = this.getCard8();
            if (b0 == '\u001c') {
                first = this.getCard8();
                second = this.getCard8();
                this.args[this.arg_count] = first << 8 | second;
                ++this.arg_count;
                continue;
            }
            if (b0 >= ' ' && b0 <= '\u00f6') {
                this.args[this.arg_count] = b0 - 139;
                ++this.arg_count;
                continue;
            }
            if (b0 >= '\u00f7' && b0 <= '\u00fa') {
                w2 = this.getCard8();
                this.args[this.arg_count] = (b0 - 247) * 256 + w2 + 108;
                ++this.arg_count;
                continue;
            }
            if (b0 >= '\u00fb' && b0 <= '\u00fe') {
                w2 = this.getCard8();
                this.args[this.arg_count] = -(b0 - 251) * 256 - w2 - 108;
                ++this.arg_count;
                continue;
            }
            if (b0 == '\u00ff') {
                first = this.getCard8();
                second = this.getCard8();
                char third = this.getCard8();
                char fourth = this.getCard8();
                this.args[this.arg_count] = first << 24 | second << 16 | third << 8 | fourth;
                ++this.arg_count;
                continue;
            }
            if (b0 > '\u001f' || b0 == '\u001c') continue;
            gotKey = true;
            if (b0 == '\f') {
                int b1 = this.getCard8();
                if (b1 > SubrsEscapeFuncs.length - 1) {
                    b1 = SubrsEscapeFuncs.length - 1;
                }
                this.key = SubrsEscapeFuncs[b1];
                continue;
            }
            this.key = SubrsFunctions[b0];
        }
    }

    protected int CalcHints(int begin, int end, int LBias, int GBias, int[] LSubrsOffsets) {
        this.seek(begin);
        while (this.getPosition() < end) {
            int Subr;
            this.ReadCommand();
            int pos = this.getPosition();
            Object TopElement = null;
            if (this.arg_count > 0) {
                TopElement = this.args[this.arg_count - 1];
            }
            int NumOfArgs = this.arg_count;
            this.HandelStack();
            if (this.key == "callsubr") {
                if (NumOfArgs <= 0) continue;
                Subr = (Integer)TopElement + LBias;
                this.CalcHints(LSubrsOffsets[Subr], LSubrsOffsets[Subr + 1], LBias, GBias, LSubrsOffsets);
                this.seek(pos);
                continue;
            }
            if (this.key == "callgsubr") {
                if (NumOfArgs <= 0) continue;
                Subr = (Integer)TopElement + GBias;
                this.CalcHints(this.gsubrOffsets[Subr], this.gsubrOffsets[Subr + 1], LBias, GBias, LSubrsOffsets);
                this.seek(pos);
                continue;
            }
            if (this.key == "hstem" || this.key == "vstem" || this.key == "hstemhm" || this.key == "vstemhm") {
                this.NumOfHints += NumOfArgs / 2;
                continue;
            }
            if (this.key != "hintmask" && this.key != "cntrmask") continue;
            int SizeOfMask = this.NumOfHints / 8;
            if (this.NumOfHints % 8 != 0 || SizeOfMask == 0) {
                ++SizeOfMask;
            }
            for (int i2 = 0; i2 < SizeOfMask; ++i2) {
                this.getCard8();
            }
        }
        return this.NumOfHints;
    }

    protected byte[] BuildNewIndex(int[] Offsets, HashMap<Integer, int[]> Used, byte OperatorForUnusedEntries) throws IOException {
        int unusedCount = 0;
        int Offset2 = 0;
        int[] NewOffsets = new int[Offsets.length];
        for (int i2 = 0; i2 < Offsets.length; ++i2) {
            NewOffsets[i2] = Offset2;
            if (Used.containsKey(i2)) {
                Offset2 += Offsets[i2 + 1] - Offsets[i2];
                continue;
            }
            ++unusedCount;
        }
        byte[] NewObjects = new byte[Offset2 + unusedCount];
        int unusedOffset = 0;
        for (int i3 = 0; i3 < Offsets.length - 1; ++i3) {
            int start = NewOffsets[i3];
            int end = NewOffsets[i3 + 1];
            NewOffsets[i3] = start + unusedOffset;
            if (start != end) {
                this.buf.seek(Offsets[i3]);
                this.buf.readFully(NewObjects, start + unusedOffset, end - start);
                continue;
            }
            NewObjects[start + unusedOffset] = OperatorForUnusedEntries;
            ++unusedOffset;
        }
        int n2 = Offsets.length - 1;
        NewOffsets[n2] = NewOffsets[n2] + unusedOffset;
        return this.AssembleIndex(NewOffsets, NewObjects);
    }

    protected byte[] AssembleIndex(int[] NewOffsets, byte[] NewObjects) {
        char Count2 = (char)(NewOffsets.length - 1);
        int Size = NewOffsets[NewOffsets.length - 1];
        int Offsize = Size <= 255 ? 1 : (Size <= 65535 ? 2 : (Size <= 0xFFFFFF ? 3 : 4));
        byte[] NewIndex = new byte[3 + Offsize * (Count2 + '\u0001') + NewObjects.length];
        int Place2 = 0;
        NewIndex[Place2++] = (byte)(Count2 >>> 8 & 0xFF);
        NewIndex[Place2++] = (byte)(Count2 >>> 0 & 0xFF);
        NewIndex[Place2++] = Offsize;
        for (int newOffset : NewOffsets) {
            int Num = newOffset - NewOffsets[0] + 1;
            switch (Offsize) {
                case 4: {
                    NewIndex[Place2++] = (byte)(Num >>> 24 & 0xFF);
                }
                case 3: {
                    NewIndex[Place2++] = (byte)(Num >>> 16 & 0xFF);
                }
                case 2: {
                    NewIndex[Place2++] = (byte)(Num >>> 8 & 0xFF);
                }
                case 1: {
                    NewIndex[Place2++] = (byte)(Num >>> 0 & 0xFF);
                }
            }
        }
        for (byte newObject : NewObjects) {
            NewIndex[Place2++] = newObject;
        }
        return NewIndex;
    }

    protected byte[] BuildNewFile(int Font2) {
        this.OutputList = new LinkedList();
        this.CopyHeader();
        this.BuildIndexHeader(1, 1, 1);
        this.OutputList.addLast(new CFFFont.UInt8Item((char)(1 + this.fonts[Font2].name.length())));
        this.OutputList.addLast(new CFFFont.StringItem(this.fonts[Font2].name));
        this.BuildIndexHeader(1, 2, 1);
        CFFFont.IndexOffsetItem topdictIndex1Ref = new CFFFont.IndexOffsetItem(2);
        this.OutputList.addLast(topdictIndex1Ref);
        CFFFont.IndexBaseItem topdictBase = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(topdictBase);
        CFFFont.DictOffsetItem charsetRef = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem charstringsRef = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem fdarrayRef = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem fdselectRef = new CFFFont.DictOffsetItem();
        CFFFont.DictOffsetItem privateRef = new CFFFont.DictOffsetItem();
        if (!this.fonts[Font2].isCID) {
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[Font2].nstrings));
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[Font2].nstrings + 1));
            this.OutputList.addLast(new CFFFont.DictNumberItem(0));
            this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
            this.OutputList.addLast(new CFFFont.UInt8Item('\u001e'));
            this.OutputList.addLast(new CFFFont.DictNumberItem(this.fonts[Font2].nglyphs));
            this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
            this.OutputList.addLast(new CFFFont.UInt8Item('\"'));
        }
        this.seek(this.topdictOffsets[Font2]);
        while (this.getPosition() < this.topdictOffsets[Font2 + 1]) {
            int p1 = this.getPosition();
            this.getDictItem();
            int p2 = this.getPosition();
            if (this.key == "Encoding" || this.key == "Private" || this.key == "FDSelect" || this.key == "FDArray" || this.key == "charset" || this.key == "CharStrings") continue;
            this.OutputList.add(new CFFFont.RangeItem(this.buf, p1, p2 - p1));
        }
        this.CreateKeys(fdarrayRef, fdselectRef, charsetRef, charstringsRef);
        this.OutputList.addLast(new CFFFont.IndexMarkerItem(topdictIndex1Ref, topdictBase));
        if (this.fonts[Font2].isCID) {
            this.OutputList.addLast(this.getEntireIndexRange(this.stringIndexOffset));
        } else {
            this.CreateNewStringIndex(Font2);
        }
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewGSubrsIndex), 0, this.NewGSubrsIndex.length));
        if (this.fonts[Font2].isCID) {
            this.OutputList.addLast(new CFFFont.MarkerItem(fdselectRef));
            if (this.fonts[Font2].fdselectOffset >= 0) {
                this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.fonts[Font2].fdselectOffset, this.fonts[Font2].FDSelectLength));
            } else {
                this.CreateFDSelect(fdselectRef, this.fonts[Font2].nglyphs);
            }
            this.OutputList.addLast(new CFFFont.MarkerItem(charsetRef));
            this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.fonts[Font2].charsetOffset, this.fonts[Font2].CharsetLength));
            if (this.fonts[Font2].fdarrayOffset >= 0) {
                this.OutputList.addLast(new CFFFont.MarkerItem(fdarrayRef));
                this.Reconstruct(Font2);
            } else {
                this.CreateFDArray(fdarrayRef, privateRef, Font2);
            }
        } else {
            this.CreateFDSelect(fdselectRef, this.fonts[Font2].nglyphs);
            this.CreateCharset(charsetRef, this.fonts[Font2].nglyphs);
            this.CreateFDArray(fdarrayRef, privateRef, Font2);
        }
        if (this.fonts[Font2].privateOffset >= 0) {
            CFFFont.IndexBaseItem PrivateBase = new CFFFont.IndexBaseItem();
            this.OutputList.addLast(PrivateBase);
            this.OutputList.addLast(new CFFFont.MarkerItem(privateRef));
            CFFFont.DictOffsetItem Subr = new CFFFont.DictOffsetItem();
            this.CreateNonCIDPrivate(Font2, Subr);
            this.CreateNonCIDSubrs(Font2, PrivateBase, Subr);
        }
        this.OutputList.addLast(new CFFFont.MarkerItem(charstringsRef));
        this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewCharStringsIndex), 0, this.NewCharStringsIndex.length));
        int[] currentOffset = new int[]{0};
        for (CFFFont.Item item : this.OutputList) {
            item.increment(currentOffset);
        }
        for (CFFFont.Item item : this.OutputList) {
            item.xref();
        }
        int size = currentOffset[0];
        byte[] b2 = new byte[size];
        for (CFFFont.Item item : this.OutputList) {
            item.emit(b2);
        }
        return b2;
    }

    protected void CopyHeader() {
        this.seek(0);
        char major = this.getCard8();
        char minor = this.getCard8();
        char hdrSize = this.getCard8();
        char offSize = this.getCard8();
        this.nextIndexOffset = hdrSize;
        this.OutputList.addLast(new CFFFont.RangeItem(this.buf, 0, hdrSize));
    }

    protected void BuildIndexHeader(int Count2, int Offsize, int First2) {
        this.OutputList.addLast(new CFFFont.UInt16Item((char)Count2));
        this.OutputList.addLast(new CFFFont.UInt8Item((char)Offsize));
        switch (Offsize) {
            case 1: {
                this.OutputList.addLast(new CFFFont.UInt8Item((char)First2));
                break;
            }
            case 2: {
                this.OutputList.addLast(new CFFFont.UInt16Item((char)First2));
                break;
            }
            case 3: {
                this.OutputList.addLast(new CFFFont.UInt24Item((char)First2));
                break;
            }
            case 4: {
                this.OutputList.addLast(new CFFFont.UInt32Item((char)First2));
                break;
            }
        }
    }

    protected void CreateKeys(CFFFont.OffsetItem fdarrayRef, CFFFont.OffsetItem fdselectRef, CFFFont.OffsetItem charsetRef, CFFFont.OffsetItem charstringsRef) {
        this.OutputList.addLast(fdarrayRef);
        this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
        this.OutputList.addLast(new CFFFont.UInt8Item('$'));
        this.OutputList.addLast(fdselectRef);
        this.OutputList.addLast(new CFFFont.UInt8Item('\f'));
        this.OutputList.addLast(new CFFFont.UInt8Item('%'));
        this.OutputList.addLast(charsetRef);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u000f'));
        this.OutputList.addLast(charstringsRef);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0011'));
    }

    protected void CreateNewStringIndex(int Font2) {
        String fdFontName = this.fonts[Font2].name + "-OneRange";
        if (fdFontName.length() > 127) {
            fdFontName = fdFontName.substring(0, 127);
        }
        String extraStrings = "AdobeIdentity" + fdFontName;
        int origStringsLen = this.stringOffsets[this.stringOffsets.length - 1] - this.stringOffsets[0];
        int stringsBaseOffset = this.stringOffsets[0] - 1;
        int stringsIndexOffSize = origStringsLen + extraStrings.length() <= 255 ? 1 : (origStringsLen + extraStrings.length() <= 65535 ? 2 : (origStringsLen + extraStrings.length() <= 0xFFFFFF ? 3 : 4));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)(this.stringOffsets.length - 1 + 3)));
        this.OutputList.addLast(new CFFFont.UInt8Item((char)stringsIndexOffSize));
        for (int stringOffset : this.stringOffsets) {
            this.OutputList.addLast(new CFFFont.IndexOffsetItem(stringsIndexOffSize, stringOffset - stringsBaseOffset));
        }
        int currentStringsOffset = this.stringOffsets[this.stringOffsets.length - 1] - stringsBaseOffset;
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(stringsIndexOffSize, currentStringsOffset += "Adobe".length()));
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(stringsIndexOffSize, currentStringsOffset += "Identity".length()));
        this.OutputList.addLast(new CFFFont.IndexOffsetItem(stringsIndexOffSize, currentStringsOffset += fdFontName.length()));
        this.OutputList.addLast(new CFFFont.RangeItem(this.buf, this.stringOffsets[0], origStringsLen));
        this.OutputList.addLast(new CFFFont.StringItem(extraStrings));
    }

    protected void CreateFDSelect(CFFFont.OffsetItem fdselectRef, int nglyphs) {
        this.OutputList.addLast(new CFFFont.MarkerItem(fdselectRef));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0003'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0001'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0000'));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0000'));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)nglyphs));
    }

    protected void CreateCharset(CFFFont.OffsetItem charsetRef, int nglyphs) {
        this.OutputList.addLast(new CFFFont.MarkerItem(charsetRef));
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0002'));
        this.OutputList.addLast(new CFFFont.UInt16Item('\u0001'));
        this.OutputList.addLast(new CFFFont.UInt16Item((char)(nglyphs - 1)));
    }

    protected void CreateFDArray(CFFFont.OffsetItem fdarrayRef, CFFFont.OffsetItem privateRef, int Font2) {
        this.OutputList.addLast(new CFFFont.MarkerItem(fdarrayRef));
        this.BuildIndexHeader(1, 1, 1);
        CFFFont.IndexOffsetItem privateIndex1Ref = new CFFFont.IndexOffsetItem(1);
        this.OutputList.addLast(privateIndex1Ref);
        CFFFont.IndexBaseItem privateBase = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(privateBase);
        int NewSize = this.fonts[Font2].privateLength;
        int OrgSubrsOffsetSize = this.CalcSubrOffsetSize(this.fonts[Font2].privateOffset, this.fonts[Font2].privateLength);
        if (OrgSubrsOffsetSize != 0) {
            NewSize += 5 - OrgSubrsOffsetSize;
        }
        this.OutputList.addLast(new CFFFont.DictNumberItem(NewSize));
        this.OutputList.addLast(privateRef);
        this.OutputList.addLast(new CFFFont.UInt8Item('\u0012'));
        this.OutputList.addLast(new CFFFont.IndexMarkerItem(privateIndex1Ref, privateBase));
    }

    void Reconstruct(int Font2) {
        CFFFont.OffsetItem[] fdPrivate = new CFFFont.DictOffsetItem[this.fonts[Font2].FDArrayOffsets.length - 1];
        CFFFont.IndexBaseItem[] fdPrivateBase = new CFFFont.IndexBaseItem[this.fonts[Font2].fdprivateOffsets.length];
        CFFFont.OffsetItem[] fdSubrs = new CFFFont.DictOffsetItem[this.fonts[Font2].fdprivateOffsets.length];
        this.ReconstructFDArray(Font2, fdPrivate);
        this.ReconstructPrivateDict(Font2, fdPrivate, fdPrivateBase, fdSubrs);
        this.ReconstructPrivateSubrs(Font2, fdPrivateBase, fdSubrs);
    }

    void ReconstructFDArray(int Font2, CFFFont.OffsetItem[] fdPrivate) {
        this.BuildIndexHeader(this.fonts[Font2].FDArrayCount, this.fonts[Font2].FDArrayOffsize, 1);
        CFFFont.IndexOffsetItem[] fdOffsets = new CFFFont.IndexOffsetItem[this.fonts[Font2].FDArrayOffsets.length - 1];
        for (int i2 = 0; i2 < this.fonts[Font2].FDArrayOffsets.length - 1; ++i2) {
            fdOffsets[i2] = new CFFFont.IndexOffsetItem(this.fonts[Font2].FDArrayOffsize);
            this.OutputList.addLast(fdOffsets[i2]);
        }
        CFFFont.IndexBaseItem fdArrayBase = new CFFFont.IndexBaseItem();
        this.OutputList.addLast(fdArrayBase);
        for (int k2 = 0; k2 < this.fonts[Font2].FDArrayOffsets.length - 1; ++k2) {
            this.seek(this.fonts[Font2].FDArrayOffsets[k2]);
            while (this.getPosition() < this.fonts[Font2].FDArrayOffsets[k2 + 1]) {
                int p1 = this.getPosition();
                this.getDictItem();
                int p2 = this.getPosition();
                if (this.key == "Private") {
                    int NewSize = (Integer)this.args[0];
                    int OrgSubrsOffsetSize = this.CalcSubrOffsetSize(this.fonts[Font2].fdprivateOffsets[k2], this.fonts[Font2].fdprivateLengths[k2]);
                    if (OrgSubrsOffsetSize != 0) {
                        NewSize += 5 - OrgSubrsOffsetSize;
                    }
                    this.OutputList.addLast(new CFFFont.DictNumberItem(NewSize));
                    fdPrivate[k2] = new CFFFont.DictOffsetItem();
                    this.OutputList.addLast(fdPrivate[k2]);
                    this.OutputList.addLast(new CFFFont.UInt8Item('\u0012'));
                    this.seek(p2);
                    continue;
                }
                this.OutputList.addLast(new CFFFont.RangeItem(this.buf, p1, p2 - p1));
            }
            this.OutputList.addLast(new CFFFont.IndexMarkerItem(fdOffsets[k2], fdArrayBase));
        }
    }

    void ReconstructPrivateDict(int Font2, CFFFont.OffsetItem[] fdPrivate, CFFFont.IndexBaseItem[] fdPrivateBase, CFFFont.OffsetItem[] fdSubrs) {
        for (int i2 = 0; i2 < this.fonts[Font2].fdprivateOffsets.length; ++i2) {
            this.OutputList.addLast(new CFFFont.MarkerItem(fdPrivate[i2]));
            fdPrivateBase[i2] = new CFFFont.IndexBaseItem();
            this.OutputList.addLast(fdPrivateBase[i2]);
            this.seek(this.fonts[Font2].fdprivateOffsets[i2]);
            while (this.getPosition() < this.fonts[Font2].fdprivateOffsets[i2] + this.fonts[Font2].fdprivateLengths[i2]) {
                int p1 = this.getPosition();
                this.getDictItem();
                int p2 = this.getPosition();
                if (this.key == "Subrs") {
                    fdSubrs[i2] = new CFFFont.DictOffsetItem();
                    this.OutputList.addLast(fdSubrs[i2]);
                    this.OutputList.addLast(new CFFFont.UInt8Item('\u0013'));
                    continue;
                }
                this.OutputList.addLast(new CFFFont.RangeItem(this.buf, p1, p2 - p1));
            }
        }
    }

    void ReconstructPrivateSubrs(int Font2, CFFFont.IndexBaseItem[] fdPrivateBase, CFFFont.OffsetItem[] fdSubrs) {
        for (int i2 = 0; i2 < this.fonts[Font2].fdprivateLengths.length; ++i2) {
            if (fdSubrs[i2] == null || this.fonts[Font2].PrivateSubrsOffset[i2] < 0) continue;
            this.OutputList.addLast(new CFFFont.SubrMarkerItem(fdSubrs[i2], fdPrivateBase[i2]));
            if (this.NewLSubrsIndex[i2] == null) continue;
            this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewLSubrsIndex[i2]), 0, this.NewLSubrsIndex[i2].length));
        }
    }

    int CalcSubrOffsetSize(int Offset2, int Size) {
        int OffsetSize = 0;
        this.seek(Offset2);
        while (this.getPosition() < Offset2 + Size) {
            int p1 = this.getPosition();
            this.getDictItem();
            int p2 = this.getPosition();
            if (this.key != "Subrs") continue;
            OffsetSize = p2 - p1 - 1;
        }
        return OffsetSize;
    }

    protected int countEntireIndexRange(int indexOffset) {
        this.seek(indexOffset);
        char count = this.getCard16();
        if (count == '\u0000') {
            return 2;
        }
        char indexOffSize = this.getCard8();
        this.seek(indexOffset + 2 + 1 + count * indexOffSize);
        int size = this.getOffset(indexOffSize) - 1;
        return 3 + (count + '\u0001') * indexOffSize + size;
    }

    void CreateNonCIDPrivate(int Font2, CFFFont.OffsetItem Subr) {
        this.seek(this.fonts[Font2].privateOffset);
        while (this.getPosition() < this.fonts[Font2].privateOffset + this.fonts[Font2].privateLength) {
            int p1 = this.getPosition();
            this.getDictItem();
            int p2 = this.getPosition();
            if (this.key == "Subrs") {
                this.OutputList.addLast(Subr);
                this.OutputList.addLast(new CFFFont.UInt8Item('\u0013'));
                continue;
            }
            this.OutputList.addLast(new CFFFont.RangeItem(this.buf, p1, p2 - p1));
        }
    }

    void CreateNonCIDSubrs(int Font2, CFFFont.IndexBaseItem PrivateBase, CFFFont.OffsetItem Subrs) {
        this.OutputList.addLast(new CFFFont.SubrMarkerItem(Subrs, PrivateBase));
        if (this.NewSubrsIndexNonCID != null) {
            this.OutputList.addLast(new CFFFont.RangeItem(new RandomAccessFileOrArray(this.NewSubrsIndexNonCID), 0, this.NewSubrsIndexNonCID.length));
        }
    }
}

