/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMYKColor;
import com.itextpdf.text.pdf.ColorDetails;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.ICachedColorSpace;
import com.itextpdf.text.pdf.IPdfSpecialColorSpace;
import com.itextpdf.text.pdf.LabColor;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfFunction;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfSpotColor
implements ICachedColorSpace,
IPdfSpecialColorSpace {
    public PdfName name;
    public BaseColor altcs;
    public ColorDetails altColorDetails;

    public PdfSpotColor(String name, BaseColor altcs) {
        this.name = new PdfName(name);
        this.altcs = altcs;
    }

    public ColorDetails[] getColorantDetails(PdfWriter writer) {
        if (this.altColorDetails == null && this.altcs instanceof ExtendedColor && ((ExtendedColor)this.altcs).getType() == 7) {
            this.altColorDetails = writer.addSimple(((LabColor)this.altcs).getLabColorSpace());
        }
        return new ColorDetails[]{this.altColorDetails};
    }

    public BaseColor getAlternativeCS() {
        return this.altcs;
    }

    public PdfName getName() {
        return this.name;
    }

    @Deprecated
    protected PdfObject getSpotObject(PdfWriter writer) {
        return this.getPdfObject(writer);
    }

    public PdfObject getPdfObject(PdfWriter writer) {
        PdfArray array = new PdfArray(PdfName.SEPARATION);
        array.add(this.name);
        PdfFunction func = null;
        if (this.altcs instanceof ExtendedColor) {
            int type = ((ExtendedColor)this.altcs).type;
            switch (type) {
                case 1: {
                    array.add(PdfName.DEVICEGRAY);
                    func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{1.0f}, new float[]{((GrayColor)this.altcs).getGray()}, 1.0f);
                    break;
                }
                case 2: {
                    array.add(PdfName.DEVICECMYK);
                    CMYKColor cmyk = (CMYKColor)this.altcs;
                    func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, new float[]{cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack()}, 1.0f);
                    break;
                }
                case 7: {
                    LabColor lab = (LabColor)this.altcs;
                    if (this.altColorDetails != null) {
                        array.add(this.altColorDetails.getIndirectReference());
                    } else {
                        array.add(lab.getLabColorSpace().getPdfObject(writer));
                    }
                    func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{100.0f, 0.0f, 0.0f}, new float[]{lab.getL(), lab.getA(), lab.getB()}, 1.0f);
                    break;
                }
                default: {
                    throw new RuntimeException(MessageLocalization.getComposedMessage("only.rgb.gray.and.cmyk.are.supported.as.alternative.color.spaces", new Object[0]));
                }
            }
        } else {
            array.add(PdfName.DEVICERGB);
            func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{1.0f, 1.0f, 1.0f}, new float[]{(float)this.altcs.getRed() / 255.0f, (float)this.altcs.getGreen() / 255.0f, (float)this.altcs.getBlue() / 255.0f}, 1.0f);
        }
        array.add(func.getReference());
        return array;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof PdfSpotColor)) {
            return false;
        }
        PdfSpotColor spotColor = (PdfSpotColor)o2;
        if (!this.altcs.equals(spotColor.altcs)) {
            return false;
        }
        return this.name.equals(spotColor.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.altcs.hashCode();
        return result;
    }
}

