/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.hyphenation;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.hyphenation.Hyphen;
import com.itextpdf.text.pdf.hyphenation.PatternConsumer;
import com.itextpdf.text.xml.simpleparser.SimpleXMLDocHandler;
import com.itextpdf.text.xml.simpleparser.SimpleXMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePatternParser
implements SimpleXMLDocHandler,
PatternConsumer {
    int currElement;
    PatternConsumer consumer;
    StringBuffer token = new StringBuffer();
    ArrayList<Object> exception;
    char hyphenChar = (char)45;
    SimpleXMLParser parser;
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;

    public void parse(InputStream stream, PatternConsumer consumer) {
        this.consumer = consumer;
        try {
            SimpleXMLParser.parse((SimpleXMLDocHandler)this, stream);
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception e3) {}
        }
    }

    protected static String getPattern(String word) {
        StringBuffer pat = new StringBuffer();
        int len = word.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isDigit(word.charAt(i2))) continue;
            pat.append(word.charAt(i2));
        }
        return pat.toString();
    }

    protected ArrayList<Object> normalizeException(ArrayList<Object> ex) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i2 = 0; i2 < ex.size(); ++i2) {
            Object item = ex.get(i2);
            if (item instanceof String) {
                String str = (String)item;
                StringBuffer buf = new StringBuffer();
                for (int j2 = 0; j2 < str.length(); ++j2) {
                    char c2 = str.charAt(j2);
                    if (c2 != this.hyphenChar) {
                        buf.append(c2);
                        continue;
                    }
                    res.add(buf.toString());
                    buf.setLength(0);
                    char[] h2 = new char[]{this.hyphenChar};
                    res.add(new Hyphen(new String(h2), null, null));
                }
                if (buf.length() <= 0) continue;
                res.add(buf.toString());
                continue;
            }
            res.add(item);
        }
        return res;
    }

    protected String getExceptionWord(ArrayList<Object> ex) {
        StringBuffer res = new StringBuffer();
        for (int i2 = 0; i2 < ex.size(); ++i2) {
            Object item = ex.get(i2);
            if (item instanceof String) {
                res.append((String)item);
                continue;
            }
            if (((Hyphen)item).noBreak == null) continue;
            res.append(((Hyphen)item).noBreak);
        }
        return res.toString();
    }

    protected static String getInterletterValues(String pat) {
        StringBuffer il = new StringBuffer();
        String word = pat + "a";
        int len = word.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = word.charAt(i2);
            if (Character.isDigit(c2)) {
                il.append(c2);
                ++i2;
                continue;
            }
            il.append('0');
        }
        return il.toString();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String tag) {
        if (this.token.length() > 0) {
            String word = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(SimplePatternParser.getPattern(word), SimplePatternParser.getInterletterValues(word));
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String tag, Map<String, String> h2) {
        if (tag.equals("hyphen-char")) {
            String hh = h2.get("value");
            if (hh != null && hh.length() == 1) {
                this.hyphenChar = hh.charAt(0);
            }
        } else if (tag.equals("classes")) {
            this.currElement = 1;
        } else if (tag.equals("patterns")) {
            this.currElement = 3;
        } else if (tag.equals("exceptions")) {
            this.currElement = 2;
            this.exception = new ArrayList();
        } else if (tag.equals("hyphen")) {
            if (this.token.length() > 0) {
                this.exception.add(this.token.toString());
            }
            this.exception.add(new Hyphen(h2.get("pre"), h2.get("no"), h2.get("post")));
            this.currElement = 4;
        }
        this.token.setLength(0);
    }

    @Override
    public void text(String str) {
        StringTokenizer tk = new StringTokenizer(str);
        while (tk.hasMoreTokens()) {
            String word = tk.nextToken();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    this.exception.clear();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(SimplePatternParser.getPattern(word), SimplePatternParser.getInterletterValues(word));
                }
            }
        }
    }

    @Override
    public void addClass(String c2) {
        System.out.println("class: " + c2);
    }

    @Override
    public void addException(String w2, ArrayList<Object> e2) {
        System.out.println("exception: " + w2 + " : " + e2.toString());
    }

    @Override
    public void addPattern(String p2, String v2) {
        System.out.println("pattern: " + p2 + " : " + v2);
    }
}

