/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.hyphenation;

import com.itextpdf.text.pdf.hyphenation.CharVector;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TernaryTree
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5313366505322983510L;
    protected char[] lo;
    protected char[] hi;
    protected char[] eq;
    protected char[] sc;
    protected CharVector kv;
    protected char root;
    protected char freenode;
    protected int length;
    protected static final int BLOCK_SIZE = 2048;

    TernaryTree() {
        this.init();
    }

    protected void init() {
        this.root = '\u0000';
        this.freenode = '\u0001';
        this.length = 0;
        this.lo = new char[2048];
        this.hi = new char[2048];
        this.eq = new char[2048];
        this.sc = new char[2048];
        this.kv = new CharVector();
    }

    public void insert(String key, char val) {
        int len = key.length() + 1;
        if (this.freenode + len > this.eq.length) {
            this.redimNodeArrays(this.eq.length + 2048);
        }
        char[] strkey = new char[len--];
        key.getChars(0, len, strkey, 0);
        strkey[len] = '\u0000';
        this.root = this.insert(this.root, strkey, 0, val);
    }

    public void insert(char[] key, int start, char val) {
        int len = TernaryTree.strlen(key) + 1;
        if (this.freenode + len > this.eq.length) {
            this.redimNodeArrays(this.eq.length + 2048);
        }
        this.root = this.insert(this.root, key, start, val);
    }

    private char insert(char p2, char[] key, int start, char val) {
        char s2;
        int len = TernaryTree.strlen(key, start);
        if (p2 == '\u0000') {
            char c2 = this.freenode;
            this.freenode = (char)(c2 + '\u0001');
            p2 = c2;
            this.eq[p2] = val;
            ++this.length;
            this.hi[p2] = '\u0000';
            if (len > 0) {
                this.sc[p2] = 65535;
                this.lo[p2] = (char)this.kv.alloc(len + 1);
                TernaryTree.strcpy(this.kv.getArray(), this.lo[p2], key, start);
            } else {
                this.sc[p2] = '\u0000';
                this.lo[p2] = '\u0000';
            }
            return p2;
        }
        if (this.sc[p2] == '\uffff') {
            char c3 = this.freenode;
            this.freenode = (char)(c3 + '\u0001');
            char pp = c3;
            this.lo[pp] = this.lo[p2];
            this.eq[pp] = this.eq[p2];
            this.lo[p2] = '\u0000';
            if (len > 0) {
                this.sc[p2] = this.kv.get(this.lo[pp]);
                this.eq[p2] = pp;
                char c4 = pp;
                this.lo[c4] = (char)(this.lo[c4] + '\u0001');
                if (this.kv.get(this.lo[pp]) == '\u0000') {
                    this.lo[pp] = '\u0000';
                    this.sc[pp] = '\u0000';
                    this.hi[pp] = '\u0000';
                } else {
                    this.sc[pp] = 65535;
                }
            } else {
                this.sc[pp] = 65535;
                this.hi[p2] = pp;
                this.sc[p2] = '\u0000';
                this.eq[p2] = val;
                ++this.length;
                return p2;
            }
        }
        if ((s2 = key[start]) < this.sc[p2]) {
            this.lo[p2] = this.insert(this.lo[p2], key, start, val);
        } else if (s2 == this.sc[p2]) {
            this.eq[p2] = s2 != '\u0000' ? this.insert(this.eq[p2], key, start + 1, val) : val;
        } else {
            this.hi[p2] = this.insert(this.hi[p2], key, start, val);
        }
        return p2;
    }

    public static int strcmp(char[] a2, int startA, char[] b2, int startB) {
        while (a2[startA] == b2[startB]) {
            if (a2[startA] == '\u0000') {
                return 0;
            }
            ++startA;
            ++startB;
        }
        return a2[startA] - b2[startB];
    }

    public static int strcmp(String str, char[] a2, int start) {
        int i2;
        int len = str.length();
        for (i2 = 0; i2 < len; ++i2) {
            int d2 = str.charAt(i2) - a2[start + i2];
            if (d2 != 0) {
                return d2;
            }
            if (a2[start + i2] != '\u0000') continue;
            return d2;
        }
        if (a2[start + i2] != '\u0000') {
            return -a2[start + i2];
        }
        return 0;
    }

    public static void strcpy(char[] dst, int di, char[] src, int si) {
        while (src[si] != '\u0000') {
            dst[di++] = src[si++];
        }
        dst[di] = '\u0000';
    }

    public static int strlen(char[] a2, int start) {
        int len = 0;
        for (int i2 = start; i2 < a2.length && a2[i2] != '\u0000'; ++i2) {
            ++len;
        }
        return len;
    }

    public static int strlen(char[] a2) {
        return TernaryTree.strlen(a2, 0);
    }

    public int find(String key) {
        int len = key.length();
        char[] strkey = new char[len + 1];
        key.getChars(0, len, strkey, 0);
        strkey[len] = '\u0000';
        return this.find(strkey, 0);
    }

    public int find(char[] key, int start) {
        char p2 = this.root;
        int i2 = start;
        while (p2 != '\u0000') {
            if (this.sc[p2] == '\uffff') {
                if (TernaryTree.strcmp(key, i2, this.kv.getArray(), this.lo[p2]) == 0) {
                    return this.eq[p2];
                }
                return -1;
            }
            char c2 = key[i2];
            int d2 = c2 - this.sc[p2];
            if (d2 == 0) {
                if (c2 == '\u0000') {
                    return this.eq[p2];
                }
                ++i2;
                p2 = this.eq[p2];
                continue;
            }
            if (d2 < 0) {
                p2 = this.lo[p2];
                continue;
            }
            p2 = this.hi[p2];
        }
        return -1;
    }

    public boolean knows(String key) {
        return this.find(key) >= 0;
    }

    private void redimNodeArrays(int newsize) {
        int len = newsize < this.lo.length ? newsize : this.lo.length;
        char[] na = new char[newsize];
        System.arraycopy(this.lo, 0, na, 0, len);
        this.lo = na;
        na = new char[newsize];
        System.arraycopy(this.hi, 0, na, 0, len);
        this.hi = na;
        na = new char[newsize];
        System.arraycopy(this.eq, 0, na, 0, len);
        this.eq = na;
        na = new char[newsize];
        System.arraycopy(this.sc, 0, na, 0, len);
        this.sc = na;
    }

    public int size() {
        return this.length;
    }

    public Object clone() {
        TernaryTree t2 = new TernaryTree();
        t2.lo = (char[])this.lo.clone();
        t2.hi = (char[])this.hi.clone();
        t2.eq = (char[])this.eq.clone();
        t2.sc = (char[])this.sc.clone();
        t2.kv = (CharVector)this.kv.clone();
        t2.root = this.root;
        t2.freenode = this.freenode;
        t2.length = this.length;
        return t2;
    }

    protected void insertBalanced(String[] k2, char[] v2, int offset, int n2) {
        if (n2 < 1) {
            return;
        }
        int m2 = n2 >> 1;
        this.insert(k2[m2 + offset], v2[m2 + offset]);
        this.insertBalanced(k2, v2, offset, m2);
        this.insertBalanced(k2, v2, offset + m2 + 1, n2 - m2 - 1);
    }

    public void balance() {
        int i2 = 0;
        int n2 = this.length;
        String[] k2 = new String[n2];
        char[] v2 = new char[n2];
        Iterator iter = new Iterator();
        while (iter.hasMoreElements()) {
            v2[i2] = iter.getValue();
            k2[i2++] = iter.nextElement();
        }
        this.init();
        this.insertBalanced(k2, v2, 0, n2);
    }

    public void trimToSize() {
        this.balance();
        this.redimNodeArrays(this.freenode);
        CharVector kx = new CharVector();
        kx.alloc(1);
        TernaryTree map = new TernaryTree();
        this.compact(kx, map, this.root);
        this.kv = kx;
        this.kv.trimToSize();
    }

    private void compact(CharVector kx, TernaryTree map, char p2) {
        if (p2 == '\u0000') {
            return;
        }
        if (this.sc[p2] == '\uffff') {
            int k2 = map.find(this.kv.getArray(), this.lo[p2]);
            if (k2 < 0) {
                k2 = kx.alloc(TernaryTree.strlen(this.kv.getArray(), this.lo[p2]) + 1);
                TernaryTree.strcpy(kx.getArray(), k2, this.kv.getArray(), this.lo[p2]);
                map.insert(kx.getArray(), k2, (char)k2);
            }
            this.lo[p2] = (char)k2;
        } else {
            this.compact(kx, map, this.lo[p2]);
            if (this.sc[p2] != '\u0000') {
                this.compact(kx, map, this.eq[p2]);
            }
            this.compact(kx, map, this.hi[p2]);
        }
    }

    public Enumeration<String> keys() {
        return new Iterator();
    }

    public void printStats() {
        System.out.println("Number of keys = " + Integer.toString(this.length));
        System.out.println("Node count = " + Integer.toString(this.freenode));
        System.out.println("Key Array length = " + Integer.toString(this.kv.length()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Iterator
    implements Enumeration<String> {
        int cur = -1;
        String curkey;
        Stack<Item> ns = new Stack();
        StringBuffer ks = new StringBuffer();

        public Iterator() {
            this.rewind();
        }

        public void rewind() {
            this.ns.removeAllElements();
            this.ks.setLength(0);
            this.cur = TernaryTree.this.root;
            this.run();
        }

        @Override
        public String nextElement() {
            String res = this.curkey;
            this.cur = this.up();
            this.run();
            return res;
        }

        public char getValue() {
            if (this.cur >= 0) {
                return TernaryTree.this.eq[this.cur];
            }
            return '\u0000';
        }

        @Override
        public boolean hasMoreElements() {
            return this.cur != -1;
        }

        private int up() {
            Item i2 = new Item();
            int res = 0;
            if (this.ns.empty()) {
                return -1;
            }
            if (this.cur != 0 && TernaryTree.this.sc[this.cur] == '\u0000') {
                return TernaryTree.this.lo[this.cur];
            }
            boolean climb = true;
            block4: while (climb) {
                i2 = this.ns.pop();
                i2.child = (char)(i2.child + '\u0001');
                switch (i2.child) {
                    case '\u0001': {
                        if (TernaryTree.this.sc[i2.parent] != '\u0000') {
                            res = TernaryTree.this.eq[i2.parent];
                            this.ns.push(i2.clone());
                            this.ks.append(TernaryTree.this.sc[i2.parent]);
                        } else {
                            i2.child = (char)(i2.child + '\u0001');
                            this.ns.push(i2.clone());
                            res = TernaryTree.this.hi[i2.parent];
                        }
                        climb = false;
                        continue block4;
                    }
                    case '\u0002': {
                        res = TernaryTree.this.hi[i2.parent];
                        this.ns.push(i2.clone());
                        if (this.ks.length() > 0) {
                            this.ks.setLength(this.ks.length() - 1);
                        }
                        climb = false;
                        continue block4;
                    }
                }
                if (this.ns.empty()) {
                    return -1;
                }
                climb = true;
            }
            return res;
        }

        private int run() {
            block9: {
                if (this.cur == -1) {
                    return -1;
                }
                boolean leaf = false;
                while (true) {
                    if (this.cur != 0) {
                        if (TernaryTree.this.sc[this.cur] == '\uffff') {
                            leaf = true;
                        } else {
                            this.ns.push(new Item((char)this.cur, '\u0000'));
                            if (TernaryTree.this.sc[this.cur] == '\u0000') {
                                leaf = true;
                            } else {
                                this.cur = TernaryTree.this.lo[this.cur];
                                continue;
                            }
                        }
                    }
                    if (leaf) break block9;
                    this.cur = this.up();
                    if (this.cur == -1) break;
                }
                return -1;
            }
            StringBuffer buf = new StringBuffer(this.ks.toString());
            if (TernaryTree.this.sc[this.cur] == '\uffff') {
                int p2 = TernaryTree.this.lo[this.cur];
                while (TernaryTree.this.kv.get(p2) != '\u0000') {
                    buf.append(TernaryTree.this.kv.get(p2++));
                }
            }
            this.curkey = buf.toString();
            return 0;
        }

        private class Item
        implements Cloneable {
            char parent;
            char child;

            public Item() {
                this.parent = '\u0000';
                this.child = '\u0000';
            }

            public Item(char p2, char c2) {
                this.parent = p2;
                this.child = c2;
            }

            public Item clone() {
                return new Item(this.parent, this.child);
            }
        }
    }
}

