/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.AFRelationshipValue;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.internal.PdfA2Checker;
import java.util.Arrays;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfA3Checker
extends PdfA2Checker {
    private static HashSet<PdfName> allowedAFRelationships = new HashSet<PdfName>(Arrays.asList(AFRelationshipValue.Source, AFRelationshipValue.Data, AFRelationshipValue.Alternative, AFRelationshipValue.Supplement, AFRelationshipValue.Unspecified));

    PdfA3Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    protected HashSet<PdfName> initKeysForCheck() {
        HashSet<PdfName> keysForCheck = super.initKeysForCheck();
        keysForCheck.add(PdfName.PARAMS);
        keysForCheck.add(PdfName.MODDATE);
        keysForCheck.add(PdfName.F);
        return keysForCheck;
    }

    @Override
    protected void checkFileSpec(PdfWriter writer, int key, Object obj1) {
        if (obj1 instanceof PdfFileSpecification) {
            PdfFileSpecification fileSpec = (PdfFileSpecification)obj1;
            if (!(fileSpec.contains(PdfName.UF) && fileSpec.contains(PdfName.F) && fileSpec.contains(PdfName.DESC))) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage("file.specification.dictionary.shall.contain.f.uf.and.desc.entries", new Object[0]));
            }
            PdfObject obj = fileSpec.get(PdfName.AFRELATIONSHIP);
            if (obj == null || !obj.isName() || !allowedAFRelationships.contains(obj)) {
                throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage("file.specification.dictionary.shall.contain.correct.afrelationship.key", new Object[0]));
            }
            if (fileSpec.contains(PdfName.EF)) {
                PdfDictionary dict = this.getDirectDictionary(fileSpec.get(PdfName.EF));
                if (dict == null || !dict.contains(PdfName.F)) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage("ef.key.of.file.specification.dictionary.shall.contain.dictionary.with.valid.f.key", new Object[0]));
                }
                PdfDictionary embeddedFile = this.getDirectDictionary(dict.get(PdfName.F));
                if (embeddedFile == null) {
                    throw new PdfAConformanceException(obj1, MessageLocalization.getComposedMessage("ef.key.of.file.specification.dictionary.shall.contain.dictionary.with.valid.f.key", new Object[0]));
                }
                this.checkEmbeddedFile(embeddedFile);
            }
        }
    }

    @Override
    protected void checkEmbeddedFile(PdfDictionary embeddedFile) {
        PdfObject modDate;
        PdfObject params = this.getDirectObject(embeddedFile.get(PdfName.PARAMS));
        if (params == null) {
            throw new PdfAConformanceException(embeddedFile, MessageLocalization.getComposedMessage("embedded.file.shall.contain.valid.params.key", new Object[0]));
        }
        if (params.isDictionary() && ((modDate = ((PdfDictionary)params).get(PdfName.MODDATE)) == null || !(modDate instanceof PdfString))) {
            throw new PdfAConformanceException(embeddedFile, MessageLocalization.getComposedMessage("embedded.file.shall.contain.params.key.with.valid.moddate.key", new Object[0]));
        }
    }

    @Override
    protected void checkPdfObject(PdfWriter writer, int key, Object obj1) {
        PdfDictionary dictionary;
        PdfName type;
        super.checkPdfObject(writer, key, obj1);
        if (obj1 instanceof PdfDictionary && PdfName.EMBEDDEDFILE.equals(type = (dictionary = (PdfDictionary)obj1).getAsName(PdfName.TYPE))) {
            this.checkEmbeddedFile(dictionary);
        }
    }
}

