/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.pdfcleanup;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.pdfcleanup.PdfCleanUpGraphicsState;
import java.util.Stack;

class PdfCleanUpContext {
    private PdfDictionary resources;
    private PdfContentByte canvas;
    private Stack<PdfCleanUpGraphicsState> graphicsStateStack = new Stack();

    public PdfCleanUpContext(PdfDictionary resources, PdfContentByte canvas) {
        this.resources = resources;
        this.canvas = canvas;
        this.graphicsStateStack.push(new PdfCleanUpGraphicsState());
    }

    public PdfDictionary getResources() {
        return this.resources;
    }

    public void setResources(PdfDictionary resources) {
        this.resources = resources;
    }

    public PdfContentByte getCanvas() {
        return this.canvas;
    }

    public void setCanvas(PdfContentByte canvas) {
        this.canvas = canvas;
    }

    public float getFontSize() {
        return this.graphicsStateStack.peek().getFontSize();
    }

    public void setFontSize(float fontSize) {
        this.graphicsStateStack.peek().setFontSize(fontSize);
    }

    public float getHorizontalScaling() {
        return this.graphicsStateStack.peek().getHorizontalScaling();
    }

    public void setHorizontalScaling(float horizontalScaling) {
        this.graphicsStateStack.peek().setHorizontalScaling(horizontalScaling);
    }

    public float getCharacterSpacing() {
        return this.graphicsStateStack.peek().getCharacterSpacing();
    }

    public void setCharacterSpacing(float characterSpacing) {
        this.graphicsStateStack.peek().setCharacterSpacing(characterSpacing);
    }

    public float getWordSpacing() {
        return this.graphicsStateStack.peek().getWordSpacing();
    }

    public void setWordSpacing(float wordSpacing) {
        this.graphicsStateStack.peek().setWordSpacing(wordSpacing);
    }

    public void saveGraphicsState() {
        this.graphicsStateStack.push(new PdfCleanUpGraphicsState(this.graphicsStateStack.peek()));
    }

    public void restoreGraphicsState() {
        this.graphicsStateStack.pop();
    }
}

