/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssSelectorItem;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSelector {
    private List<CssSelectorItem> selectorItems;

    public CssSelector(List<CssSelectorItem> selector) {
        this.selectorItems = selector;
    }

    public boolean matches(Tag t2) {
        return this.matches(t2, this.selectorItems.size() - 1);
    }

    private boolean matches(Tag t2, int index) {
        if (t2 == null) {
            return false;
        }
        Stack<CssSelectorItem> currentSelector = new Stack<CssSelectorItem>();
        while (index >= 0 && this.selectorItems.get(index).getSeparator() == '\u0000') {
            currentSelector.push(this.selectorItems.get(index));
            --index;
        }
        while (!currentSelector.empty()) {
            if (((CssSelectorItem)currentSelector.pop()).matches(t2)) continue;
            return false;
        }
        if (index == -1) {
            return true;
        }
        char separator = this.selectorItems.get(index).getSeparator();
        if (separator == '\u0000') {
            return false;
        }
        --index;
        switch (separator) {
            case '>': {
                return this.matches(t2.getParent(), index);
            }
            case ' ': {
                while (t2 != null) {
                    if (this.matches(t2.getParent(), index)) {
                        return true;
                    }
                    t2 = t2.getParent();
                }
                return false;
            }
            case '~': {
                if (!t2.hasParent()) {
                    return false;
                }
                for (int precededIndex = t2.getParent().getChildren().indexOf(t2) - 1; precededIndex >= 0; --precededIndex) {
                    if (!this.matches(t2.getParent().getChildren().get(precededIndex), index)) continue;
                    return true;
                }
                return false;
            }
            case '+': {
                if (!t2.hasParent()) {
                    return false;
                }
                int precededIndex = t2.getParent().getChildren().indexOf(t2) - 1;
                return precededIndex >= 0 && this.matches(t2.getParent().getChildren().get(precededIndex), index);
            }
        }
        return false;
    }

    public int calculateSpecifity() {
        int specifity = 0;
        for (CssSelectorItem item : this.selectorItems) {
            specifity += item.getSpecificity();
        }
        return specifity;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (CssSelectorItem item : this.selectorItems) {
            buf.append(item.toString());
        }
        return buf.toString();
    }
}

