/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Div
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        NoNewLineParagraph noNewLineParagraph = new NoNewLineParagraph();
        ArrayList<Element> l2 = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            Font f2 = this.getCssAppliers().getChunkCssAplier().applyFontStyles(tag);
            sanitized.setFont(f2);
            noNewLineParagraph.add(sanitized);
        }
        if (noNewLineParagraph.size() > 0) {
            try {
                l2.add(this.getCssAppliers().apply(noNewLineParagraph, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e2) {
                throw new RuntimeWorkerException(e2);
            }
        }
        return l2;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            Phrase p2 = null;
            PdfDiv div = (PdfDiv)this.getCssAppliers().apply(new PdfDiv(), tag, this.getHtmlPipelineContext(ctx));
            int direction = this.getRunDirection(tag);
            if (direction != 0) {
                div.setRunDirection(direction);
            }
            for (Element e2 : currentContent) {
                if (e2 instanceof Paragraph || e2 instanceof PdfPTable || e2 instanceof PdfDiv) {
                    if (p2 != null) {
                        if (p2.trim()) {
                            div.addElement(p2);
                        }
                        p2 = null;
                    }
                    div.addElement(e2);
                    continue;
                }
                if (p2 == null) {
                    p2 = new Paragraph();
                    ((Paragraph)p2).setAlignment(div.getTextAlignment());
                    if (direction == 3) {
                        switch (((Paragraph)p2).getAlignment()) {
                            case -1: 
                            case 1: 
                            case 3: 
                            case 8: {
                                break;
                            }
                            case 2: {
                                ((Paragraph)p2).setAlignment(0);
                                break;
                            }
                            default: {
                                ((Paragraph)p2).setAlignment(2);
                            }
                        }
                    }
                    p2.setMultipliedLeading(1.2f);
                }
                ((Paragraph)p2).add(e2);
            }
            if (p2 != null && p2.trim()) {
                div.addElement(p2);
            }
            ArrayList<Element> l2 = new ArrayList<Element>(1);
            l2.add(div);
            return l2;
        }
        catch (NoCustomContextException e3) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e3);
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

