/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.net;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Image;
import com.itextpdf.tool.xml.net.exc.NoImageException;
import com.itextpdf.tool.xml.pipeline.html.ImageProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;

public class ImageRetrieve {
    private final ImageProvider provider;

    public ImageRetrieve(ImageProvider imageProvider) {
        this.provider = imageProvider;
    }

    public ImageRetrieve() {
        this.provider = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Image retrieveImage(String src) throws NoImageException, IOException {
        Image img = null;
        if (null != this.provider) {
            img = this.provider.retrieve(src);
        }
        if (null != img) return img;
        String path = null;
        if (src.startsWith("http")) {
            path = src;
        } else if (null != this.provider) {
            String root = this.provider.getImageRootPath();
            if (null != root) {
                if (root.endsWith("/") && src.startsWith("/")) {
                    root = root.substring(0, root.length() - 1);
                }
                path = root + src;
            }
        } else {
            path = src;
        }
        if (null == path) throw new NoImageException(src);
        try {
            img = path.startsWith("http") ? Image.getInstance(path) : Image.getInstance(new File(path).toURI().toURL());
            if (null == this.provider || null == img) return img;
            this.provider.store(src, img);
            return img;
        }
        catch (BadElementException e2) {
            throw new NoImageException(src, e2);
        }
        catch (MalformedURLException e3) {
            throw new NoImageException(src, e3);
        }
    }
}

