/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline;

import com.itextpdf.tool.xml.CustomContext;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPipeline<T extends CustomContext>
implements Pipeline<T> {
    private Pipeline<?> next;

    public AbstractPipeline(Pipeline<?> next) {
        this.setNext(next);
    }

    @Override
    public Pipeline<?> getNext() {
        return this.next;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t2, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext ctx, Tag currentTag, String text, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t2, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    public T getLocalContext(WorkerContext context) throws PipelineException {
        try {
            CustomContext cc = context.get(this.getContextKey());
            if (null != cc) {
                return (T)cc;
            }
            throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.owncontextmissing"), this.getClass().getName()));
        }
        catch (NoCustomContextException e2) {
            throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.owncontextmissing"), this.getClass().getName()), e2);
        }
    }

    public void setNext(Pipeline<?> next) {
        this.next = next;
    }

    public String getContextKey() {
        return this.getClass().getName();
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        return this.getNext();
    }
}

