/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline.html;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.NoTagProcessorException;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.WritableElement;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.pipeline.html.NoStackException;
import com.itextpdf.tool.xml.pipeline.html.StackKeeper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlPipeline
extends AbstractPipeline<HtmlPipelineContext> {
    private final HtmlPipelineContext hpc;

    public HtmlPipeline(HtmlPipelineContext hpc, Pipeline<?> next) {
        super(next);
        this.hpc = hpc;
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        try {
            HtmlPipelineContext clone = this.hpc.clone();
            context.put(this.getContextKey(), clone);
        }
        catch (CloneNotSupportedException e2) {
            String message = String.format(LocaleMessages.getInstance().getMessage("unsupported.clone"), this.hpc.getClass().toString());
            throw new PipelineException(message, e2);
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t2, ProcessObject po) throws PipelineException {
        block8: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                List<Element> content;
                t2.setLastMarginBottom(hcc.getMemory().get("lastMarginBottom"));
                hcc.getMemory().remove("lastMarginBottom");
                TagProcessor tp = hcc.resolveProcessor(t2.getName(), t2.getNameSpace());
                if (tp.isStackOwner()) {
                    hcc.addFirst(new StackKeeper(t2));
                }
                if ((content = tp.startElement(context, t2)).size() <= 0) break block8;
                if (tp.isStackOwner()) {
                    try {
                        StackKeeper peek = hcc.peek();
                        for (Element elem : content) {
                            peek.add(elem);
                        }
                        break block8;
                    }
                    catch (NoStackException e2) {
                        throw new PipelineException(String.format("pipeline.html.missingstack", t2.toString()), e2);
                    }
                }
                for (Element elem : content) {
                    hcc.currentContent().add(elem);
                }
            }
            catch (NoTagProcessorException e3) {
                if (hcc.acceptUnknown()) break block8;
                throw e3;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t2, String text, ProcessObject po) throws PipelineException {
        block6: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                TagProcessor tp = hcc.resolveProcessor(t2.getName(), t2.getNameSpace());
                List<Element> elems = tp.content(context, t2, text);
                if (elems.size() <= 0) break block6;
                try {
                    StackKeeper peek = hcc.peek();
                    for (Element e2 : elems) {
                        peek.add(e2);
                    }
                }
                catch (NoStackException e3) {
                    WritableElement writableElement = new WritableElement();
                    for (Element elem : elems) {
                        writableElement.add(elem);
                    }
                    po.add(writableElement);
                }
            }
            catch (NoTagProcessorException e4) {
                if (hcc.acceptUnknown()) break block6;
                throw e4;
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t2, ProcessObject po) throws PipelineException {
        block11: {
            HtmlPipelineContext hcc = (HtmlPipelineContext)this.getLocalContext(context);
            try {
                if (t2.getLastMarginBottom() != null) {
                    hcc.getMemory().put("lastMarginBottom", t2.getLastMarginBottom());
                } else {
                    hcc.getMemory().remove("lastMarginBottom");
                }
                TagProcessor tp = hcc.resolveProcessor(t2.getName(), t2.getNameSpace());
                List<Element> elems = null;
                if (tp.isStackOwner()) {
                    StackKeeper tagStack;
                    try {
                        tagStack = hcc.poll();
                    }
                    catch (NoStackException e2) {
                        throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.html.missingstack"), t2.toString()), e2);
                    }
                    elems = tp.endElement(context, t2, tagStack.getElements());
                } else {
                    elems = tp.endElement(context, t2, hcc.currentContent());
                    hcc.currentContent().clear();
                }
                if (elems.size() <= 0) break block11;
                try {
                    StackKeeper stack = hcc.peek();
                    for (Element elem : elems) {
                        stack.add(elem);
                    }
                }
                catch (NoStackException e3) {
                    WritableElement writableElement = new WritableElement();
                    po.add(writableElement);
                    writableElement.addAll(elems);
                }
            }
            catch (NoTagProcessorException e4) {
                if (hcc.acceptUnknown()) break block11;
                throw e4;
            }
        }
        return this.getNext();
    }
}

