/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNull;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class PdfArray
extends PdfObject {
    protected ArrayList arrayList;

    public PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    public PdfArray(PdfObject pdfObject) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(pdfObject);
    }

    public PdfArray(float[] fArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(fArray);
    }

    public PdfArray(int[] nArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(nArray);
    }

    public PdfArray(ArrayList arrayList) {
        this();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.add((PdfObject)iterator.next());
        }
    }

    public PdfArray(PdfArray pdfArray) {
        super(5);
        this.arrayList = new ArrayList(pdfArray.arrayList);
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        PdfObject pdfObject;
        outputStream.write(91);
        Iterator iterator = this.arrayList.iterator();
        int n2 = 0;
        if (iterator.hasNext()) {
            pdfObject = (PdfObject)iterator.next();
            if (pdfObject == null) {
                pdfObject = PdfNull.PDFNULL;
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        while (iterator.hasNext()) {
            pdfObject = (PdfObject)iterator.next();
            if (pdfObject == null) {
                pdfObject = PdfNull.PDFNULL;
            }
            if ((n2 = pdfObject.type()) != 5 && n2 != 6 && n2 != 4 && n2 != 3) {
                outputStream.write(32);
            }
            pdfObject.toPdf(pdfWriter, outputStream);
        }
        outputStream.write(93);
    }

    public String toString() {
        return this.arrayList.toString();
    }

    public PdfObject set(int n2, PdfObject pdfObject) {
        return this.arrayList.set(n2, pdfObject);
    }

    public PdfObject remove(int n2) {
        return (PdfObject)this.arrayList.remove(n2);
    }

    public ArrayList getArrayList() {
        return this.arrayList;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean isEmpty() {
        return this.arrayList.isEmpty();
    }

    public boolean add(PdfObject pdfObject) {
        return this.arrayList.add(pdfObject);
    }

    public boolean add(float[] fArray) {
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.arrayList.add(new PdfNumber(fArray[i2]));
        }
        return true;
    }

    public boolean add(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.arrayList.add(new PdfNumber(nArray[i2]));
        }
        return true;
    }

    public void add(int n2, PdfObject pdfObject) {
        this.arrayList.add(n2, pdfObject);
    }

    public void addFirst(PdfObject pdfObject) {
        this.arrayList.add(0, pdfObject);
    }

    public boolean contains(PdfObject pdfObject) {
        return this.arrayList.contains(pdfObject);
    }

    public ListIterator listIterator() {
        return this.arrayList.listIterator();
    }

    public PdfObject getPdfObject(int n2) {
        return (PdfObject)this.arrayList.get(n2);
    }

    public PdfObject getDirectObject(int n2) {
        return PdfReader.getPdfObject(this.getPdfObject(n2));
    }

    public PdfDictionary getAsDict(int n2) {
        PdfDictionary pdfDictionary = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isDictionary()) {
            pdfDictionary = (PdfDictionary)pdfObject;
        }
        return pdfDictionary;
    }

    public PdfArray getAsArray(int n2) {
        PdfArray pdfArray = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isArray()) {
            pdfArray = (PdfArray)pdfObject;
        }
        return pdfArray;
    }

    public PdfStream getAsStream(int n2) {
        PdfStream pdfStream = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isStream()) {
            pdfStream = (PdfStream)pdfObject;
        }
        return pdfStream;
    }

    public PdfString getAsString(int n2) {
        PdfString pdfString = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isString()) {
            pdfString = (PdfString)pdfObject;
        }
        return pdfString;
    }

    public PdfNumber getAsNumber(int n2) {
        PdfNumber pdfNumber = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isNumber()) {
            pdfNumber = (PdfNumber)pdfObject;
        }
        return pdfNumber;
    }

    public PdfName getAsName(int n2) {
        PdfName pdfName = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isName()) {
            pdfName = (PdfName)pdfObject;
        }
        return pdfName;
    }

    public PdfBoolean getAsBoolean(int n2) {
        PdfBoolean pdfBoolean = null;
        PdfObject pdfObject = this.getDirectObject(n2);
        if (pdfObject != null && pdfObject.isBoolean()) {
            pdfBoolean = (PdfBoolean)pdfObject;
        }
        return pdfBoolean;
    }

    public PdfIndirectReference getAsIndirectObject(int n2) {
        PdfIndirectReference pdfIndirectReference = null;
        PdfObject pdfObject = this.getPdfObject(n2);
        if (pdfObject != null && pdfObject.isIndirect()) {
            pdfIndirectReference = (PdfIndirectReference)pdfObject;
        }
        return pdfIndirectReference;
    }
}

