/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BASE64DecoderStream
extends FilterInputStream {
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private int index = 0;
    private byte[] input_buffer = new byte[8190];
    private int input_pos = 0;
    private int input_len = 0;
    private boolean ignoreErrors = false;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];

    public BASE64DecoderStream(InputStream inputStream) {
        super(inputStream);
        try {
            String string = System.getProperty("mail.mime.base64.ignoreerrors");
            this.ignoreErrors = string != null && !string.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public BASE64DecoderStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.ignoreErrors = bl;
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.bufsize = this.decode(this.buffer, 0, this.buffer.length);
            if (this.bufsize <= 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        var4_4 = var2_2;
        while (this.index < this.bufsize && var3_3 > 0) {
            var1_1[var2_2++] = this.buffer[this.index++];
            --var3_3;
        }
        if (this.index >= this.bufsize) {
            this.index = 0;
            this.bufsize = 0;
        }
        if ((var5_5 = var3_3 / 3 * 3) <= 0) ** GOTO lbl20
        var6_6 = this.decode(var1_1, var2_2, var5_5);
        var2_2 += var6_6;
        var3_3 -= var6_6;
        if (var6_6 == var5_5) ** GOTO lbl20
        if (var2_2 == var4_4) {
            return -1;
        }
        return var2_2 - var4_4;
        while ((var6_6 = this.read()) != -1) {
            var1_1[var2_2++] = (byte)var6_6;
            --var3_3;
lbl20:
            // 3 sources

            if (var3_3 > 0) continue;
        }
        if (var2_2 == var4_4) {
            return -1;
        }
        return var2_2 - var4_4;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private int decode(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        while (n3 >= 3) {
            int n5 = 0;
            int n6 = 0;
            while (n5 < 4) {
                int n7 = this.getByte();
                if (n7 == -1 || n7 == -2) {
                    boolean bl;
                    if (n7 == -1) {
                        if (n5 == 0) {
                            return n2 - n4;
                        }
                        if (!this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed 4 valid base64 characters but only got " + n5 + " before EOF" + this.recentChars());
                        }
                        bl = true;
                    } else {
                        if (n5 < 2 && !this.ignoreErrors) {
                            throw new IOException("Error in encoded stream: needed at least 2 valid base64 characters, but only got " + n5 + " before padding character (=)" + this.recentChars());
                        }
                        if (n5 == 0) {
                            return n2 - n4;
                        }
                        bl = false;
                    }
                    int n8 = n5 - 1;
                    if (n8 == 0) {
                        n8 = 1;
                    }
                    ++n5;
                    n6 <<= 6;
                    while (n5 < 4) {
                        if (!bl) {
                            n7 = this.getByte();
                            if (n7 == -1) {
                                if (!this.ignoreErrors) {
                                    throw new IOException("Error in encoded stream: hit EOF while looking for padding characters (=)" + this.recentChars());
                                }
                            } else if (n7 != -2 && !this.ignoreErrors) {
                                throw new IOException("Error in encoded stream: found valid base64 character after a padding character (=)" + this.recentChars());
                            }
                        }
                        n6 <<= 6;
                        ++n5;
                    }
                    n6 >>= 8;
                    if (n8 == 2) {
                        byArray[n2 + 1] = (byte)(n6 & 0xFF);
                    }
                    byArray[n2] = (byte)((n6 >>= 8) & 0xFF);
                    n3 -= n8;
                    return (n2 += n8) - n4;
                }
                n6 <<= 6;
                ++n5;
                n6 |= n7;
            }
            byArray[n2 + 2] = (byte)(n6 & 0xFF);
            byArray[n2 + 1] = (byte)((n6 >>= 8) & 0xFF);
            byArray[n2] = (byte)((n6 >>= 8) & 0xFF);
            n3 -= 3;
            n2 += 3;
        }
        return n2 - n4;
    }

    private int getByte() throws IOException {
        int n2;
        do {
            if (this.input_pos >= this.input_len) {
                try {
                    this.input_len = this.in.read(this.input_buffer);
                }
                catch (EOFException eOFException) {
                    return -1;
                }
                if (this.input_len <= 0) {
                    return -1;
                }
                this.input_pos = 0;
            }
            if ((n2 = this.input_buffer[this.input_pos++] & 0xFF) != 61) continue;
            return -2;
        } while ((n2 = pem_convert_array[n2]) == -1);
        return n2;
    }

    private String recentChars() {
        int n2;
        String string = "";
        int n3 = n2 = this.input_pos > 10 ? 10 : this.input_pos;
        if (n2 > 0) {
            string = string + ", the " + n2 + " most recent characters were: \"";
            int n4 = this.input_pos - n2;
            while (n4 < this.input_pos) {
                char c2 = (char)(this.input_buffer[n4] & 0xFF);
                switch (c2) {
                    case '\r': {
                        string = string + "\\r";
                        break;
                    }
                    case '\n': {
                        string = string + "\\n";
                        break;
                    }
                    case '\t': {
                        string = string + "\\t";
                        break;
                    }
                    default: {
                        string = c2 >= ' ' && c2 < '\u007f' ? string + c2 : string + "\\" + c2;
                    }
                }
                ++n4;
            }
            string = string + "\"";
        }
        return string;
    }

    public static byte[] decode(byte[] byArray) {
        int n2 = byArray.length / 4 * 3;
        if (n2 == 0) {
            return byArray;
        }
        if (byArray[byArray.length - 1] == 61) {
            --n2;
            if (byArray[byArray.length - 2] == 61) {
                --n2;
            }
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        n2 = byArray.length;
        while (n2 > 0) {
            int n5 = 3;
            int n6 = pem_convert_array[byArray[n3++] & 0xFF];
            n6 <<= 6;
            n6 |= pem_convert_array[byArray[n3++] & 0xFF];
            n6 <<= 6;
            if (byArray[n3] != 61) {
                n6 |= pem_convert_array[byArray[n3++] & 0xFF];
            } else {
                --n5;
            }
            n6 <<= 6;
            if (byArray[n3] != 61) {
                n6 |= pem_convert_array[byArray[n3++] & 0xFF];
            } else {
                --n5;
            }
            if (n5 > 2) {
                byArray2[n4 + 2] = (byte)(n6 & 0xFF);
            }
            n6 >>= 8;
            if (n5 > 1) {
                byArray2[n4 + 1] = (byte)(n6 & 0xFF);
            }
            byArray2[n4] = (byte)((n6 >>= 8) & 0xFF);
            n4 += n5;
            n2 -= 4;
        }
        return byArray2;
    }

    static {
        int n2 = 0;
        while (n2 < 255) {
            BASE64DecoderStream.pem_convert_array[n2] = -1;
            ++n2;
        }
        int n3 = 0;
        while (n3 < pem_array.length) {
            BASE64DecoderStream.pem_convert_array[BASE64DecoderStream.pem_array[n3]] = (byte)n3;
            ++n3;
        }
    }
}

