/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BASE64EncoderStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int bufsize = 0;
    private int count = 0;
    private int bytesPerLine;
    private int lineLimit;
    private boolean noCRLF = false;
    private static byte[] newline = new byte[]{13, 10};
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public BASE64EncoderStream(OutputStream outputStream, int n2) {
        super(outputStream);
        if (n2 == Integer.MAX_VALUE || n2 < 4) {
            this.noCRLF = true;
            n2 = 76;
        }
        this.bytesPerLine = n2 / 4 * 4;
        this.lineLimit = n2 / 4 * 3;
    }

    public BASE64EncoderStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2;
        while ((this.bufsize != 0 || this.count != 0) && n3 > 0) {
            this.write(byArray[n2++]);
            --n3;
        }
        if (this.noCRLF) {
            byArray2 = new byte[this.bytesPerLine];
        } else {
            byArray2 = new byte[this.bytesPerLine + 2];
            byArray2[this.bytesPerLine] = 13;
            byArray2[this.bytesPerLine + 1] = 10;
        }
        int n4 = 0;
        while (n4 + this.lineLimit < n3) {
            this.out.write(BASE64EncoderStream.encode(byArray, n2 + n4, this.lineLimit, byArray2));
            n4 += this.lineLimit;
        }
        while (n4 < n3) {
            this.write(byArray[n2 + n4]);
            ++n4;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n2) throws IOException {
        this.buffer[this.bufsize++] = (byte)n2;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this.count + 4 > this.bytesPerLine) {
            if (!this.noCRLF) {
                this.out.write(newline);
            }
            this.count = 0;
        }
        this.out.write(BASE64EncoderStream.encode(this.buffer, 0, this.bufsize, null));
        this.count += 4;
    }

    public static byte[] encode(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        return BASE64EncoderStream.encode(byArray, 0, byArray.length, null);
    }

    private static byte[] encode(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4;
        if (byArray2 == null) {
            byArray2 = new byte[(n3 + 2) / 3 * 4];
        }
        int n5 = n2;
        int n6 = 0;
        while (n3 >= 3) {
            n4 = byArray[n5++] & 0xFF;
            n4 <<= 8;
            n4 |= byArray[n5++] & 0xFF;
            n4 <<= 8;
            byArray2[n6 + 3] = (byte)pem_array[(n4 |= byArray[n5++] & 0xFF) & 0x3F];
            byArray2[n6 + 2] = (byte)pem_array[(n4 >>= 6) & 0x3F];
            byArray2[n6 + 1] = (byte)pem_array[(n4 >>= 6) & 0x3F];
            byArray2[n6 + 0] = (byte)pem_array[(n4 >>= 6) & 0x3F];
            n3 -= 3;
            n6 += 4;
        }
        if (n3 == 1) {
            n4 = byArray[n5++] & 0xFF;
            byArray2[n6 + 3] = 61;
            byArray2[n6 + 2] = 61;
            byArray2[n6 + 1] = (byte)pem_array[(n4 <<= 4) & 0x3F];
            byArray2[n6 + 0] = (byte)pem_array[(n4 >>= 6) & 0x3F];
        } else if (n3 == 2) {
            n4 = byArray[n5++] & 0xFF;
            n4 <<= 8;
            n4 |= byArray[n5++] & 0xFF;
            byArray2[n6 + 3] = 61;
            byArray2[n6 + 2] = (byte)pem_array[(n4 <<= 2) & 0x3F];
            byArray2[n6 + 1] = (byte)pem_array[(n4 >>= 6) & 0x3F];
            byArray2[n6 + 0] = (byte)pem_array[(n4 >>= 6) & 0x3F];
        }
        return byArray2;
    }
}

