/*
 * Decompiled with CFR 0.152.
 */
package groovy.swing.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWrapperListModel<E>
extends AbstractListModel {
    private final List<E> delegate;

    public ListWrapperListModel(List<E> delegateList) {
        this.delegate = delegateList;
    }

    public List<E> getDelegateList() {
        return this.delegate;
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public Object getElementAt(int i2) {
        return this.delegate.get(i2);
    }

    public E set(int i2, E e2) {
        E element = this.delegate.set(i2, e2);
        this.fireContentsChanged(this, i2, i2);
        return element;
    }

    public void clear() {
        int i2 = this.delegate.size() - 1;
        this.delegate.clear();
        if (i2 >= 0) {
            this.fireIntervalRemoved(this, 0, i2);
        }
    }

    public int lastIndexOf(Object o2) {
        return this.delegate.lastIndexOf(o2);
    }

    public boolean contains(Object o2) {
        return this.delegate.contains(o2);
    }

    public ListIterator<E> listIterator() {
        return this.delegate.listIterator();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int indexOf(Object o2) {
        return this.delegate.indexOf(o2);
    }

    public void add(int i2, E e2) {
        int index = this.delegate.size();
        this.delegate.add(i2, e2);
        this.fireIntervalAdded(this, index, index);
    }

    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    public boolean addAll(Collection<? extends E> es) {
        int i2 = this.delegate.size();
        boolean added = this.delegate.addAll(es);
        if (added) {
            this.fireIntervalAdded(this, i2, i2 + es.size());
        }
        return added;
    }

    public E remove(int i2) {
        E element = this.delegate.remove(i2);
        this.fireIntervalRemoved(this, i2, i2);
        return element;
    }

    public boolean addAll(int i2, Collection<? extends E> es) {
        boolean added = this.delegate.addAll(i2, es);
        if (added) {
            this.fireIntervalAdded(this, i2, i2 + es.size());
        }
        return added;
    }

    public ListIterator<E> listIterator(int i2) {
        return this.delegate.listIterator(i2);
    }

    public boolean containsAll(Collection<?> objects) {
        return this.delegate.containsAll(objects);
    }

    public boolean remove(Object o2) {
        int i2 = this.indexOf(o2);
        boolean rv = this.delegate.remove(o2);
        if (i2 >= 0) {
            this.fireIntervalRemoved(this, i2, i2);
        }
        return rv;
    }

    public boolean add(E e2) {
        int i2 = this.delegate.size();
        boolean added = this.delegate.add(e2);
        if (added) {
            this.fireIntervalAdded(this, i2, i2);
        }
        return added;
    }

    public E get(int i2) {
        return this.delegate.get(i2);
    }

    public <T> T[] toArray(T[] ts) {
        return this.delegate.toArray(ts);
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i2 = toIndex; i2 >= fromIndex; --i2) {
            this.delegate.remove(i2);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }
}

