/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarasm.asm.tree;

import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.Attribute;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.Handle;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Type;
import groovyjarjarasm.asm.tree.AnnotationNode;
import groovyjarjarasm.asm.tree.FieldInsnNode;
import groovyjarjarasm.asm.tree.FrameNode;
import groovyjarjarasm.asm.tree.IincInsnNode;
import groovyjarjarasm.asm.tree.InsnList;
import groovyjarjarasm.asm.tree.InsnNode;
import groovyjarjarasm.asm.tree.IntInsnNode;
import groovyjarjarasm.asm.tree.InvokeDynamicInsnNode;
import groovyjarjarasm.asm.tree.JumpInsnNode;
import groovyjarjarasm.asm.tree.LabelNode;
import groovyjarjarasm.asm.tree.LdcInsnNode;
import groovyjarjarasm.asm.tree.LineNumberNode;
import groovyjarjarasm.asm.tree.LocalVariableNode;
import groovyjarjarasm.asm.tree.LookupSwitchInsnNode;
import groovyjarjarasm.asm.tree.MethodInsnNode;
import groovyjarjarasm.asm.tree.MethodNode$1;
import groovyjarjarasm.asm.tree.MultiANewArrayInsnNode;
import groovyjarjarasm.asm.tree.TableSwitchInsnNode;
import groovyjarjarasm.asm.tree.TryCatchBlockNode;
import groovyjarjarasm.asm.tree.TypeInsnNode;
import groovyjarjarasm.asm.tree.VarInsnNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MethodNode
extends MethodVisitor {
    public int access;
    public String name;
    public String desc;
    public String signature;
    public List exceptions;
    public List visibleAnnotations;
    public List invisibleAnnotations;
    public List attrs;
    public Object annotationDefault;
    public List[] visibleParameterAnnotations;
    public List[] invisibleParameterAnnotations;
    public InsnList instructions;
    public List tryCatchBlocks;
    public int maxStack;
    public int maxLocals;
    public List localVariables;
    private boolean visited;

    public MethodNode() {
        this(262144);
    }

    public MethodNode(int n2) {
        super(n2);
        this.instructions = new InsnList();
    }

    public MethodNode(int n2, String string, String string2, String string3, String[] stringArray) {
        this(262144, n2, string, string2, string3, stringArray);
    }

    public MethodNode(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        super(n2);
        boolean bl;
        this.access = n3;
        this.name = string;
        this.desc = string2;
        this.signature = string3;
        this.exceptions = new ArrayList(stringArray == null ? 0 : stringArray.length);
        boolean bl2 = bl = (n3 & 0x400) != 0;
        if (!bl) {
            this.localVariables = new ArrayList(5);
        }
        this.tryCatchBlocks = new ArrayList();
        if (stringArray != null) {
            this.exceptions.addAll(Arrays.asList(stringArray));
        }
        this.instructions = new InsnList();
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationNode(new MethodNode$1(this, 0));
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList(1);
            }
            this.visibleAnnotations.add(annotationNode);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList(1);
            }
            this.invisibleAnnotations.add(annotationNode);
        }
        return annotationNode;
    }

    public AnnotationVisitor visitParameterAnnotation(int n2, String string, boolean bl) {
        AnnotationNode annotationNode = new AnnotationNode(string);
        if (bl) {
            if (this.visibleParameterAnnotations == null) {
                int n3 = Type.getArgumentTypes(this.desc).length;
                this.visibleParameterAnnotations = new List[n3];
            }
            if (this.visibleParameterAnnotations[n2] == null) {
                this.visibleParameterAnnotations[n2] = new ArrayList(1);
            }
            this.visibleParameterAnnotations[n2].add(annotationNode);
        } else {
            if (this.invisibleParameterAnnotations == null) {
                int n4 = Type.getArgumentTypes(this.desc).length;
                this.invisibleParameterAnnotations = new List[n4];
            }
            if (this.invisibleParameterAnnotations[n2] == null) {
                this.invisibleParameterAnnotations[n2] = new ArrayList(1);
            }
            this.invisibleParameterAnnotations[n2].add(annotationNode);
        }
        return annotationNode;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList(1);
        }
        this.attrs.add(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        this.instructions.add(new FrameNode(n2, n3, objectArray == null ? null : this.getLabelNodes(objectArray), n4, objectArray2 == null ? null : this.getLabelNodes(objectArray2)));
    }

    public void visitInsn(int n2) {
        this.instructions.add(new InsnNode(n2));
    }

    public void visitIntInsn(int n2, int n3) {
        this.instructions.add(new IntInsnNode(n2, n3));
    }

    public void visitVarInsn(int n2, int n3) {
        this.instructions.add(new VarInsnNode(n2, n3));
    }

    public void visitTypeInsn(int n2, String string) {
        this.instructions.add(new TypeInsnNode(n2, string));
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.instructions.add(new FieldInsnNode(n2, string, string2, string3));
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        this.instructions.add(new MethodInsnNode(n2, string, string2, string3));
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.instructions.add(new InvokeDynamicInsnNode(string, string2, handle, objectArray));
    }

    public void visitJumpInsn(int n2, Label label) {
        this.instructions.add(new JumpInsnNode(n2, this.getLabelNode(label)));
    }

    public void visitLabel(Label label) {
        this.instructions.add(this.getLabelNode(label));
    }

    public void visitLdcInsn(Object object) {
        this.instructions.add(new LdcInsnNode(object));
    }

    public void visitIincInsn(int n2, int n3) {
        this.instructions.add(new IincInsnNode(n2, n3));
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label ... labelArray) {
        this.instructions.add(new TableSwitchInsnNode(n2, n3, this.getLabelNode(label), this.getLabelNodes(labelArray)));
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.instructions.add(new LookupSwitchInsnNode(this.getLabelNode(label), nArray, this.getLabelNodes(labelArray)));
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        this.instructions.add(new MultiANewArrayInsnNode(string, n2));
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.tryCatchBlocks.add(new TryCatchBlockNode(this.getLabelNode(label), this.getLabelNode(label2), this.getLabelNode(label3), string));
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.localVariables.add(new LocalVariableNode(string, string2, string3, this.getLabelNode(label), this.getLabelNode(label2), n2));
    }

    public void visitLineNumber(int n2, Label label) {
        this.instructions.add(new LineNumberNode(n2, this.getLabelNode(label)));
    }

    public void visitMaxs(int n2, int n3) {
        this.maxStack = n2;
        this.maxLocals = n3;
    }

    public void visitEnd() {
    }

    protected LabelNode getLabelNode(Label label) {
        if (!(label.info instanceof LabelNode)) {
            label.info = new LabelNode(label);
        }
        return (LabelNode)label.info;
    }

    private LabelNode[] getLabelNodes(Label[] labelArray) {
        LabelNode[] labelNodeArray = new LabelNode[labelArray.length];
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            labelNodeArray[i2] = this.getLabelNode(labelArray[i2]);
        }
        return labelNodeArray;
    }

    private Object[] getLabelNodes(Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Object object = objectArray[i2];
            if (object instanceof Label) {
                object = this.getLabelNode((Label)object);
            }
            objectArray2[i2] = object;
        }
        return objectArray2;
    }

    public void check(int n2) {
    }

    public void accept(ClassVisitor classVisitor) {
        String[] stringArray = new String[this.exceptions.size()];
        this.exceptions.toArray(stringArray);
        MethodVisitor methodVisitor = classVisitor.visitMethod(this.access, this.name, this.desc, this.signature, stringArray);
        if (methodVisitor != null) {
            this.accept(methodVisitor);
        }
    }

    public void accept(MethodVisitor methodVisitor) {
        AnnotationNode annotationNode;
        int n2;
        int n3;
        Object object;
        if (this.annotationDefault != null) {
            object = methodVisitor.visitAnnotationDefault();
            AnnotationNode.accept((AnnotationVisitor)object, null, this.annotationDefault);
            if (object != null) {
                ((AnnotationVisitor)object).visitEnd();
            }
        }
        int n4 = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object = (AnnotationNode)this.visibleAnnotations.get(n3);
            ((AnnotationNode)object).accept(methodVisitor.visitAnnotation(((AnnotationNode)object).desc, true));
        }
        n4 = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object = (AnnotationNode)this.invisibleAnnotations.get(n3);
            ((AnnotationNode)object).accept(methodVisitor.visitAnnotation(((AnnotationNode)object).desc, false));
        }
        n4 = this.visibleParameterAnnotations == null ? 0 : this.visibleParameterAnnotations.length;
        for (n3 = 0; n3 < n4; ++n3) {
            object = this.visibleParameterAnnotations[n3];
            if (object == null) continue;
            for (n2 = 0; n2 < object.size(); ++n2) {
                annotationNode = (AnnotationNode)object.get(n2);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n3, annotationNode.desc, true));
            }
        }
        n4 = this.invisibleParameterAnnotations == null ? 0 : this.invisibleParameterAnnotations.length;
        for (n3 = 0; n3 < n4; ++n3) {
            object = this.invisibleParameterAnnotations[n3];
            if (object == null) continue;
            for (n2 = 0; n2 < object.size(); ++n2) {
                annotationNode = (AnnotationNode)object.get(n2);
                annotationNode.accept(methodVisitor.visitParameterAnnotation(n3, annotationNode.desc, false));
            }
        }
        if (this.visited) {
            this.instructions.resetLabels();
        }
        n4 = this.attrs == null ? 0 : this.attrs.size();
        for (n3 = 0; n3 < n4; ++n3) {
            methodVisitor.visitAttribute((Attribute)this.attrs.get(n3));
        }
        if (this.instructions.size() > 0) {
            methodVisitor.visitCode();
            n4 = this.tryCatchBlocks == null ? 0 : this.tryCatchBlocks.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((TryCatchBlockNode)this.tryCatchBlocks.get(n3)).accept(methodVisitor);
            }
            this.instructions.accept(methodVisitor);
            n4 = this.localVariables == null ? 0 : this.localVariables.size();
            for (n3 = 0; n3 < n4; ++n3) {
                ((LocalVariableNode)this.localVariables.get(n3)).accept(methodVisitor);
            }
            methodVisitor.visitMaxs(this.maxStack, this.maxLocals);
            this.visited = true;
        }
        methodVisitor.visitEnd();
    }
}

