/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Vector;
import javax.mail.event.MailEvent;

class EventQueue
implements Runnable {
    private QueueElement head = null;
    private QueueElement tail = null;
    private Thread qThread = new Thread((Runnable)this, "JavaMail-EventQueue");

    public EventQueue() {
        this.qThread.setDaemon(true);
        this.qThread.start();
    }

    public synchronized void enqueue(MailEvent mailEvent, Vector vector) {
        QueueElement queueElement = new QueueElement(mailEvent, vector);
        if (this.head == null) {
            this.head = queueElement;
            this.tail = queueElement;
        } else {
            queueElement.next = this.head;
            this.head.prev = queueElement;
            this.head = queueElement;
        }
        this.notify();
    }

    private synchronized QueueElement dequeue() throws InterruptedException {
        while (this.tail == null) {
            this.wait();
        }
        QueueElement queueElement = this.tail;
        this.tail = queueElement.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        queueElement.next = null;
        queueElement.prev = null;
        return queueElement;
    }

    public void run() {
        block7: {
            try {
                QueueElement queueElement;
                while ((queueElement = this.dequeue()) != null) {
                    MailEvent mailEvent = queueElement.event;
                    Vector vector = queueElement.vector;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        try {
                            mailEvent.dispatch(vector.elementAt(n2));
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof InterruptedException) break block7;
                        }
                        ++n2;
                    }
                    queueElement = null;
                    mailEvent = null;
                    vector = null;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void stop() {
        if (this.qThread != null) {
            this.qThread.interrupt();
            this.qThread = null;
        }
    }

    class QueueElement {
        QueueElement next = null;
        QueueElement prev = null;
        MailEvent event = null;
        Vector vector = null;

        QueueElement(MailEvent mailEvent, Vector vector) {
            this.event = mailEvent;
            this.vector = vector;
        }
    }
}

