/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.util.Date;
import javax.mail.search.ComparisonTerm;

public abstract class DateTerm
extends ComparisonTerm {
    protected Date date;
    private static final long serialVersionUID = 4818873430063720043L;

    protected DateTerm(int n2, Date date) {
        this.comparison = n2;
        this.date = date;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public int getComparison() {
        return this.comparison;
    }

    protected boolean match(Date date) {
        switch (this.comparison) {
            case 1: {
                return date.before(this.date) || date.equals(this.date);
            }
            case 2: {
                return date.before(this.date);
            }
            case 3: {
                return date.equals(this.date);
            }
            case 4: {
                return !date.equals(this.date);
            }
            case 5: {
                return date.after(this.date);
            }
            case 6: {
                return date.after(this.date) || date.equals(this.date);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateTerm)) {
            return false;
        }
        DateTerm dateTerm = (DateTerm)object;
        return dateTerm.date.equals(this.date) && super.equals(object);
    }

    public int hashCode() {
        return this.date.hashCode() + super.hashCode();
    }
}

