/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barcode4j;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.components.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.components.barcode4j.BarcodeImageProducer;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.renderers.BatikRenderer;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.w3c.dom.Document;

public class BarcodeSVGImageProducer
implements BarcodeImageProducer {
    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, BarcodeGenerator barcode, String message) {
        try {
            SVGCanvasProvider provider = new SVGCanvasProvider(false, (int)((Barcode4jComponent)componentElement.getComponent()).getOrientationValue().getValue());
            barcode.generateBarcode(provider, message);
            Document svgDoc = provider.getDOM();
            DOMSource source = new DOMSource(svgDoc);
            StringWriter outWriter = new StringWriter();
            StreamResult output = new StreamResult(outWriter);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, output);
            String svgString = outWriter.toString();
            return new BatikRenderer(svgString, null);
        }
        catch (Exception e2) {
            throw new JRRuntimeException(e2);
        }
    }
}

