/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.headertoolbar.actions;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.components.headertoolbar.HeaderToolbarElementUtils;
import net.sf.jasperreports.components.headertoolbar.actions.AbstractVerifiableTableAction;
import net.sf.jasperreports.components.headertoolbar.actions.EditTextElementCommand;
import net.sf.jasperreports.components.headertoolbar.actions.EditTextElementData;
import net.sf.jasperreports.components.sort.FilterTypesEnum;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;

public class EditTextElementAction
extends AbstractVerifiableTableAction {
    public void setEditTextElementData(EditTextElementData editTextElementData) {
        this.columnData = editTextElementData;
    }

    public EditTextElementData getEditTextElementData() {
        return (EditTextElementData)this.columnData;
    }

    @Override
    public void performAction() throws ActionException {
        try {
            this.getCommandStack().execute(new ResetInCacheCommand(new EditTextElementCommand(this.getTargetTextElement(), this.getEditTextElementData(), this.getReportContext()), this.getJasperReportsContext(), this.getReportContext(), this.targetUri));
        }
        catch (CommandException e2) {
            throw new ActionException(e2);
        }
    }

    private JRDesignTextElement getTargetTextElement() {
        EditTextElementData textElementData = this.getEditTextElementData();
        List<BaseColumn> allCols = TableUtil.getAllColumns(this.table);
        StandardColumn col = (StandardColumn)allCols.get(textElementData.getColumnIndex());
        JRDesignTextElement result = null;
        if ("detailrows".equals(textElementData.getApplyTo())) {
            result = TableUtil.getCellElement(JRDesignTextElement.class, col.getDetailCell(), true);
        } else if ("groupsubtotal".equals(textElementData.getApplyTo())) {
            result = TableUtil.getCellElement(JRDesignTextElement.class, col, 6, textElementData.getGroupName(), this.table);
        } else if ("heading".equals(textElementData.getApplyTo())) {
            result = TableUtil.getCellElement(JRDesignTextElement.class, col.getColumnHeader(), true);
        } else if ("groupheading".equals(textElementData.getApplyTo())) {
            result = TableUtil.getCellElement(JRDesignTextElement.class, col, 5, textElementData.getGroupName(), this.table);
        } else if ("tabletotal".equals(textElementData.getApplyTo())) {
            result = TableUtil.getCellElement(JRDesignTextElement.class, col, 1, null, this.table);
        }
        return result;
    }

    @Override
    public void verify() throws ActionException {
        JRDesignTextElement textField;
        EditTextElementData colValData = this.getEditTextElementData();
        Locale locale = (Locale)this.getReportContext().getParameterValue("REPORT_LOCALE");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (colValData.getFontSize() != null) {
            try {
                NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
                ParsePosition pp = new ParsePosition(0);
                Number formattedNumber = numberFormat.parse(colValData.getFontSize(), pp);
                if (formattedNumber != null && pp.getIndex() == colValData.getFontSize().length()) {
                    colValData.setFloatFontSize(Float.valueOf(formattedNumber.floatValue()));
                } else {
                    this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.values.invalid.font.size", colValData.getFontSize());
                }
            }
            catch (NumberFormatException e2) {
                this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.values.invalid.font.size", colValData.getFontSize());
            }
        }
        if ((textField = this.getTargetTextElement()) instanceof JRDesignTextField && TableUtil.hasSingleChunkExpression((JRDesignTextField)textField)) {
            JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.table.getDatasetRun();
            String datasetName = datasetRun.getDatasetName();
            JasperDesignCache cache = JasperDesignCache.getInstance(this.getJasperReportsContext(), this.getReportContext());
            JasperDesign jasperDesign = cache.getJasperDesign(this.targetUri);
            JRDesignDataset dataset = (JRDesignDataset)jasperDesign.getDatasetMap().get(datasetName);
            String textFieldName = ((JRDesignTextField)textField).getExpression().getChunks()[0].getText();
            Enum filterType = null;
            for (JRField field : dataset.getFields()) {
                if (!textFieldName.equals(field.getName())) continue;
                filterType = HeaderToolbarElementUtils.getFilterType(field.getValueClass());
                break;
            }
            if (filterType != null) {
                if (filterType.equals(FilterTypesEnum.DATE)) {
                    try {
                        formatFactory.createDateFormat(colValData.getFormatPattern(), locale, null);
                    }
                    catch (IllegalArgumentException e3) {
                        this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.column.values.invalid.date.pattern", colValData.getFormatPattern());
                    }
                } else if (filterType.equals(FilterTypesEnum.NUMERIC)) {
                    try {
                        formatFactory.createNumberFormat(colValData.getFormatPattern(), locale);
                    }
                    catch (IllegalArgumentException e4) {
                        this.errors.addAndThrow("net.sf.jasperreports.components.headertoolbar.actions.edit.column.values.invalid.number.pattern", colValData.getFormatPattern());
                    }
                }
            }
        }
    }
}

