/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import java.util.UUID;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.interactive.SortRowGroupCommand;
import net.sf.jasperreports.crosstabs.interactive.SortRowGroupData;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.ActionException;
import net.sf.jasperreports.web.commands.CommandException;
import net.sf.jasperreports.web.commands.CommandTarget;
import net.sf.jasperreports.web.commands.ResetInCacheCommand;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SortRowGroupAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(SortRowGroupAction.class);
    private SortRowGroupData sortData;

    @Override
    public void performAction() throws ActionException {
        CommandTarget target = this.getCommandTarget(UUID.fromString(this.sortData.getCrosstabId()), JRDesignCrosstab.class);
        if (target != null) {
            JRDesignCrosstab crosstab = (JRDesignCrosstab)target.getIdentifiable();
            try {
                SortRowGroupCommand sortCommand = new SortRowGroupCommand(crosstab, this.getSortData());
                ResetInCacheCommand command = new ResetInCacheCommand(sortCommand, this.getJasperReportsContext(), this.getReportContext(), target.getUri());
                this.getCommandStack().execute(command);
            }
            catch (CommandException e2) {
                if (log.isDebugEnabled()) {
                    log.debug("error sorting crosstab", e2);
                }
                throw new ActionException(e2);
            }
        }
    }

    public SortRowGroupData getSortData() {
        return this.sortData;
    }

    public void setSortData(SortRowGroupData sortData) {
        this.sortData = sortData;
    }
}

