/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import net.sf.jasperreports.data.cache.BigDecimalStore;
import net.sf.jasperreports.data.cache.BigIntegerStore;
import net.sf.jasperreports.data.cache.BlockColumnStore;
import net.sf.jasperreports.data.cache.BooleanStore;
import net.sf.jasperreports.data.cache.BufferColumnStore;
import net.sf.jasperreports.data.cache.ColumnCacheData;
import net.sf.jasperreports.data.cache.ColumnDataSnapshot;
import net.sf.jasperreports.data.cache.ColumnStore;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.data.cache.DataRecorder;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.data.cache.DatasetRecorder;
import net.sf.jasperreports.data.cache.DateStore;
import net.sf.jasperreports.data.cache.DoubleArrayStore;
import net.sf.jasperreports.data.cache.FloatArrayStore;
import net.sf.jasperreports.data.cache.LongArrayStore;
import net.sf.jasperreports.data.cache.NumberToByteTransformer;
import net.sf.jasperreports.data.cache.NumberToCharTransformer;
import net.sf.jasperreports.data.cache.NumberToDateTransformer;
import net.sf.jasperreports.data.cache.NumberToIntegerTransformer;
import net.sf.jasperreports.data.cache.NumberToLongTransformer;
import net.sf.jasperreports.data.cache.NumberToSQLDateTransformer;
import net.sf.jasperreports.data.cache.NumberToSQLTimeTransformer;
import net.sf.jasperreports.data.cache.NumberToShortTransformer;
import net.sf.jasperreports.data.cache.ObjectArrayStore;
import net.sf.jasperreports.data.cache.StandardColumnCacheData;
import net.sf.jasperreports.data.cache.TimestampStore;
import net.sf.jasperreports.data.cache.TypedColumnStore;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnDataCacheHandler
implements DataCacheHandler {
    private static final Log log = LogFactory.getLog(ColumnDataCacheHandler.class);
    private static final int DEFAULT_BUFFER_STORE_SIZE = 4096;
    private boolean recordingEnabled = true;
    private volatile DataSnapshot snapshot;
    private int bufferStoreSize = 4096;

    @Override
    public boolean isRecordingEnabled() {
        return this.recordingEnabled;
    }

    @Override
    public DataRecorder createDataRecorder() {
        if (log.isDebugEnabled()) {
            log.debug("creating data recorder");
        }
        return new DataCollector();
    }

    @Override
    public DataSnapshot getDataSnapshot() {
        return this.snapshot;
    }

    protected void disableCaching() {
        if (log.isDebugEnabled()) {
            log.debug("caching disabled");
        }
        this.recordingEnabled = false;
    }

    protected void setDataSnapshot(DataSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public boolean isSnapshotPopulated() {
        return this.snapshot != null;
    }

    protected ColumnStore createColumnStore(JRField field) {
        return new TypedColumnStore(this, field.getValueClass());
    }

    protected ColumnStore createColumnStore(Class<?> type) {
        BufferColumnStore bufferStore = null;
        if (Integer.class.equals(type)) {
            bufferStore = new LongArrayStore(this.bufferStoreSize, NumberToIntegerTransformer.instance());
        } else if (Long.class.equals(type)) {
            bufferStore = new LongArrayStore(this.bufferStoreSize, NumberToLongTransformer.instance());
        } else if (Short.class.equals(type)) {
            bufferStore = new LongArrayStore(this.bufferStoreSize, NumberToShortTransformer.instance());
        } else if (Byte.class.equals(type)) {
            bufferStore = new LongArrayStore(this.bufferStoreSize, NumberToByteTransformer.instance());
        } else if (Character.class.equals(type)) {
            bufferStore = new LongArrayStore(this.bufferStoreSize, NumberToCharTransformer.instance());
        } else if (Double.class.equals(type)) {
            bufferStore = new DoubleArrayStore(this.bufferStoreSize);
        } else if (Float.class.equals(type)) {
            bufferStore = new FloatArrayStore(this.bufferStoreSize);
        } else if (String.class.equals(type)) {
            bufferStore = new ObjectArrayStore<String>(String.class, this.bufferStoreSize);
        } else if (Date.class.isAssignableFrom(type)) {
            bufferStore = new DateStore(this.bufferStoreSize, NumberToSQLDateTransformer.instance());
        } else if (Timestamp.class.isAssignableFrom(type)) {
            bufferStore = new TimestampStore(this.bufferStoreSize);
        } else if (Time.class.isAssignableFrom(type)) {
            bufferStore = new DateStore(this.bufferStoreSize, NumberToSQLTimeTransformer.instance());
        } else if (java.util.Date.class.isAssignableFrom(type)) {
            bufferStore = new DateStore(this.bufferStoreSize, NumberToDateTransformer.instance());
        } else if (BigInteger.class.isAssignableFrom(type)) {
            bufferStore = new BigIntegerStore(this.bufferStoreSize);
        } else if (BigDecimal.class.isAssignableFrom(type)) {
            bufferStore = new BigDecimalStore(this.bufferStoreSize);
        } else if (Boolean.class.equals(type)) {
            bufferStore = new BooleanStore(this.bufferStoreSize);
        }
        BlockColumnStore store = null;
        if (bufferStore != null) {
            store = new BlockColumnStore(bufferStore);
            if (log.isDebugEnabled()) {
                log.debug("created block store " + store + " with buffer " + bufferStore + ", buffer size " + this.bufferStoreSize);
            }
        }
        return store;
    }

    class ColumnDataCollector
    implements DatasetRecorder {
        private JRField[] fields;
        private ColumnStore[] columns;
        private int size;
        private boolean ended;
        private LinkedHashMap<String, Object> parameters;

        @Override
        public void start(JRField[] datasetFields) {
            this.fields = datasetFields == null ? new JRField[]{} : datasetFields;
            this.columns = new ColumnStore[this.fields.length];
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                JRField field = this.fields[i2];
                ColumnStore columnStore = ColumnDataCacheHandler.this.createColumnStore(field);
                if (columnStore == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Field " + field.getName() + " of type " + field.getValueClassName() + " not cacheable");
                    }
                    ColumnDataCacheHandler.this.disableCaching();
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("created store " + columnStore + " for field " + field.getName());
                }
                this.columns[i2] = columnStore;
            }
            this.size = 0;
            this.parameters = null;
            this.ended = false;
        }

        @Override
        public void addParameter(String name, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap();
            }
            this.parameters.put(name, value);
        }

        @Override
        public void addRecord(Object[] values) {
            if (!ColumnDataCacheHandler.this.isRecordingEnabled()) {
                return;
            }
            if (values == null || values.length != this.columns.length) {
                throw new IllegalArgumentException();
            }
            for (int i2 = 0; i2 < this.columns.length; ++i2) {
                this.columns[i2].addValue(values[i2]);
            }
            ++this.size;
        }

        @Override
        public Object end() {
            String[] fieldNames;
            if (!ColumnDataCacheHandler.this.isRecordingEnabled()) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("Recorded cached data source of " + this.size + " records");
            }
            this.ended = true;
            if (this.fields == null) {
                fieldNames = new String[]{};
            } else {
                fieldNames = new String[this.fields.length];
                for (int i2 = 0; i2 < this.fields.length; ++i2) {
                    fieldNames[i2] = this.fields[i2].getName();
                }
            }
            ColumnValues[] values = new ColumnValues[this.columns.length];
            for (int i3 = 0; i3 < this.columns.length; ++i3) {
                values[i3] = this.columns[i3].createValues();
            }
            StandardColumnCacheData data = new StandardColumnCacheData(fieldNames, this.size, values, this.parameters);
            return data;
        }

        @Override
        public boolean hasEnded() {
            return this.ended;
        }
    }

    class DataCollector
    implements DataRecorder {
        private final ColumnDataSnapshot dataSnapshot = new ColumnDataSnapshot();

        @Override
        public DatasetRecorder createRecorder() {
            if (log.isDebugEnabled()) {
                log.debug("Creating ColumnDataCollector");
            }
            ColumnDataCollector collector = new ColumnDataCollector();
            return collector;
        }

        @Override
        public void addRecordResult(Object key, Object result) {
            ColumnCacheData data = (ColumnCacheData)result;
            if (log.isDebugEnabled()) {
                log.debug("adding cached data of size " + data.size() + " for for " + key);
            }
            if (!data.isSerializable()) {
                if (log.isDebugEnabled()) {
                    log.debug("cached data not serializable at key " + key);
                }
                this.disablePersistence();
            }
            this.dataSnapshot.addCachedData(key, data);
        }

        @Override
        public void setSnapshotPopulated() {
            if (this.isEnabled()) {
                ColumnDataCacheHandler.this.setDataSnapshot(this.dataSnapshot);
            }
        }

        @Override
        public void disableRecording() {
            ColumnDataCacheHandler.this.disableCaching();
        }

        @Override
        public void disablePersistence() {
            this.dataSnapshot.setPersistable(false);
        }

        @Override
        public boolean isEnabled() {
            return ColumnDataCacheHandler.this.isRecordingEnabled();
        }
    }
}

