/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xls;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;

public abstract class AbstractXlsDataAdapterService
extends AbstractDataAdapterService {
    public static final String PROPERTY_DATA_ADAPTER_USE_LEGACY_JEXCELAPI = "net.sf.jasperreports.data.adapter.xls.use.legacy.jexcelapi";
    protected DataFileStream dataStream;

    public AbstractXlsDataAdapterService(JasperReportsContext jasperReportsContext, XlsDataAdapter xlsDataAdapter) {
        super(jasperReportsContext, xlsDataAdapter);
    }

    public XlsDataAdapter getXlsDataAdapter() {
        return (XlsDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XlsDataAdapter xlsDataAdapter = this.getXlsDataAdapter();
        if (xlsDataAdapter != null) {
            this.dataStream = DataFileUtils.instance(this.getJasperReportsContext()).getDataStream(xlsDataAdapter.getDataFile(), parameters);
            String datePattern = xlsDataAdapter.getDatePattern();
            String numberPattern = xlsDataAdapter.getNumberPattern();
            String sheetSelection = xlsDataAdapter.getSheetSelection();
            if (xlsDataAdapter.isQueryExecuterMode()) {
                parameters.put("XLS_INPUT_STREAM", this.dataStream);
                if (datePattern != null && datePattern.length() > 0) {
                    parameters.put("XLS_DATE_FORMAT", new SimpleDateFormat(datePattern));
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    parameters.put("XLS_NUMBER_FORMAT", new DecimalFormat(numberPattern));
                }
                parameters.put("XLS_USE_FIRST_ROW_AS_HEADER", new Boolean(xlsDataAdapter.isUseFirstRowAsHeader()));
                if (sheetSelection != null && sheetSelection.length() > 0) {
                    parameters.put("net.sf.jasperreports.xls.sheet.selection", sheetSelection);
                }
                if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                    String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                    Integer[] indexes = new Integer[xlsDataAdapter.getColumnNames().size()];
                    this.setupColumns(xlsDataAdapter, names, indexes);
                    parameters.put("XLS_COLUMN_NAMES_ARRAY", names);
                    parameters.put("XLS_COLUMN_INDEXES_ARRAY", indexes);
                }
            } else {
                AbstractXlsDataSource ds = this.getXlsDataSource();
                if (datePattern != null && datePattern.length() > 0) {
                    ds.setDateFormat(new SimpleDateFormat(datePattern));
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    ds.setNumberFormat(new DecimalFormat(numberPattern));
                }
                ds.setUseFirstRowAsHeader(xlsDataAdapter.isUseFirstRowAsHeader());
                if (sheetSelection != null && sheetSelection.length() > 0) {
                    ds.setSheetSelection(sheetSelection);
                }
                if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                    String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                    int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                    this.setupColumns(xlsDataAdapter, names, indexes);
                    ds.setColumnNames(names, indexes);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    protected abstract AbstractXlsDataSource getXlsDataSource() throws JRException;

    protected void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, int[] indexes) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = "" + xlsDataAdapter.getColumnNames().get(i2);
            indexes[i2] = xlsDataAdapter.getColumnIndexes().size() > i2 ? xlsDataAdapter.getColumnIndexes().get(i2) : i2;
        }
    }

    protected void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, Integer[] indexes) {
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = "" + xlsDataAdapter.getColumnNames().get(i2);
            indexes[i2] = xlsDataAdapter.getColumnIndexes().size() > i2 ? xlsDataAdapter.getColumnIndexes().get(i2) : i2;
        }
    }

    @Override
    public void dispose() {
        if (this.dataStream != null) {
            this.dataStream.dispose();
        }
    }
}

