/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;

public class DefaultJasperReportsContext
implements JasperReportsContext {
    public static final String DEFAULT_PROPERTIES_FILE = "jasperreports.properties";
    public static final String PROPERTIES_FILE = "net.sf.jasperreports.properties";
    private static final DefaultJasperReportsContext INSTANCE = new DefaultJasperReportsContext();
    public static final String EXCEPTION_MESSAGE_KEY_LOAD_DEFAULT_PROPERTIES_FAILURE = "engine.context.load.default.properties.failure";
    public static final String EXCEPTION_MESSAGE_KEY_LOAD_PROPERTIES_FAILURE = "engine.context.load.properties.failure";
    public static final String EXCEPTION_MESSAGE_KEY_LOAD_PROPERTIES_FILE_FAILURE = "engine.context.load.properties.file.failure";
    public static final String EXCEPTION_MESSAGE_KEY_DEFAULT_PROPERTIES_FILE_NOT_FOUND = "engine.context.default.properties.file.not.found";
    private Map<String, Object> values = new ConcurrentHashMap<String, Object>(16, 0.75f, 1);
    protected volatile ConcurrentHashMap<String, String> properties;

    private DefaultJasperReportsContext() {
        this.initProperties();
    }

    public static DefaultJasperReportsContext getInstance() {
        return INSTANCE;
    }

    protected void initProperties() {
        try {
            Properties loadedProps;
            Properties defaults = DefaultJasperReportsContext.getDefaultProperties();
            String propFile = DefaultJasperReportsContext.getSystemProperty(PROPERTIES_FILE);
            if (propFile == null) {
                loadedProps = JRPropertiesUtil.loadProperties(DEFAULT_PROPERTIES_FILE, defaults);
                if (loadedProps == null) {
                    loadedProps = new Properties(defaults);
                }
            } else {
                loadedProps = JRPropertiesUtil.loadProperties(propFile, defaults);
                if (loadedProps == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOAD_PROPERTIES_FILE_FAILURE, new Object[]{propFile});
                }
            }
            this.properties = new ConcurrentHashMap();
            Enumeration<?> names = loadedProps.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = loadedProps.getProperty(name);
                this.properties.put(name, value);
            }
            this.loadSystemProperties();
        }
        catch (JRException e2) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOAD_PROPERTIES_FAILURE, null, e2);
        }
    }

    protected void loadSystemProperties() {
        this.loadSystemProperty("jasper.reports.compiler.class", "net.sf.jasperreports.compiler.class");
        this.loadSystemProperty("jasper.reports.compile.xml.validation", "net.sf.jasperreports.compiler.xml.validation");
        this.loadSystemProperty("jasper.reports.export.xml.validation", "net.sf.jasperreports.export.xml.validation");
        this.loadSystemProperty("jasper.reports.compile.keep.java.file", "net.sf.jasperreports.compiler.keep.java.file");
        this.loadSystemProperty("jasper.reports.compile.temp", "net.sf.jasperreports.compiler.temp.dir");
        this.loadSystemProperty("jasper.reports.compile.class.path", "net.sf.jasperreports.compiler.classpath");
    }

    protected static Properties getDefaultProperties() throws JRException {
        String classPath;
        Properties defaults = new Properties();
        InputStream is = JRPropertiesUtil.class.getResourceAsStream("/default.jasperreports.properties");
        if (is == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_DEFAULT_PROPERTIES_FILE_NOT_FOUND, (Object[])null);
        }
        try {
            defaults.load(is);
        }
        catch (IOException e2) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_LOAD_DEFAULT_PROPERTIES_FAILURE, null, e2);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e3) {}
        }
        String userDir = DefaultJasperReportsContext.getSystemProperty("user.dir");
        if (userDir != null) {
            defaults.setProperty("net.sf.jasperreports.compiler.temp.dir", userDir);
        }
        if ((classPath = DefaultJasperReportsContext.getSystemProperty("java.class.path")) != null) {
            defaults.setProperty("net.sf.jasperreports.compiler.classpath", classPath);
        }
        return defaults;
    }

    protected static String getSystemProperty(String propertyName) {
        try {
            return System.getProperty(propertyName);
        }
        catch (SecurityException e2) {
            return null;
        }
    }

    protected void loadSystemProperty(String sysKey, String propKey) {
        String val = DefaultJasperReportsContext.getSystemProperty(sysKey);
        if (val != null) {
            this.properties.put(propKey, val);
        }
    }

    @Override
    public Object getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public Object getOwnValue(String key) {
        return this.values.get(key);
    }

    @Override
    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        return ExtensionsEnvironment.getExtensionsRegistry().getExtensions(extensionType);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

