/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;

public abstract class JRAbstractBeanDataSource
implements JRRewindableDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_BEAN_FIELD_VALUE_NOT_RETRIEVED = "data.bean.field.value.not.retrieved";
    public static final String CURRENT_BEAN_MAPPING = "_THIS";
    protected PropertyNameProvider propertyNameProvider;
    protected static final PropertyNameProvider FIELD_NAME_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        @Override
        public String getPropertyName(JRField field) {
            return field.getName();
        }
    };
    protected static final PropertyNameProvider FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER = new PropertyNameProvider(){

        @Override
        public String getPropertyName(JRField field) {
            if (field.getDescription() == null) {
                return field.getName();
            }
            return field.getDescription();
        }
    };

    public JRAbstractBeanDataSource(boolean isUseFieldDescription) {
        this.propertyNameProvider = isUseFieldDescription ? FIELD_DESCRIPTION_PROPERTY_NAME_PROVIDER : FIELD_NAME_PROPERTY_NAME_PROVIDER;
    }

    protected Object getFieldValue(Object bean, JRField field) throws JRException {
        return JRAbstractBeanDataSource.getBeanProperty(bean, this.getPropertyName(field));
    }

    protected static Object getBeanProperty(Object bean, String propertyName) throws JRException {
        Object value = null;
        if (JRAbstractBeanDataSource.isCurrentBeanMapping(propertyName)) {
            value = bean;
        } else if (bean != null) {
            try {
                value = PropertyUtils.getProperty(bean, propertyName);
            }
            catch (IllegalAccessException e2) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_BEAN_FIELD_VALUE_NOT_RETRIEVED, new Object[]{propertyName}, e2);
            }
            catch (InvocationTargetException e3) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_BEAN_FIELD_VALUE_NOT_RETRIEVED, new Object[]{propertyName}, e3);
            }
            catch (NoSuchMethodException e4) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_BEAN_FIELD_VALUE_NOT_RETRIEVED, new Object[]{propertyName}, e4);
            }
            catch (NestedNullException nestedNullException) {
                // empty catch block
            }
        }
        return value;
    }

    protected static boolean isCurrentBeanMapping(String propertyName) {
        return CURRENT_BEAN_MAPPING.equals(propertyName);
    }

    protected String getPropertyName(JRField field) {
        return this.propertyNameProvider.getPropertyName(field);
    }

    static interface PropertyNameProvider {
        public String getPropertyName(JRField var1);
    }
}

