/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.ListIterator;
import java.util.Stack;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;

public class JRHtmlExporterHelper {
    private static final Integer TABLE_TYPE_TABLE = 1;
    private static final Integer TABLE_TYPE_CROSSTAB = 2;
    JasperPrint jasperPrint = null;
    Stack<Integer> tableTypes = new Stack();

    public JRHtmlExporterHelper(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public void createNestedFrames(ListIterator<JRPrintElement> elemIt, JRBasePrintFrame parentFrame) {
        while (elemIt.hasNext()) {
            JRPrintElement element = elemIt.next();
            if (element.hasProperties()) {
                String tableTagProp = element.getPropertiesMap().getProperty("net.sf.jasperreports.export.pdf.tag.table");
                boolean tableStart = "start".equals(tableTagProp);
                String crosstabProp = element.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.cell.type");
                boolean crosstabStart = "CrosstabHeader".equals(crosstabProp);
                if (tableStart || crosstabStart) {
                    this.tableTypes.push(crosstabStart ? TABLE_TYPE_CROSSTAB : TABLE_TYPE_TABLE);
                    JRBasePrintFrame nestedFrame = new JRBasePrintFrame(this.jasperPrint.getDefaultStyleProvider());
                    nestedFrame.getPropertiesMap().setProperty("net.sf.jasperreports.export.html.frames.as.nested.tables", Boolean.TRUE.toString());
                    nestedFrame.addElement(element);
                    this.createNestedFrames(elemIt, nestedFrame);
                    this.sizeFrame(nestedFrame);
                    parentFrame.addElement(nestedFrame);
                    continue;
                }
                if (this.tableTypes.size() > 0 && TABLE_TYPE_CROSSTAB.equals(this.tableTypes.get(this.tableTypes.size() - 1)) && crosstabProp == null || "end".equals(tableTagProp)) {
                    this.tableTypes.pop();
                    break;
                }
            }
            parentFrame.addElement(element);
        }
    }

    private void sizeFrame(JRBasePrintFrame frame) {
        int x2 = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        int width = 0;
        int height = 0;
        for (JRPrintElement element : frame.getElements()) {
            x2 = element.getX() < x2 ? element.getX() : x2;
            y = element.getY() < y ? element.getY() : y;
            width = element.getX() + element.getWidth() > width ? element.getX() + element.getWidth() : width;
            height = element.getY() + element.getHeight() > height ? element.getY() + element.getHeight() : height;
        }
        frame.setX(x2);
        frame.setY(y);
        frame.setWidth(width - x2);
        frame.setHeight(height - y);
        for (JRPrintElement element : frame.getElements()) {
            element.setX(element.getX() - x2);
            element.setY(element.getY() - y);
        }
    }
}

