/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementRtfHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRRtfExporterContext;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.ExportInterruptedException;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.RtfExporterConfiguration;
import net.sf.jasperreports.export.RtfReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRRtfExporter
extends JRAbstractExporter<RtfReportConfiguration, RtfExporterConfiguration, WriterExporterOutput, JRRtfExporterContext> {
    private static final Log log = LogFactory.getLog(JRRtfExporter.class);
    private static final String RTF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.rtf.";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_TEXT_HEIGHT = "export.rtf.invalid.text.height";
    private static final int LINE_SPACING_FACTOR = 240;
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.rtf.ignore.hyperlink";
    public static final String RTF_EXPORTER_KEY = "net.sf.jasperreports.rtf";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected FileBufferedWriter colorWriter;
    protected FileBufferedWriter fontWriter;
    protected FileBufferedWriter contentWriter;
    protected File destFile;
    protected int reportIndex;
    protected List<Color> colors;
    protected List<String> fonts;
    private int zorder = 1;

    public JRRtfExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRRtfExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    @Override
    protected Class<RtfExporterConfiguration> getConfigurationInterface() {
        return RtfExporterConfiguration.class;
    }

    @Override
    protected Class<RtfReportConfiguration> getItemConfigurationInterface() {
        return RtfReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersWriterExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.fonts = new ArrayList<String>();
        this.colors = new ArrayList<Color>();
        this.colors.add(null);
        this.initExport();
        this.ensureOutput();
        Writer writer = ((WriterExporterOutput)this.getExporterOutput()).getWriter();
        try {
            this.exportReportToWriter(writer);
        }
        catch (IOException e2) {
            throw new JRException("export.common.output.writer.error", new Object[]{this.jasperPrint.getName()}, e2);
        }
        finally {
            ((WriterExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    protected void exportReportToWriter(Writer writer) throws JRException, IOException {
        this.colorWriter = new FileBufferedWriter();
        this.fontWriter = new FileBufferedWriter();
        this.contentWriter = new FileBufferedWriter();
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                this.contentWriter.write("{\\info{\\nofpages");
                this.contentWriter.write(String.valueOf(pages.size()));
                this.contentWriter.write("}}\n");
                this.contentWriter.write("\\viewkind1\\paperw");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(this.jasperPrint.getPageWidth())));
                this.contentWriter.write("\\paperh");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(this.jasperPrint.getPageHeight())));
                this.contentWriter.write("\\marglsxn");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(this.jasperPrint.getLeftMargin() == null ? 0.0f : (float)this.jasperPrint.getLeftMargin().intValue())));
                this.contentWriter.write("\\margrsxn");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(this.jasperPrint.getRightMargin() == null ? 0.0f : (float)this.jasperPrint.getRightMargin().intValue())));
                this.contentWriter.write("\\margtsxn");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(this.jasperPrint.getTopMargin() == null ? 0.0f : (float)this.jasperPrint.getTopMargin().intValue())));
                this.contentWriter.write("\\margbsxn");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(this.jasperPrint.getBottomMargin() == null ? 0.0f : (float)this.jasperPrint.getBottomMargin().intValue())));
                this.contentWriter.write("\\deftab");
                this.contentWriter.write(String.valueOf(LengthUtil.twip(new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()).getParagraph().getTabStopWidth().intValue())));
                if (this.jasperPrint.getOrientationValue() == OrientationEnum.LANDSCAPE) {
                    this.contentWriter.write("\\lndscpsxn");
                }
                for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
                    if (Thread.interrupted()) {
                        throw new ExportInterruptedException();
                    }
                    JRPrintPage page = pages.get(pageIndex);
                    this.contentWriter.write("\n");
                    this.writeAnchor(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
                    boolean lastPageFlag = false;
                    if (pageIndex == endPageIndex && this.reportIndex == items.size() - 1) {
                        lastPageFlag = true;
                    }
                    this.exportPage(page, lastPageFlag);
                }
            }
            ++this.reportIndex;
        }
        this.contentWriter.write("}\n");
        this.contentWriter.close();
        this.colorWriter.close();
        this.fontWriter.close();
        writer.write("{\\rtf1\\ansi\\deff0\n");
        writer.write("{\\fonttbl ");
        this.fontWriter.writeData(writer);
        writer.write("}\n");
        writer.write("{\\colortbl ;");
        this.colorWriter.writeData(writer);
        writer.write("}\n");
        this.contentWriter.writeData(writer);
        writer.flush();
        this.contentWriter.dispose();
        this.colorWriter.dispose();
        this.fontWriter.dispose();
    }

    private int getColorIndex(Color color) throws IOException {
        int colorNdx = this.colors.indexOf(color);
        if (colorNdx < 0) {
            colorNdx = this.colors.size();
            this.colors.add(color);
            this.colorWriter.write("\\red" + color.getRed() + "\\green" + color.getGreen() + "\\blue" + color.getBlue() + ";");
        }
        return colorNdx;
    }

    private int getFontIndex(JRFont font, Locale locale) throws IOException {
        int fontIndex;
        FontFamily family;
        String exportFont;
        String fontName = font.getFontName();
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontName, locale);
        if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.getExporterKey())) != null) {
            fontName = exportFont;
        }
        if ((fontIndex = this.fonts.indexOf(fontName)) < 0) {
            fontIndex = this.fonts.size();
            this.fonts.add(fontName);
            this.fontWriter.write("{\\f" + fontIndex + "\\fnil " + fontName + ";}");
        }
        return fontIndex;
    }

    protected void exportPage(JRPrintPage page, boolean lastPage) throws JRException, IOException {
        JRExportProgressMonitor progressMonitor;
        this.exportElements(page.getElements());
        if (!lastPage) {
            this.contentWriter.write("\\page\n");
        }
        if ((progressMonitor = ((RtfReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor()) != null) {
            progressMonitor.afterPageExport();
        }
    }

    private void startElement(JRPrintElement element) throws IOException {
        this.contentWriter.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpfblwtxt0\\shpz");
        this.contentWriter.write(String.valueOf(this.zorder++));
        this.contentWriter.write("\\shpleft");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(element.getX() + this.getOffsetX())));
        this.contentWriter.write("\\shpright");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(element.getX() + this.getOffsetX() + element.getWidth())));
        this.contentWriter.write("\\shptop");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(element.getY() + this.getOffsetY())));
        this.contentWriter.write("\\shpbottom");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(element.getY() + this.getOffsetY() + element.getHeight())));
        Color bgcolor = element.getBackcolor();
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            this.contentWriter.write("{\\sp{\\sn fFilled}{\\sv 1}}");
            this.contentWriter.write("{\\sp{\\sn fillColor}{\\sv ");
            this.contentWriter.write(String.valueOf(this.getColorRGB(bgcolor)));
            this.contentWriter.write("}}");
        } else {
            this.contentWriter.write("{\\sp{\\sn fFilled}{\\sv 0}}");
        }
        this.contentWriter.write("{\\shpinst");
    }

    private int getColorRGB(Color color) {
        return color.getRed() + 256 * color.getGreen() + 65536 * color.getBlue();
    }

    private void finishElement() throws IOException {
        this.contentWriter.write("}}\n");
    }

    private void exportPen(JRPen pen) throws IOException {
        this.contentWriter.write("{\\sp{\\sn lineColor}{\\sv ");
        this.contentWriter.write(String.valueOf(this.getColorRGB(pen.getLineColor())));
        this.contentWriter.write("}}");
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth == 0.0f) {
            this.contentWriter.write("{\\sp{\\sn fLine}{\\sv 0}}");
        }
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                this.contentWriter.write("{\\sp{\\sn lineStyle}{\\sv 1}}");
                break;
            }
            case DOTTED: {
                this.contentWriter.write("{\\sp{\\sn lineDashing}{\\sv 2}}");
                break;
            }
            case DASHED: {
                this.contentWriter.write("{\\sp{\\sn lineDashing}{\\sv 1}}");
            }
        }
        this.contentWriter.write("{\\sp{\\sn lineWidth}{\\sv ");
        this.contentWriter.write(String.valueOf(LengthUtil.emu(lineWidth)));
        this.contentWriter.write("}}");
    }

    private void exportPen(Color color) throws IOException {
        this.contentWriter.write("{\\sp{\\sn lineColor}{\\sv ");
        this.contentWriter.write(String.valueOf(this.getColorRGB(color)));
        this.contentWriter.write("}}");
        this.contentWriter.write("{\\sp{\\sn fLine}{\\sv 0}}");
        this.contentWriter.write("{\\sp{\\sn lineWidth}{\\sv 0}}");
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        int x2 = line.getX() + this.getOffsetX();
        int y = line.getY() + this.getOffsetY();
        int height = line.getHeight();
        int width = line.getWidth();
        if (width <= 1 || height <= 1) {
            if (width > 1) {
                height = 0;
            } else {
                width = 0;
            }
        }
        this.contentWriter.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpz");
        this.contentWriter.write(String.valueOf(this.zorder++));
        this.contentWriter.write("\\shpleft");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(x2)));
        this.contentWriter.write("\\shpright");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(x2 + width)));
        this.contentWriter.write("\\shptop");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(y)));
        this.contentWriter.write("\\shpbottom");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(y + height)));
        this.contentWriter.write("{\\shpinst");
        this.contentWriter.write("{\\sp{\\sn shapeType}{\\sv 20}}");
        this.exportPen(line.getLinePen());
        if (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN) {
            this.contentWriter.write("{\\sp{\\sn fFlipV}{\\sv 0}}");
        } else {
            this.contentWriter.write("{\\sp{\\sn fFlipV}{\\sv 1}}");
        }
        this.contentWriter.write("}}\n");
    }

    private void exportBorder(JRPen pen, float x2, float y, float width, float height) throws IOException {
        this.contentWriter.write("{\\shp\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpz");
        this.contentWriter.write(String.valueOf(this.zorder++));
        this.contentWriter.write("\\shpleft");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(x2)));
        this.contentWriter.write("\\shpright");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(x2 + width)));
        this.contentWriter.write("\\shptop");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(y)));
        this.contentWriter.write("\\shpbottom");
        this.contentWriter.write(String.valueOf(LengthUtil.twip(y + height)));
        this.contentWriter.write("{\\shpinst");
        this.contentWriter.write("{\\sp{\\sn shapeType}{\\sv 20}}");
        this.exportPen(pen);
        this.contentWriter.write("}}\n");
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.startElement(rectangle);
        if (rectangle.getRadius() == 0) {
            this.contentWriter.write("{\\sp{\\sn shapeType}{\\sv 1}}");
        } else {
            this.contentWriter.write("{\\sp{\\sn shapeType}{\\sv 2}}");
        }
        this.exportPen(rectangle.getLinePen());
        this.finishElement();
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.startElement(ellipse);
        this.contentWriter.write("{\\sp{\\sn shapeType}{\\sv 3}}");
        this.exportPen(ellipse.getLinePen());
        this.finishElement();
    }

    public void exportText(JRPrintText text) throws IOException, JRException {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        int width = text.getWidth();
        int height = text.getHeight();
        int textHeight = (int)text.getTextHeight();
        if (textHeight <= 0) {
            if (height <= 0) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_TEXT_HEIGHT, (Object[])null);
            }
            textHeight = height;
        }
        this.startElement(text);
        int topPadding = text.getLineBox().getTopPadding();
        int leftPadding = text.getLineBox().getLeftPadding();
        int bottomPadding = text.getLineBox().getBottomPadding();
        int rightPadding = text.getLineBox().getRightPadding();
        String rotation = null;
        switch (text.getRotationValue()) {
            case LEFT: {
                switch (text.getVerticalTextAlign()) {
                    case TOP: {
                        break;
                    }
                    case MIDDLE: {
                        leftPadding = Math.max(leftPadding, (width - rightPadding - textHeight) / 2);
                        break;
                    }
                    case BOTTOM: {
                        leftPadding = Math.max(leftPadding, width - rightPadding - textHeight);
                    }
                }
                rotation = "{\\sp{\\sn txflTextFlow}{\\sv 2}}";
                break;
            }
            case RIGHT: {
                switch (text.getVerticalTextAlign()) {
                    case TOP: {
                        break;
                    }
                    case MIDDLE: {
                        rightPadding = Math.max(rightPadding, (width - leftPadding - textHeight) / 2);
                        break;
                    }
                    case BOTTOM: {
                        rightPadding = Math.max(rightPadding, width - leftPadding - textHeight);
                    }
                }
                rotation = "{\\sp{\\sn txflTextFlow}{\\sv 3}}";
                break;
            }
            case UPSIDE_DOWN: {
                switch (text.getVerticalTextAlign()) {
                    case TOP: {
                        topPadding = Math.max(topPadding, height - bottomPadding - textHeight);
                        break;
                    }
                    case MIDDLE: {
                        topPadding = Math.max(topPadding, (height - bottomPadding - textHeight) / 2);
                        break;
                    }
                }
                rotation = "";
                break;
            }
            default: {
                switch (text.getVerticalTextAlign()) {
                    case TOP: {
                        break;
                    }
                    case MIDDLE: {
                        topPadding = Math.max(topPadding, (height - bottomPadding - textHeight) / 2);
                        break;
                    }
                    case BOTTOM: {
                        topPadding = Math.max(topPadding, height - bottomPadding - textHeight);
                    }
                }
                rotation = "";
            }
        }
        this.contentWriter.write(rotation);
        this.contentWriter.write("{\\sp{\\sn dyTextTop}{\\sv ");
        this.contentWriter.write(String.valueOf(LengthUtil.emu(topPadding)));
        this.contentWriter.write("}}");
        this.contentWriter.write("{\\sp{\\sn dxTextLeft}{\\sv ");
        this.contentWriter.write(String.valueOf(LengthUtil.emu(leftPadding)));
        this.contentWriter.write("}}");
        this.contentWriter.write("{\\sp{\\sn dyTextBottom}{\\sv ");
        this.contentWriter.write(String.valueOf(LengthUtil.emu(bottomPadding)));
        this.contentWriter.write("}}");
        this.contentWriter.write("{\\sp{\\sn dxTextRight}{\\sv ");
        this.contentWriter.write(String.valueOf(LengthUtil.emu(rightPadding)));
        this.contentWriter.write("}}");
        this.contentWriter.write("{\\sp{\\sn fLine}{\\sv 0}}");
        this.contentWriter.write("{\\shptxt{\\pard ");
        this.contentWriter.write("\\fi" + LengthUtil.twip(text.getParagraph().getFirstLineIndent().intValue()) + " ");
        this.contentWriter.write("\\li" + LengthUtil.twip(text.getParagraph().getLeftIndent().intValue()) + " ");
        this.contentWriter.write("\\ri" + LengthUtil.twip(text.getParagraph().getRightIndent().intValue()) + " ");
        this.contentWriter.write("\\sb" + LengthUtil.twip(text.getParagraph().getSpacingBefore().intValue()) + " ");
        this.contentWriter.write("\\sa" + LengthUtil.twip(text.getParagraph().getSpacingAfter().intValue()) + " ");
        TabStop[] tabStops = text.getParagraph().getTabStops();
        if (tabStops != null && tabStops.length > 0) {
            for (int i2 = 0; i2 < tabStops.length; ++i2) {
                TabStop tabStop = tabStops[i2];
                String tabStopAlign = "";
                switch (tabStop.getAlignment()) {
                    case CENTER: {
                        tabStopAlign = "\\tqc";
                        break;
                    }
                    case RIGHT: {
                        tabStopAlign = "\\tqr";
                        break;
                    }
                    default: {
                        tabStopAlign = "";
                    }
                }
                this.contentWriter.write(tabStopAlign + "\\tx" + LengthUtil.twip(tabStop.getPosition()) + " ");
            }
        }
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.contentWriter.write("\\rtlch");
        }
        this.contentWriter.write("\\cb");
        this.contentWriter.write(String.valueOf(this.getColorIndex(text.getBackcolor())));
        this.contentWriter.write(" ");
        switch (text.getHorizontalTextAlign()) {
            case LEFT: {
                this.contentWriter.write("\\ql");
                break;
            }
            case CENTER: {
                this.contentWriter.write("\\qc");
                break;
            }
            case RIGHT: {
                this.contentWriter.write("\\qr");
                break;
            }
            case JUSTIFIED: {
                this.contentWriter.write("\\qj");
                break;
            }
            default: {
                this.contentWriter.write("\\ql");
            }
        }
        switch (text.getParagraph().getLineSpacing()) {
            case AT_LEAST: {
                this.contentWriter.write("\\sl" + LengthUtil.twip(text.getParagraph().getLineSpacingSize().floatValue()));
                this.contentWriter.write(" \\slmult0 ");
                break;
            }
            case FIXED: {
                this.contentWriter.write("\\sl-" + LengthUtil.twip(text.getParagraph().getLineSpacingSize().floatValue()));
                this.contentWriter.write(" \\slmult0 ");
                break;
            }
            case PROPORTIONAL: {
                this.contentWriter.write("\\sl" + (int)(text.getParagraph().getLineSpacingSize().floatValue() * 240.0f));
                this.contentWriter.write(" \\slmult1 ");
                break;
            }
            case DOUBLE: {
                this.contentWriter.write("\\sl480");
                this.contentWriter.write(" \\slmult1 ");
                break;
            }
            case ONE_AND_HALF: {
                this.contentWriter.write("\\sl360");
                this.contentWriter.write(" \\slmult1 ");
                break;
            }
            default: {
                this.contentWriter.write("\\sl240");
                this.contentWriter.write(" \\slmult1 ");
            }
        }
        if (text.getAnchorName() != null) {
            this.writeAnchor(text.getAnchorName());
        }
        boolean startedHyperlink = this.exportHyperlink(text);
        String plainText = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Map<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = iterator.getAttributes();
            JRBaseFont styleFont = new JRBaseFont(styledTextAttributes);
            Color styleForeground = (Color)styledTextAttributes.get(TextAttribute.FOREGROUND);
            Color styleBackground = (Color)styledTextAttributes.get(TextAttribute.BACKGROUND);
            this.contentWriter.write("\\f");
            this.contentWriter.write(String.valueOf(this.getFontIndex(styleFont, this.getTextLocale(text))));
            this.contentWriter.write("\\fs");
            this.contentWriter.write(String.valueOf((int)(2.0f * styleFont.getFontsize())));
            if (styleFont.isBold()) {
                this.contentWriter.write("\\b");
            }
            if (styleFont.isItalic()) {
                this.contentWriter.write("\\i");
            }
            if (styleFont.isUnderline()) {
                this.contentWriter.write("\\ul");
            }
            if (styleFont.isStrikeThrough()) {
                this.contentWriter.write("\\strike");
            }
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(styledTextAttributes.get(TextAttribute.SUPERSCRIPT))) {
                this.contentWriter.write("\\super");
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(styledTextAttributes.get(TextAttribute.SUPERSCRIPT))) {
                this.contentWriter.write("\\sub");
            }
            if (null != styleBackground && !styleBackground.equals(text.getBackcolor())) {
                this.contentWriter.write("\\highlight");
                this.contentWriter.write(String.valueOf(this.getColorIndex(styleBackground)));
            }
            this.contentWriter.write("\\cf");
            this.contentWriter.write(String.valueOf(this.getColorIndex(styleForeground)));
            this.contentWriter.write(" ");
            this.contentWriter.write(this.handleUnicodeText(plainText.substring(iterator.getIndex(), runLimit)));
            this.contentWriter.write("\\plain");
            iterator.setIndex(runLimit);
        }
        this.endHyperlink(startedHyperlink);
        this.contentWriter.write("\\par}}");
        this.finishElement();
        this.exportBox(text.getLineBox(), text.getX() + this.getOffsetX(), text.getY() + this.getOffsetY(), width, height);
    }

    private String handleUnicodeText(String sourceText) {
        StringBuffer unicodeText = new StringBuffer();
        for (int i2 = 0; i2 < sourceText.length(); ++i2) {
            long ch = sourceText.charAt(i2);
            if (ch > 127L) {
                unicodeText.append("\\u" + ch + '?');
                continue;
            }
            if (ch == 10L) {
                unicodeText.append("\\line ");
                continue;
            }
            if (ch == 92L || ch == 123L || ch == 125L) {
                unicodeText.append('\\').append((char)ch);
                continue;
            }
            unicodeText.append((char)ch);
        }
        return unicodeText.toString();
    }

    public void exportImage(JRPrintImage printImage) throws JRException, IOException {
        int leftPadding = printImage.getLineBox().getLeftPadding();
        int topPadding = printImage.getLineBox().getTopPadding();
        int rightPadding = printImage.getLineBox().getRightPadding();
        int bottomPadding = printImage.getLineBox().getBottomPadding();
        int availableImageWidth = printImage.getWidth() - leftPadding - rightPadding;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        Renderable renderer = printImage.getRenderable();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                renderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForImageData(renderer, printImage.getOnErrorTypeValue());
            }
        } else {
            renderer = null;
        }
        if (renderer != null) {
            Dimension2D dimension;
            if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(printImage.getWidth(), printImage.getHeight()), ModeEnum.OPAQUE == printImage.getModeValue() ? printImage.getBackcolor() : null);
            }
            int normalWidth = availableImageWidth;
            int normalHeight = availableImageHeight;
            Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, printImage.getOnErrorTypeValue());
            Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
            if (tmpRenderer == renderer && dimension != null) {
                normalWidth = (int)dimension.getWidth();
                normalHeight = (int)dimension.getHeight();
            }
            int imageWidth = 0;
            int imageHeight = 0;
            int xoffset = 0;
            int yoffset = 0;
            int cropTop = 0;
            int cropLeft = 0;
            int cropBottom = 0;
            int cropRight = 0;
            switch (printImage.getScaleImageValue()) {
                case CLIP: {
                    switch (printImage.getHorizontalImageAlign()) {
                        case RIGHT: {
                            cropLeft = 65536 * (-availableImageWidth + normalWidth) / availableImageWidth;
                            cropRight = 0;
                            break;
                        }
                        case CENTER: {
                            cropRight = cropLeft = 65536 * (-availableImageWidth + normalWidth) / availableImageWidth / 2;
                            break;
                        }
                        default: {
                            cropLeft = 0;
                            cropRight = 65536 * (-availableImageWidth + normalWidth) / availableImageWidth;
                        }
                    }
                    switch (printImage.getVerticalImageAlign()) {
                        case TOP: {
                            cropTop = 0;
                            cropBottom = 65536 * (-availableImageHeight + normalHeight) / normalHeight;
                            break;
                        }
                        case MIDDLE: {
                            cropBottom = cropTop = 65536 * (-availableImageHeight + normalHeight) / normalHeight / 2;
                            break;
                        }
                        default: {
                            cropTop = 65536 * (-availableImageHeight + normalHeight) / normalHeight;
                            cropBottom = 0;
                        }
                    }
                    imageWidth = availableImageWidth;
                    imageHeight = availableImageHeight;
                    break;
                }
                case FILL_FRAME: {
                    normalWidth = availableImageWidth;
                    normalHeight = availableImageHeight;
                    imageWidth = availableImageWidth;
                    imageHeight = availableImageHeight;
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)normalWidth / (double)normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        normalWidth = availableImageWidth;
                        normalHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        normalWidth = (int)((double)availableImageHeight * ratio);
                        normalHeight = availableImageHeight;
                    }
                    xoffset = (int)(this.getXAlignFactor(printImage) * (float)(availableImageWidth - normalWidth));
                    yoffset = (int)(this.getYAlignFactor(printImage) * (float)(availableImageHeight - normalHeight));
                    imageWidth = normalWidth;
                    imageHeight = normalHeight;
                }
            }
            this.startElement(printImage);
            this.exportPen(printImage.getForecolor());
            this.finishElement();
            boolean startedHyperlink = this.exportHyperlink(printImage);
            this.contentWriter.write("{\\shp{\\*\\shpinst\\shpbxpage\\shpbypage\\shpwr5\\shpfhdr0\\shpfblwtxt0\\shpz");
            this.contentWriter.write(String.valueOf(this.zorder++));
            this.contentWriter.write("\\shpleft");
            this.contentWriter.write(String.valueOf(LengthUtil.twip(printImage.getX() + leftPadding + xoffset + this.getOffsetX())));
            this.contentWriter.write("\\shpright");
            this.contentWriter.write(String.valueOf(LengthUtil.twip(printImage.getX() + leftPadding + xoffset + this.getOffsetX() + imageWidth)));
            this.contentWriter.write("\\shptop");
            this.contentWriter.write(String.valueOf(LengthUtil.twip(printImage.getY() + topPadding + yoffset + this.getOffsetY())));
            this.contentWriter.write("\\shpbottom");
            this.contentWriter.write(String.valueOf(LengthUtil.twip(printImage.getY() + topPadding + yoffset + this.getOffsetY() + imageHeight)));
            this.contentWriter.write("{\\sp{\\sn shapeType}{\\sv 75}}");
            this.contentWriter.write("{\\sp{\\sn fFilled}{\\sv 0}}");
            this.contentWriter.write("{\\sp{\\sn fLockAspectRatio}{\\sv 0}}");
            this.contentWriter.write("{\\sp{\\sn cropFromTop}{\\sv ");
            this.contentWriter.write(String.valueOf(cropTop));
            this.contentWriter.write("}}");
            this.contentWriter.write("{\\sp{\\sn cropFromLeft}{\\sv ");
            this.contentWriter.write(String.valueOf(cropLeft));
            this.contentWriter.write("}}");
            this.contentWriter.write("{\\sp{\\sn cropFromBottom}{\\sv ");
            this.contentWriter.write(String.valueOf(cropBottom));
            this.contentWriter.write("}}");
            this.contentWriter.write("{\\sp{\\sn cropFromRight}{\\sv ");
            this.contentWriter.write(String.valueOf(cropRight));
            this.contentWriter.write("}}");
            this.writeShapeHyperlink(printImage);
            if (printImage.getAnchorName() != null) {
                this.writeAnchor(printImage.getAnchorName());
            }
            this.contentWriter.write("{\\sp{\\sn pib}{\\sv {\\pict");
            if (renderer.getImageTypeValue() == ImageTypeEnum.JPEG) {
                this.contentWriter.write("\\jpegblip");
            } else {
                this.contentWriter.write("\\pngblip");
            }
            this.contentWriter.write("\n");
            ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData(this.jasperReportsContext));
            int count = 0;
            int current = 0;
            while ((current = bais.read()) != -1) {
                String helperStr = Integer.toHexString(current);
                if (helperStr.length() < 2) {
                    helperStr = "0" + helperStr;
                }
                this.contentWriter.write(helperStr);
                if (++count != 64) continue;
                this.contentWriter.write("\n");
                count = 0;
            }
            this.contentWriter.write("\n}}}");
            this.contentWriter.write("}}\n");
            this.endHyperlink(startedHyperlink);
        }
        int x2 = printImage.getX() + this.getOffsetX();
        int y = printImage.getY() + this.getOffsetY();
        int width = printImage.getWidth();
        int height = printImage.getHeight();
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), x2, y, width, height);
            }
        } else {
            this.exportBox(printImage.getLineBox(), x2, y, width, height);
        }
    }

    public void exportFrame(JRPrintFrame frame) throws JRException, IOException {
        int x2 = frame.getX() + this.getOffsetX();
        int y = frame.getY() + this.getOffsetY();
        int width = frame.getWidth();
        int height = frame.getHeight();
        this.startElement(frame);
        this.exportPen(frame.getForecolor());
        this.finishElement();
        this.setFrameElementsOffset(frame, false);
        this.exportElements(frame.getElements());
        this.restoreElementOffsets();
        this.exportBox(frame.getLineBox(), x2, y, width, height);
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws JRException, IOException {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (element instanceof JRPrintText) {
                    this.exportText((JRPrintText)element);
                    continue;
                }
                if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                    continue;
                }
                if (!(element instanceof JRGenericPrintElement)) continue;
                this.exportGenericElement((JRGenericPrintElement)element);
            }
        }
    }

    private void exportBox(JRLineBox box, int x2, int y, int width, int height) throws IOException {
        this.exportTopPen(box.getTopPen(), box.getLeftPen(), box.getRightPen(), x2, y, width, height);
        this.exportLeftPen(box.getTopPen(), box.getLeftPen(), box.getBottomPen(), x2, y, width, height);
        this.exportBottomPen(box.getLeftPen(), box.getBottomPen(), box.getRightPen(), x2, y, width, height);
        this.exportRightPen(box.getTopPen(), box.getBottomPen(), box.getRightPen(), x2, y, width, height);
    }

    private void exportPen(JRPen pen, int x2, int y, int width, int height) throws IOException {
        this.exportTopPen(pen, pen, pen, x2, y, width, height);
        this.exportLeftPen(pen, pen, pen, x2, y, width, height);
        this.exportBottomPen(pen, pen, pen, x2, y, width, height);
        this.exportRightPen(pen, pen, pen, x2, y, width, height);
    }

    private void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, int x2, int y, int width, int height) throws IOException {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(topPen, (float)x2 - leftPen.getLineWidth().floatValue() / 2.0f, y, (float)width + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f, 0.0f);
        }
    }

    private void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, int x2, int y, int width, int height) throws IOException {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(leftPen, x2, (float)y - topPen.getLineWidth().floatValue() / 2.0f, 0.0f, (float)height + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f);
        }
    }

    private void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, int x2, int y, int width, int height) throws IOException {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(bottomPen, (float)x2 - leftPen.getLineWidth().floatValue() / 2.0f, y + height, (float)width + (leftPen.getLineWidth().floatValue() + rightPen.getLineWidth().floatValue()) / 2.0f, 0.0f);
        }
    }

    private void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, int x2, int y, int width, int height) throws IOException {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            this.exportBorder(rightPen, x2 + width, (float)y - topPen.getLineWidth().floatValue() / 2.0f, 0.0f, (float)height + (topPen.getLineWidth().floatValue() + bottomPen.getLineWidth().floatValue()) / 2.0f);
        }
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementRtfHandler handler = (GenericElementRtfHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), RTF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRRtfExporterContext)this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug("No RTF generic element handler for " + element.getGenericType());
        }
    }

    protected boolean exportHyperlink(JRPrintHyperlink link) throws IOException {
        boolean result;
        String local;
        String hl;
        block14: {
            JRHyperlinkProducer customHandler;
            block15: {
                hl = null;
                local = "";
                result = false;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = ((RtfReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block14;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block15;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            hl = link.getHyperlinkReference();
                            break;
                        }
                        break block14;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            hl = link.getHyperlinkAnchor();
                            local = "\\\\l ";
                            break;
                        }
                        break block14;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            hl = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            local = "\\\\l ";
                            break;
                        }
                        break block14;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            hl = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block14;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            hl = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            hl = customHandler.getHyperlink(link);
        }
        if (hl != null) {
            this.contentWriter.write("{\\field{\\*\\fldinst HYPERLINK " + local + "\"" + hl + "\"}{\\fldrslt ");
            result = true;
        }
        return result;
    }

    protected void writeShapeHyperlink(JRPrintHyperlink link) throws IOException {
        String hlsrc;
        String hlfr;
        String hlloc;
        block16: {
            JRHyperlinkProducer customHandler;
            block17: {
                hlloc = null;
                hlfr = null;
                hlsrc = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = ((RtfReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
                }
                if (ignoreHyperlink.booleanValue()) break block16;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block17;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            hlfr = hlsrc = link.getHyperlinkReference();
                            break;
                        }
                        break block16;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            hlfr = hlloc = link.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            hlfr = hlloc = JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block16;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            hlfr = hlsrc = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block16;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            hlfr = hlsrc = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            hlfr = hlsrc = customHandler.getHyperlink(link);
        }
        if (hlfr != null) {
            this.contentWriter.write("{\\sp{\\sn fIsButton}{\\sv 1}}");
            this.contentWriter.write("{\\sp{\\sn pihlShape}{\\sv {\\*\\hl");
            this.contentWriter.write("{\\hlfr ");
            this.contentWriter.write(hlfr);
            this.contentWriter.write(" }");
            if (hlloc != null) {
                this.contentWriter.write("{\\hlloc ");
                this.contentWriter.write(hlloc);
                this.contentWriter.write(" }");
            }
            if (hlsrc != null) {
                this.contentWriter.write("{\\hlsrc ");
                this.contentWriter.write(hlsrc);
                this.contentWriter.write(" }");
            }
            this.contentWriter.write("}}}");
        }
    }

    protected void endHyperlink(boolean startedHyperlink) throws IOException {
        if (startedHyperlink) {
            this.contentWriter.write("}}");
        }
    }

    protected void writeAnchor(String anchorName) throws IOException {
        this.contentWriter.write("{\\*\\bkmkstart ");
        this.contentWriter.write(anchorName);
        this.contentWriter.write("}{\\*\\bkmkend ");
        this.contentWriter.write(anchorName);
        this.contentWriter.write("}");
    }

    private float getXAlignFactor(JRPrintImage image) {
        float xalignFactor = 0.0f;
        switch (image.getHorizontalImageAlign()) {
            case RIGHT: {
                xalignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    private float getYAlignFactor(JRPrintImage image) {
        float yalignFactor = 0.0f;
        switch (image.getVerticalImageAlign()) {
            case BOTTOM: {
                yalignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    @Override
    public String getExporterKey() {
        return RTF_EXPORTER_KEY;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return RTF_EXPORTER_PROPERTIES_PREFIX;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRRtfExporterContext {
        protected ExporterContext() {
        }
    }
}

