/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.FillFunctionContext;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.functions.FunctionSupport;

public abstract class JREvaluator
implements DatasetExpressionEvaluator {
    public static final String EXCEPTION_MESSAGE_KEY_RESOURCE_NOT_FOUND = "fill.evaluator.resource.not.found";
    private JRFillParameter resourceBundle;
    private WhenResourceMissingTypeEnum whenResourceMissingType;
    private JRFillParameter locale;
    private Map<String, FunctionSupport> functions;
    private FillFunctionContext functionContext;

    protected JREvaluator() {
    }

    @Override
    public void init(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap, WhenResourceMissingTypeEnum resourceMissingType) throws JRException {
        this.whenResourceMissingType = resourceMissingType;
        this.resourceBundle = parametersMap.get("REPORT_RESOURCE_BUNDLE");
        this.locale = parametersMap.get("REPORT_LOCALE");
        this.functions = new HashMap<String, FunctionSupport>();
        this.functionContext = new FillFunctionContext(parametersMap);
        this.customizedInit(parametersMap, fieldsMap, variablesMap);
    }

    public <T extends FunctionSupport> T getFunctionSupport(Class<T> clazz) {
        String classId = clazz.getName();
        if (!this.functions.containsKey(classId)) {
            try {
                FunctionSupport functionSupport = (FunctionSupport)clazz.newInstance();
                functionSupport.init(this.functionContext);
                this.functions.put(classId, functionSupport);
            }
            catch (IllegalAccessException e2) {
                throw new JRRuntimeException(e2);
            }
            catch (InstantiationException e3) {
                throw new JRRuntimeException(e3);
            }
        }
        return (T)this.functions.get(classId);
    }

    public String msg(String pattern, Object arg0) {
        return this.getMessageFormat(pattern).format(new Object[]{arg0}, new StringBuffer(), (FieldPosition)null).toString();
    }

    public String msg(String pattern, Object arg0, Object arg1) {
        return this.getMessageFormat(pattern).format(new Object[]{arg0, arg1}, new StringBuffer(), (FieldPosition)null).toString();
    }

    public String msg(String pattern, Object arg0, Object arg1, Object arg2) {
        return this.getMessageFormat(pattern).format(new Object[]{arg0, arg1, arg2}, new StringBuffer(), (FieldPosition)null).toString();
    }

    public String msg(String pattern, Object[] args) {
        return this.getMessageFormat(pattern).format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public String str(String key) {
        String str = null;
        try {
            str = ((ResourceBundle)this.resourceBundle.getValue()).getString(key);
        }
        catch (NullPointerException e2) {
            str = this.handleMissingResource(key, e2);
        }
        catch (MissingResourceException e3) {
            str = this.handleMissingResource(key, e3);
        }
        return str;
    }

    @Override
    public Object evaluate(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        if (expression != null) {
            try {
                value = this.evaluate(expression.getId());
            }
            catch (NullPointerException e2) {
            }
            catch (OutOfMemoryError e3) {
                throw e3;
            }
            catch (Throwable e4) {
                throw new JRExpressionEvalException(expression, e4);
            }
        }
        return value;
    }

    @Override
    public Object evaluateOld(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        if (expression != null) {
            try {
                value = this.evaluateOld(expression.getId());
            }
            catch (NullPointerException e2) {
            }
            catch (OutOfMemoryError e3) {
                throw e3;
            }
            catch (Throwable e4) {
                throw new JRExpressionEvalException(expression, e4);
            }
        }
        return value;
    }

    @Override
    public Object evaluateEstimated(JRExpression expression) throws JRExpressionEvalException {
        Object value = null;
        if (expression != null) {
            try {
                value = this.evaluateEstimated(expression.getId());
            }
            catch (NullPointerException e2) {
            }
            catch (OutOfMemoryError e3) {
                throw e3;
            }
            catch (Throwable e4) {
                throw new JRExpressionEvalException(expression, e4);
            }
        }
        return value;
    }

    protected String handleMissingResource(String key, Exception e2) throws JRRuntimeException {
        String str;
        switch (this.whenResourceMissingType) {
            case EMPTY: {
                str = "";
                break;
            }
            case KEY: {
                str = key;
                break;
            }
            case ERROR: {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_RESOURCE_NOT_FOUND, new Object[]{key}, e2);
            }
            default: {
                str = null;
            }
        }
        return str;
    }

    protected abstract void customizedInit(Map<String, JRFillParameter> var1, Map<String, JRFillField> var2, Map<String, JRFillVariable> var3) throws JRException;

    protected abstract Object evaluate(int var1) throws Throwable;

    protected abstract Object evaluateOld(int var1) throws Throwable;

    protected abstract Object evaluateEstimated(int var1) throws Throwable;

    private MessageFormat getMessageFormat(String pattern) {
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale((Locale)this.locale.getValue());
        messageFormat.applyPattern(pattern);
        return messageFormat;
    }
}

