/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jxl.Workbook;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRXlsDataSource;
import net.sf.jasperreports.engine.query.AbstractXlsQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXlsQueryExecuter
extends AbstractXlsQueryExecuter {
    private static final Log log = LogFactory.getLog(JRXlsQueryExecuter.class);

    protected JRXlsQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
    }

    protected JRXlsQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRXlsDataSource datasource = null;
        try {
            Workbook workbook = (Workbook)this.getParameterValue("XLS_WORKBOOK");
            if (workbook != null) {
                datasource = new JRXlsDataSource(workbook);
            } else {
                InputStream xlsInputStream = (InputStream)this.getParameterValue("XLS_INPUT_STREAM");
                if (xlsInputStream != null) {
                    datasource = new JRXlsDataSource(xlsInputStream);
                } else {
                    File xlsFile = (File)this.getParameterValue("XLS_FILE");
                    if (xlsFile != null) {
                        datasource = new JRXlsDataSource(xlsFile);
                    } else {
                        String xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xls.source");
                        if (xlsSource != null) {
                            datasource = new JRXlsDataSource(this.getJasperReportsContext(), xlsSource);
                        } else if (log.isWarnEnabled()) {
                            log.warn("No XLS source was provided.");
                        }
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new JRException(e2);
        }
        if (datasource != null) {
            this.initDatasource(datasource);
        }
        return datasource;
    }
}

