/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Image;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRImageEncoder;
import net.sf.jasperreports.engine.util.JRImageReader;
import net.sf.jasperreports.engine.util.JRJdk14ImageEncoder;
import net.sf.jasperreports.engine.util.JRJdk14ImageReader;

public final class JRImageLoader {
    public static final String PROPERTY_IMAGE_READER = "net.sf.jasperreports.image.reader";
    public static final String PROPERTY_IMAGE_ENCODER = "net.sf.jasperreports.image.encoder";
    public static final String NO_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/image-16.png";
    public static final String SUBREPORT_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/subreport-16.png";
    public static final String CHART_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/chart-16.png";
    public static final String CROSSTAB_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/crosstab-16.png";
    public static final String COMPONENT_IMAGE_RESOURCE = "net/sf/jasperreports/engine/images/component-16.png";
    private JRImageReader imageReader;
    private JRImageEncoder imageEncoder;
    private JasperReportsContext jasperReportsContext;

    private JRImageLoader(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.init();
    }

    private static JRImageLoader getDefaultInstance() {
        return new JRImageLoader(DefaultJasperReportsContext.getInstance());
    }

    public static JRImageLoader getInstance(JasperReportsContext jasperReportsContext) {
        return new JRImageLoader(jasperReportsContext);
    }

    private void init() {
        String readerClassName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_IMAGE_READER);
        if (readerClassName == null) {
            this.imageReader = new JRJdk14ImageReader();
        } else {
            try {
                Class<?> clazz = JRClassLoader.loadClassForRealName(readerClassName);
                this.imageReader = (JRImageReader)clazz.newInstance();
            }
            catch (Exception e2) {
                throw new JRRuntimeException(e2);
            }
        }
        String encoderClassName = JRPropertiesUtil.getInstance(this.jasperReportsContext).getProperty(PROPERTY_IMAGE_ENCODER);
        if (encoderClassName == null) {
            this.imageEncoder = new JRJdk14ImageEncoder();
        } else {
            try {
                Class<?> clazz = JRClassLoader.loadClassForRealName(encoderClassName);
                this.imageEncoder = (JRImageEncoder)clazz.newInstance();
            }
            catch (Exception e3) {
                throw new JRRuntimeException(e3);
            }
        }
    }

    public byte[] loadBytesFromAwtImage(Image image, byte imageType) throws JRException {
        return this.loadBytesFromAwtImage(image, ImageTypeEnum.getByValue(imageType));
    }

    public byte[] loadBytesFromAwtImage(Image image, ImageTypeEnum imageType) throws JRException {
        return this.imageEncoder.encode(image, imageType);
    }

    public Image loadAwtImageFromBytes(byte[] bytes) throws JRException {
        return this.imageReader.readImage(bytes);
    }

    public static byte[] loadImageDataFromAWTImage(Image image, byte imageType) throws JRException {
        return JRImageLoader.getDefaultInstance().loadBytesFromAwtImage(image, imageType);
    }

    public static Image loadImage(byte[] bytes) throws JRException {
        return JRImageLoader.getDefaultInstance().loadAwtImageFromBytes(bytes);
    }
}

