/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.w3c.tools.codec.Base64Decoder;
import org.w3c.tools.codec.Base64Encoder;
import org.w3c.tools.codec.Base64FormatException;

public final class JRValueStringUtils {
    public static final String EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA = "util.value.string.error.parsing.data";
    public static final String EXCEPTION_MESSAGE_KEY_VALUE_NOT_SERIALIZABLE = "util.value.string.value.not.serializable";
    private static final Map<String, ValueSerializer> serializers = JRValueStringUtils.getSerializers();
    private static final ValueSerializer defaultSerializer = new DefaultSerializer();

    public static boolean hasSerializer(String valueClass) {
        return serializers.containsKey(valueClass);
    }

    public static String serialize(String valueClass, Object value) {
        String data;
        if (value == null) {
            data = null;
        } else {
            ValueSerializer serializer = JRValueStringUtils.getSerializer(valueClass);
            data = serializer.serialize(value);
        }
        return data;
    }

    public static Object deserialize(String valueClass, String data) {
        Object value;
        if (data == null) {
            value = null;
        } else {
            ValueSerializer serializer = JRValueStringUtils.getSerializer(valueClass);
            value = serializer.deserialize(data);
        }
        return value;
    }

    protected static ValueSerializer getSerializer(String valueClass) {
        ValueSerializer serializer = serializers.get(valueClass);
        if (serializer == null) {
            serializer = defaultSerializer;
        }
        return serializer;
    }

    private static Map<String, ValueSerializer> getSerializers() {
        HashMap<String, ValueSerializer> map = new HashMap<String, ValueSerializer>();
        map.put(String.class.getName(), new StringSerializer());
        map.put(Character.class.getName(), new CharacterSerializer());
        map.put(Boolean.class.getName(), new BooleanSerializer());
        map.put(Byte.class.getName(), new ByteSerializer());
        map.put(Short.class.getName(), new ShortSerializer());
        map.put(Integer.class.getName(), new IntegerSerializer());
        map.put(Long.class.getName(), new LongSerializer());
        map.put(Float.class.getName(), new FloatSerializer());
        map.put(Double.class.getName(), new DoubleSerializer());
        map.put(BigInteger.class.getName(), new BigIntegerSerializer());
        map.put(BigDecimal.class.getName(), new BigDecimalSerializer());
        map.put(Date.class.getName(), new DateSerializer());
        map.put(Timestamp.class.getName(), new TimestampSerializer());
        map.put(Time.class.getName(), new TimeSerializer());
        return map;
    }

    private JRValueStringUtils() {
    }

    protected static class DefaultSerializer
    implements ValueSerializer {
        protected DefaultSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                ByteArrayInputStream dataIn = new ByteArrayInputStream(data.getBytes());
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                Base64Decoder dec = new Base64Decoder(dataIn, bytesOut);
                dec.process();
                ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
                ObjectInputStream objectIn = new ObjectInputStream(bytesIn);
                return objectIn.readObject();
            }
            catch (IOException e2) {
                throw new JRRuntimeException(e2);
            }
            catch (ClassNotFoundException e3) {
                throw new JRRuntimeException(e3);
            }
            catch (Base64FormatException e4) {
                throw new JRRuntimeException(e4);
            }
        }

        @Override
        public String serialize(Object value) {
            try {
                ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);
                objectOut.writeObject(value);
                objectOut.close();
                ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
                ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
                Base64Encoder enc = new Base64Encoder(bytesIn, dataOut);
                enc.process();
                return new String(dataOut.toByteArray(), "UTF-8");
            }
            catch (NotSerializableException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_VALUE_NOT_SERIALIZABLE, null, e2);
            }
            catch (IOException e3) {
                throw new JRRuntimeException(e3);
            }
        }
    }

    protected static class TimeSerializer
    implements ValueSerializer {
        protected TimeSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Time.valueOf(data);
            }
            catch (IllegalArgumentException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Time", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            Time timestamp = (Time)value;
            return timestamp.toString();
        }
    }

    protected static class TimestampSerializer
    implements ValueSerializer {
        protected TimestampSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Timestamp.valueOf(data);
            }
            catch (IllegalArgumentException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Timestamp", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            Timestamp timestamp = (Timestamp)value;
            return timestamp.toString();
        }
    }

    protected static class DateSerializer
    implements ValueSerializer {
        protected DateSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                long time = Long.parseLong(data);
                return new Date(time);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Date", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return Long.toString(((Date)value).getTime());
        }
    }

    protected static class BigDecimalSerializer
    implements ValueSerializer {
        protected BigDecimalSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return new BigDecimal(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"BigDecimal", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((BigDecimal)value).toString();
        }
    }

    protected static class BigIntegerSerializer
    implements ValueSerializer {
        protected BigIntegerSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return new BigInteger(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"BigInteger", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((BigInteger)value).toString();
        }
    }

    protected static class DoubleSerializer
    implements ValueSerializer {
        protected DoubleSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Double.valueOf(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Double", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Double)value).toString();
        }
    }

    protected static class FloatSerializer
    implements ValueSerializer {
        protected FloatSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Float.valueOf(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Float", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Float)value).toString();
        }
    }

    protected static class LongSerializer
    implements ValueSerializer {
        protected LongSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Long.valueOf(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Long", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Long)value).toString();
        }
    }

    protected static class IntegerSerializer
    implements ValueSerializer {
        protected IntegerSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Integer.valueOf(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Integer", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Integer)value).toString();
        }
    }

    protected static class ShortSerializer
    implements ValueSerializer {
        protected ShortSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Short.valueOf(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Short", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Short)value).toString();
        }
    }

    protected static class ByteSerializer
    implements ValueSerializer {
        protected ByteSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            try {
                return Byte.valueOf(data);
            }
            catch (NumberFormatException e2) {
                throw new JRRuntimeException(JRValueStringUtils.EXCEPTION_MESSAGE_KEY_ERROR_PARSING_DATA, new Object[]{"Byte", data}, e2);
            }
        }

        @Override
        public String serialize(Object value) {
            return ((Byte)value).toString();
        }
    }

    protected static class BooleanSerializer
    implements ValueSerializer {
        public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_DATA = "util.boolean.serializer.unknown.data";

        protected BooleanSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            if (data.equals("true")) {
                return Boolean.TRUE;
            }
            if (data.equals("false")) {
                return Boolean.FALSE;
            }
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNKNOWN_DATA, new Object[]{data});
        }

        @Override
        public String serialize(Object value) {
            return (Boolean)value != false ? "true" : "false";
        }
    }

    protected static class CharacterSerializer
    implements ValueSerializer {
        public static final String EXCEPTION_MESSAGE_KEY_SINGLE_CHARACTER_EXPECTED = "util.character.serializer.single.character.expected";

        protected CharacterSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            if (data.length() != 1) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_SINGLE_CHARACTER_EXPECTED, new Object[]{data});
            }
            return new Character(data.charAt(0));
        }

        @Override
        public String serialize(Object value) {
            return String.valueOf(new char[]{((Character)value).charValue()});
        }
    }

    protected static class StringSerializer
    implements ValueSerializer {
        protected StringSerializer() {
        }

        @Override
        public Object deserialize(String data) {
            return data;
        }

        @Override
        public String serialize(Object value) {
            return (String)value;
        }
    }

    protected static interface ValueSerializer {
        public String serialize(Object var1);

        public Object deserialize(String var1);
    }
}

