/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.VirtualizerStore;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.util.StreamCompression;
import net.sf.jasperreports.engine.util.VirtualizationSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwapFileVirtualizerStore
implements VirtualizerStore {
    private static final Log log = LogFactory.getLog(SwapFileVirtualizerStore.class);
    public static final String EXCEPTION_MESSAGE_KEY_DEVIRTUALIZING_ERROR = "util.swap.file.virtualizer.devirtualizing.error";
    public static final String EXCEPTION_MESSAGE_KEY_UNABLE_TO_READ_DATA = "util.swap.file.virtualizer.unable.to.read.data";
    public static final String EXCEPTION_MESSAGE_KEY_VIRTUALIZING_ERROR = "util.swap.file.virtualizer.virtualizing.error";
    private final JRSwapFile swap;
    private final boolean swapOwner;
    private final Map<String, JRSwapFile.SwapHandle> handles;
    private final StreamCompression compression;

    public SwapFileVirtualizerStore(JRSwapFile swap, boolean swapOwner) {
        this(swap, swapOwner, null);
    }

    public SwapFileVirtualizerStore(JRSwapFile swap, boolean swapOwner, StreamCompression compression) {
        this.swap = swap;
        this.swapOwner = swapOwner;
        this.handles = Collections.synchronizedMap(new HashMap());
        this.compression = compression;
    }

    public String toString() {
        return "SwapFileVirtualizerStore " + this.swap.toString();
    }

    protected boolean isStored(JRVirtualizable<?> o2) {
        return this.handles.containsKey(o2.getUID());
    }

    @Override
    public boolean store(JRVirtualizable<?> o2, VirtualizationSerializer serializer) {
        if (this.isStored(o2)) {
            if (log.isTraceEnabled()) {
                log.trace("object " + o2.getUID() + " already stored");
            }
            return false;
        }
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(3000);
            ByteArrayOutputStream out = this.compression == null ? bout : this.compression.compressedOutput(bout);
            serializer.writeData(o2, out);
            ((OutputStream)out).close();
            byte[] data = bout.toByteArray();
            if (log.isTraceEnabled()) {
                log.trace("writing " + data.length + " for object " + o2.getUID() + " to " + this.swap);
            }
            JRSwapFile.SwapHandle handle = this.swap.write(data);
            this.handles.put(o2.getUID(), handle);
            return true;
        }
        catch (IOException e2) {
            log.error("Error virtualizing object " + o2.getUID() + " to " + this.swap, e2);
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_VIRTUALIZING_ERROR, null, e2);
        }
    }

    @Override
    public void retrieve(JRVirtualizable<?> o2, boolean remove, VirtualizationSerializer serializer) {
        JRSwapFile.SwapHandle handle = this.handles.get(o2.getUID());
        if (handle == null) {
            log.error("No swap handle found for " + o2.getUID() + " in " + this);
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNABLE_TO_READ_DATA, (Object[])null);
        }
        try {
            byte[] data = this.swap.read(handle, remove);
            if (log.isTraceEnabled()) {
                log.trace("read " + data.length + " for object " + o2.getUID() + " from " + this.swap);
            }
            ByteArrayInputStream rawInput = new ByteArrayInputStream(data);
            ByteArrayInputStream input = this.compression == null ? rawInput : this.compression.uncompressedInput(rawInput);
            serializer.readData(o2, input);
            ((InputStream)input).close();
        }
        catch (IOException e2) {
            log.error("Error reading object data " + o2.getUID() + " from " + this.swap, e2);
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_DEVIRTUALIZING_ERROR, null, e2);
        }
        if (remove) {
            this.handles.remove(o2.getUID());
        }
    }

    @Override
    public void remove(String objectId) {
        JRSwapFile.SwapHandle handle = this.handles.remove(objectId);
        if (handle == null) {
            if (log.isTraceEnabled()) {
                log.trace("object " + objectId + " not found for removal");
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("removing object " + objectId + " from " + this.swap);
            }
            this.swap.free(handle);
        }
    }

    @Override
    public void dispose() {
        this.handles.clear();
        if (this.swapOwner) {
            if (log.isDebugEnabled()) {
                log.debug("disposing " + this.swap);
            }
            this.swap.dispose();
        }
    }
}

