/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.export.CommonExportConfiguration;
import net.sf.jasperreports.export.annotations.ExporterProperty;

public class PropertiesExporterConfigurationFactory<C extends CommonExportConfiguration> {
    public static Object getPropertyValue(JasperReportsContext jasperReportsContext, JRPropertiesHolder propertiesHolder, ExporterProperty exporterProperty, Class<?> type) {
        Object value = null;
        String propertyName = exporterProperty.value();
        if (String[].class.equals(type)) {
            List<JRPropertiesUtil.PropertySuffix> properties = JRPropertiesUtil.getProperties(propertiesHolder, propertyName);
            if (properties != null && !properties.isEmpty()) {
                String[] values = new String[properties.size()];
                for (int i2 = 0; i2 < values.length; ++i2) {
                    values[i2] = properties.get(i2).getValue();
                }
                value = values;
            }
        } else {
            JRPropertiesUtil propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
            if (String.class.equals(type)) {
                value = propertiesUtil.getProperty(propertiesHolder, propertyName);
            } else if (Character.class.equals(type)) {
                value = propertiesUtil.getCharacterProperty(propertiesHolder, propertyName);
            } else if (Integer.class.equals(type)) {
                value = exporterProperty.acceptNull() ? propertiesUtil.getIntegerProperty(propertiesHolder, propertyName) : Integer.valueOf(propertiesUtil.getIntegerProperty(propertiesHolder, propertyName, exporterProperty.intDefault()));
            } else if (Long.class.equals(type)) {
                value = propertiesUtil.getLongProperty(propertiesHolder, propertyName, exporterProperty.longDefault());
            } else if (Float.class.equals(type)) {
                value = exporterProperty.acceptNull() ? propertiesUtil.getFloatProperty(propertiesHolder, propertyName) : Float.valueOf(propertiesUtil.getFloatProperty(propertiesHolder, propertyName, exporterProperty.floatDefault()));
            } else if (Boolean.class.equals(type)) {
                value = propertiesUtil.getBooleanProperty(propertiesHolder, propertyName, exporterProperty.booleanDefault());
            } else if (NamedEnum.class.isAssignableFrom(type)) {
                value = propertiesUtil.getProperty(propertiesHolder, propertyName);
                try {
                    Method byNameMethod = type.getMethod("getByName", String.class);
                    value = byNameMethod.invoke(null, value);
                }
                catch (NoSuchMethodException e2) {
                    throw new JRRuntimeException(e2);
                }
                catch (InvocationTargetException e3) {
                    throw new JRRuntimeException(e3);
                }
                catch (IllegalAccessException e4) {
                    throw new JRRuntimeException(e4);
                }
            } else {
                throw new JRRuntimeException("Export property type " + type + " not supported.");
            }
        }
        return value;
    }
}

