/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterContext;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.XlsExporterConfiguration;
import net.sf.jasperreports.export.XlsReportConfiguration;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public abstract class AbstractXlsServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = 10200L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<JasperPrint> jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        Boolean isBuffered = Boolean.valueOf(request.getParameter("buffered"));
        if (isBuffered.booleanValue()) {
            FileBufferedOutputStream fbos = new FileBufferedOutputStream();
            JRXlsAbstractExporter<XlsReportConfiguration, XlsExporterConfiguration, JRXlsExporterContext> exporter = this.getXlsExporter();
            exporter.setExporterInput(SimpleExporterInput.getInstance(jasperPrintList));
            exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(fbos));
            SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
            configuration.setOnePagePerSheet(false);
            configuration.setWhitePageBackground(false);
            exporter.setConfiguration((XlsExporterConfiguration)((Object)configuration));
            try {
                exporter.exportReport();
                fbos.close();
                if (fbos.size() <= 0) return;
                response.setContentType(this.getResponseContentType());
                this.setResponseHeader(response);
                response.setContentLength(fbos.size());
                ServletOutputStream outputStream = response.getOutputStream();
                try {
                    fbos.writeData(outputStream);
                    fbos.dispose();
                    outputStream.flush();
                    return;
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
            catch (JRException e2) {
                throw new ServletException(e2);
            }
            finally {
                fbos.close();
                fbos.dispose();
            }
        }
        response.setContentType(this.getResponseContentType());
        this.setResponseHeader(response);
        JRXlsAbstractExporter<XlsReportConfiguration, XlsExporterConfiguration, JRXlsExporterContext> exporter = this.getXlsExporter();
        exporter.setExporterInput(SimpleExporterInput.getInstance(jasperPrintList));
        ServletOutputStream outputStream = response.getOutputStream();
        exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(outputStream));
        SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
        configuration.setOnePagePerSheet(false);
        configuration.setWhitePageBackground(false);
        exporter.setConfiguration((XlsExporterConfiguration)((Object)configuration));
        try {
            exporter.exportReport();
            return;
        }
        catch (JRException e3) {
            throw new ServletException(e3);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    protected abstract JRXlsAbstractExporter<XlsReportConfiguration, XlsExporterConfiguration, JRXlsExporterContext> getXlsExporter();

    protected String getResponseContentType() {
        return "application/xls";
    }

    protected void setResponseHeader(HttpServletResponse response) {
        response.setHeader("Content-Disposition", "inline; filename=\"file.xls\"");
    }
}

