/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import mondrian.olap.Result;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import net.sf.jasperreports.olap.JRMondrianDataSource;
import net.sf.jasperreports.olap.mondrian.JRMondrianResult;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapHierarchyLevel;
import net.sf.jasperreports.olap.result.JROlapMember;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResultAxis;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRMondrianQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(JRMondrianQueryExecuter.class);
    private Connection connection = (Connection)this.getParameterValue("MONDRIAN_CONNECTION");
    private Result result;

    public JRMondrianQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        if (this.connection == null) {
            log.warn("The supplied mondrian.olap.Connection object is null.");
        }
        this.parseQuery();
    }

    public JRMondrianQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return "MDX";
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        JRMondrianDataSource dataSource = null;
        String queryStr = this.getQueryString();
        if (this.connection != null && queryStr != null) {
            if (log.isDebugEnabled()) {
                log.debug("MDX query: " + queryStr);
            }
            Query query = this.connection.parseQuery(queryStr);
            this.result = this.connection.execute(query);
            this.logResult();
            dataSource = new JRMondrianDataSource(this.dataset, this.result);
        }
        return dataSource;
    }

    @Override
    public void close() {
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    public Result getResult() {
        return this.result;
    }

    protected void logResult() {
        if (!log.isDebugEnabled()) {
            return;
        }
        JRMondrianResult monResult = new JRMondrianResult(this.result);
        HashSet<String> measureNames = new HashSet<String>();
        ArrayList allLevelExpressions = new ArrayList();
        int axisCount = 0;
        int levelCount = 0;
        for (JROlapResultAxis axis : monResult.getAxes()) {
            log.debug("Axis: " + axisCount);
            String prefix = axisCount == 0 ? "Columns" : "Rows";
            for (JROlapHierarchy hier : axis.getHierarchiesOnAxis()) {
                log.debug("\t Hierarchy: " + hier.getDimensionName() + " - " + hier.getHierarchyUniqueName());
                log.debug("\t\tLevels");
                boolean foundMeasuresLevel = false;
                boolean emittedLevel = false;
                for (JROlapHierarchyLevel level : hier.getLevels()) {
                    log.debug("\t\t\t" + (level == null ? "null" : level.getName() + ", depth: " + level.getDepth()));
                    if (level == null) continue;
                    if (level.getName().equalsIgnoreCase("MeasuresLevel")) {
                        foundMeasuresLevel = true;
                        continue;
                    }
                    emittedLevel = true;
                    String rowsExpression = prefix + this.makeOlapExpression(hier.getDimensionName()) + "[" + level.getName() + "]";
                    List<String> thisLevelExpressions = null;
                    if (levelCount >= allLevelExpressions.size()) {
                        thisLevelExpressions = new ArrayList();
                        allLevelExpressions.add(thisLevelExpressions);
                    } else {
                        thisLevelExpressions = (List)allLevelExpressions.get(levelCount);
                    }
                    thisLevelExpressions.add(rowsExpression);
                    log.debug("\t\t\t\t" + this.makeJRFieldName(hier.getDimensionName() + level.getName()) + "- " + rowsExpression);
                }
                if (emittedLevel) {
                    ++levelCount;
                }
                for (int i2 = 0; i2 < axis.getTupleCount(); ++i2) {
                    JROlapMemberTuple memberTuple = axis.getTuple(i2);
                    for (int j2 = 0; j2 < memberTuple.getMembers().length; ++j2) {
                        JROlapMember member = memberTuple.getMembers()[j2];
                        if (!foundMeasuresLevel || !this.isMeasureMember(member.getUniqueName()) || measureNames.contains(member.getUniqueName())) continue;
                        measureNames.add(member.getUniqueName());
                    }
                }
            }
            ++axisCount;
        }
        for (String measureName : measureNames) {
            log.debug("\t\t\t\t" + this.makeJRFieldName(measureName) + "- Data(" + measureName + ",?)");
        }
    }

    private String makeJRFieldName(String s2) {
        String out = s2.replace(" ", "");
        out = out.replace("[", "");
        out = out.replace("]", "");
        out = out.replace("(", "");
        out = out.replace(")", "");
        out = out.replace(".", "");
        return out;
    }

    private String makeOlapExpression(String s2) {
        String out = s2.trim();
        int pos = out.indexOf("].[");
        if (pos != -1) {
            out = out.substring(pos + 2);
        }
        if (out.charAt(0) != '[') {
            out = "[" + out;
        }
        if (out.charAt(out.length() - 1) != ']') {
            out = out + "]";
        }
        return out;
    }

    private boolean isMeasureMember(String uniqueName) {
        return uniqueName.startsWith("[Measures].");
    }
}

