/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.olap.mondrian;

import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Hierarchy;
import mondrian.olap.Position;
import net.sf.jasperreports.olap.mondrian.JRMondrianFactory;
import net.sf.jasperreports.olap.mondrian.JRMondrianHierarchy;
import net.sf.jasperreports.olap.mondrian.JRMondrianTuple;
import net.sf.jasperreports.olap.result.JROlapHierarchy;
import net.sf.jasperreports.olap.result.JROlapMemberTuple;
import net.sf.jasperreports.olap.result.JROlapResultAxis;

public class JRMondrianAxis
implements JROlapResultAxis {
    private final JRMondrianTuple[] tuples;
    private final JRMondrianHierarchy[] hierarchies;

    public JRMondrianAxis(Axis axis, Hierarchy[] axisHierarchies, JRMondrianFactory factory) {
        List positions = axis.getPositions();
        this.tuples = new JRMondrianTuple[positions.size()];
        int idx = 0;
        for (Position position : positions) {
            this.tuples[idx] = new JRMondrianTuple(position, factory);
            ++idx;
        }
        this.hierarchies = new JRMondrianHierarchy[axisHierarchies.length];
        for (int i2 = 0; i2 < axisHierarchies.length; ++i2) {
            this.hierarchies[i2] = new JRMondrianHierarchy(axisHierarchies[i2]);
        }
    }

    @Override
    public JROlapHierarchy[] getHierarchiesOnAxis() {
        return this.hierarchies;
    }

    @Override
    public JROlapMemberTuple getTuple(int index) {
        if (index < 0 || index >= this.tuples.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.tuples.length);
        }
        return this.tuples[index];
    }

    @Override
    public int getTupleCount() {
        return this.tuples.length;
    }
}

