/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.PrintPart;
import net.sf.jasperreports.engine.PrintParts;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleGraphics2DExporterOutput;
import net.sf.jasperreports.export.SimpleGraphics2DReportConfiguration;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRViewerPanel
extends JPanel
implements JRHyperlinkListener,
JRViewerListener {
    private static final Log log = LogFactory.getLog(JRViewerPanel.class);
    private static final long serialVersionUID = 10200L;
    public static final int REPORT_RESOLUTION = 72;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private PageRenderer lblPage;
    private JPanel pnlInScroll;
    private JPanel pnlLinks;
    private JPanel pnlPage;
    private JTabbedPane pnlTabs;
    private JScrollPane scrollPane;
    private final JRViewerController viewerContext;
    private JRGraphics2DExporter exporter;
    private boolean pageError;
    private int downX;
    private int downY;
    private boolean pnlTabsChangeListenerEnabled = true;
    private List<JRHyperlinkListener> hyperlinkListeners = new ArrayList<JRHyperlinkListener>();
    private Map<JPanel, JRPrintHyperlink> linksMap = new HashMap<JPanel, JRPrintHyperlink>();
    private int screenResolution = 72;
    protected float realZoom;
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent evt) {
            JRViewerPanel.this.hyperlinkClicked(evt);
        }
    };
    protected KeyListener keyNavigationListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent evt) {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            JRViewerPanel.this.keyNavigate(evt);
        }

        @Override
        public void keyReleased(KeyEvent evt) {
        }
    };

    public JRViewerPanel(JRViewerController viewerContext) {
        this.viewerContext = viewerContext;
        this.viewerContext.addListener(this);
        this.setScreenDetails();
        this.initComponents();
        this.addHyperlinkListener(this);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlTabs = new JTabbedPane();
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new PageRenderer();
        this.setMinimumSize(new Dimension(450, 150));
        this.setPreferredSize(new Dimension(450, 150));
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                JRViewerPanel.this.pnlMainComponentResized(evt);
            }
        });
        this.pnlTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JRViewerPanel.this.pnlTabsStateChanged(evt);
            }
        });
        this.add((Component)this.pnlTabs, "Center");
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.pnlLinks.setLayout(null);
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JRViewerPanel.this.pnlLinksMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JRViewerPanel.this.pnlLinksMouseReleased(evt);
            }
        });
        this.pnlLinks.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                JRViewerPanel.this.pnlLinksMouseDragged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, gridBagConstraints);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.add((Component)this.scrollPane, "Center");
    }

    public KeyListener getKeyNavigationListener() {
        return this.keyNavigationListener;
    }

    protected void setScreenDetails() {
        this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public void addHyperlinkListener(JRHyperlinkListener listener) {
        this.hyperlinkListeners.add(listener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener listener) {
        this.hyperlinkListeners.remove(listener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }

    @Override
    public void gotoHyperlink(JRPrintHyperlink hyperlink) {
        switch (hyperlink.getHyperlinkTypeValue()) {
            case REFERENCE: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case LOCAL_ANCHOR: {
                Container container;
                if (hyperlink.getHyperlinkAnchor() == null) break;
                Map<String, JRPrintAnchorIndex> anchorIndexes = this.viewerContext.getJasperPrint().getAnchorIndexes();
                JRPrintAnchorIndex anchorIndex = anchorIndexes.get(hyperlink.getHyperlinkAnchor());
                if (anchorIndex.getPageIndex() != this.viewerContext.getPageIndex()) {
                    this.viewerContext.setPageIndex(anchorIndex.getPageIndex());
                    this.viewerContext.refreshPage();
                }
                if (!((container = this.pnlInScroll.getParent()) instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                int newX = (int)((float)anchorIndex.getElementAbsoluteX() * this.realZoom);
                int newY = (int)((float)anchorIndex.getElementAbsoluteY() * this.realZoom);
                int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
                int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
                if (newX < 0) {
                    newX = 0;
                }
                if (newX > maxX) {
                    newX = maxX;
                }
                if (newY < 0) {
                    newY = 0;
                }
                if (newY > maxY) {
                    newY = maxY;
                }
                viewport.setViewPosition(new Point(newX, newY));
                break;
            }
            case LOCAL_PAGE: {
                int page = this.viewerContext.getPageIndex() + 1;
                if (hyperlink.getHyperlinkPage() != null) {
                    page = hyperlink.getHyperlinkPage();
                }
                if (page < 1 || page > this.viewerContext.getJasperPrint().getPages().size() || page == this.viewerContext.getPageIndex() + 1) break;
                this.viewerContext.setPageIndex(page - 1);
                this.viewerContext.refreshPage();
                Container container = this.pnlInScroll.getParent();
                if (!(container instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                viewport.setViewPosition(new Point(0, 0));
                break;
            }
            case REMOTE_ANCHOR: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink anchor    : " + hyperlink.getHyperlinkAnchor());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case REMOTE_PAGE: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink page      : " + hyperlink.getHyperlinkPage());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case CUSTOM: {
                if (!this.isOnlyHyperlinkListener()) break;
                System.out.println("Hyperlink of type " + hyperlink.getLinkType());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
        }
    }

    protected boolean isOnlyHyperlinkListener() {
        int listenerCount;
        if (this.hyperlinkListeners == null) {
            listenerCount = 0;
        } else {
            listenerCount = this.hyperlinkListeners.size();
            if (this.hyperlinkListeners.contains(this)) {
                --listenerCount;
            }
        }
        return listenerCount == 0;
    }

    protected void paintPage(Graphics2D grx) {
        if (this.pageError) {
            this.paintPageError(grx);
            return;
        }
        try {
            if (this.exporter == null) {
                this.exporter = this.getGraphics2DExporter();
            } else {
                this.exporter.reset();
            }
            this.exporter.setExporterInput(new SimpleExporterInput(this.viewerContext.getJasperPrint()));
            SimpleGraphics2DExporterOutput output = new SimpleGraphics2DExporterOutput();
            output.setGraphics2D((Graphics2D)grx.create());
            this.exporter.setExporterOutput(output);
            SimpleGraphics2DReportConfiguration configuration = new SimpleGraphics2DReportConfiguration();
            configuration.setPageIndex(this.viewerContext.getPageIndex());
            configuration.setZoomRatio(Float.valueOf(this.realZoom));
            configuration.setOffsetX(1);
            configuration.setOffsetY(1);
            this.exporter.setConfiguration(configuration);
            this.exporter.exportReport();
        }
        catch (Exception e2) {
            if (log.isErrorEnabled()) {
                log.error("Page paint error.", e2);
            }
            this.pageError = true;
            this.paintPageError(grx);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(JRViewerPanel.this, JRViewerPanel.this.viewerContext.getBundleString("error.displaying"));
                }
            });
        }
    }

    protected JRGraphics2DExporter getGraphics2DExporter() throws JRException {
        return new JRGraphics2DExporter(this.viewerContext.getJasperReportsContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintPageError(Graphics2D grx) {
        AffineTransform origTransform = grx.getTransform();
        AffineTransform transform = new AffineTransform();
        transform.translate(1.0, 1.0);
        transform.scale(this.realZoom, this.realZoom);
        grx.transform(transform);
        try {
            this.drawPageError(grx);
        }
        finally {
            grx.setTransform(origTransform);
        }
    }

    protected void drawPageError(Graphics grx) {
        PrintPageFormat pageFormat = this.viewerContext.getPageFormat();
        grx.setColor(Color.white);
        grx.fillRect(0, 0, pageFormat.getPageWidth() + 1, pageFormat.getPageHeight() + 1);
    }

    void pnlMainComponentResized(ComponentEvent evt) {
        if (this.viewerContext.isFitPage()) {
            this.viewerContext.fitPage();
        } else if (this.viewerContext.isFitWidth()) {
            this.viewerContext.fitWidth();
        }
    }

    protected void fitPage() {
        float widthRatio;
        PrintPageFormat pageFormat = this.viewerContext.getPageFormat();
        float heightRatio = this.getPageCanvasHeight() / (float)pageFormat.getPageHeight().intValue();
        this.setRealZoomRatio(heightRatio < (widthRatio = this.getPageCanvasWidth() / (float)pageFormat.getPageWidth().intValue()) ? heightRatio : widthRatio);
    }

    protected void fitWidth() {
        this.setRealZoomRatio(this.getPageCanvasWidth() / (float)this.viewerContext.getPageFormat().getPageWidth().intValue());
    }

    protected float getPageCanvasWidth() {
        return (float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f;
    }

    protected float getPageCanvasHeight() {
        return (float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f;
    }

    void pnlLinksMousePressed(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    void pnlLinksMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    void pnlLinksMouseReleased(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    private void pnlTabsStateChanged(ChangeEvent evt) {
        if (this.pnlTabsChangeListenerEnabled) {
            ((JPanel)this.pnlTabs.getSelectedComponent()).add(this.scrollPane);
            Integer pgIdx = 0;
            Integer partIndex = this.pnlTabs.getSelectedIndex();
            if (partIndex > 0) {
                PrintParts parts;
                JasperPrint jasperPrint = this.viewerContext.getJasperPrint();
                PrintParts printParts = parts = jasperPrint == null ? null : jasperPrint.getParts();
                if (parts != null && parts.hasParts()) {
                    partIndex = parts.startsAtZero() ? partIndex : partIndex - 1;
                    pgIdx = parts.getStartPageIndex(partIndex);
                }
            }
            this.viewerContext.setPageIndex(pgIdx);
            this.viewerContext.refreshPage();
        }
    }

    protected void pageChanged() {
        if (this.viewerContext.hasPages()) {
            Integer pageIndex;
            PrintParts parts;
            Integer partIndex;
            this.pageError = false;
            if (this.viewerContext.getJasperPrint().hasParts() && (partIndex = Integer.valueOf((parts = this.viewerContext.getJasperPrint().getParts()).getPartIndex(pageIndex = Integer.valueOf(this.viewerContext.getPageIndex())))) < this.pnlTabs.getComponentCount()) {
                this.pnlTabsChangeListenerEnabled = false;
                this.pnlTabs.setSelectedIndex(partIndex - (parts.startsAtZero() ? 1 : 0));
                ((JPanel)this.pnlTabs.getSelectedComponent()).add(this.scrollPane);
                this.pnlTabsChangeListenerEnabled = true;
            }
        }
    }

    protected void refreshTabs() {
        PrintParts parts;
        this.pnlTabsChangeListenerEnabled = false;
        this.pnlTabs.removeAll();
        this.removeAll();
        JasperPrint jasperPrint = this.viewerContext.getJasperPrint();
        PrintParts printParts = parts = jasperPrint == null ? null : jasperPrint.getParts();
        if (parts == null || !parts.hasParts()) {
            this.add((Component)this.scrollPane, "Center");
        } else {
            if (!parts.startsAtZero()) {
                JPanel partTab = new JPanel();
                partTab.setLayout(new BorderLayout());
                partTab.setName(this.viewerContext.getJasperPrint().getName());
                this.pnlTabs.add(partTab);
            }
            Iterator<Map.Entry<Integer, PrintPart>> it = parts.partsIterator();
            while (it.hasNext()) {
                PrintPart part = it.next().getValue();
                JPanel partTab = new JPanel();
                partTab.setLayout(new BorderLayout());
                partTab.setName(part.getName());
                this.pnlTabs.add(partTab);
            }
            this.add((Component)this.pnlTabs, "Center");
        }
        this.pnlTabsChangeListenerEnabled = true;
    }

    protected void refreshPage() {
        long imageSize;
        if (!this.viewerContext.hasPages()) {
            this.pnlPage.setVisible(false);
            if (this.viewerContext.getJasperPrint() != null) {
                JOptionPane.showMessageDialog(this, this.viewerContext.getBundleString("no.pages"));
            }
            return;
        }
        this.pnlPage.setVisible(true);
        PrintPageFormat pageFormat = this.viewerContext.getPageFormat();
        Dimension dim = new Dimension((int)((float)pageFormat.getPageWidth().intValue() * this.realZoom) + 8, (int)((float)pageFormat.getPageHeight().intValue() * this.realZoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        long maxImageSize = JRPropertiesUtil.getInstance(this.viewerContext.getJasperReportsContext()).getLongProperty("net.sf.jasperreports.viewer.render.buffer.max.size");
        boolean renderImage = maxImageSize <= 0L ? false : (imageSize = (long)(((int)((float)pageFormat.getPageWidth().intValue() * this.realZoom) + 1) * ((int)((float)pageFormat.getPageHeight().intValue() * this.realZoom) + 1))) <= maxImageSize;
        this.lblPage.setRenderImage(renderImage);
        if (renderImage) {
            this.setPageImage();
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap<JPanel, JRPrintHyperlink>();
        this.createHyperlinks();
        if (!renderImage) {
            this.lblPage.setIcon(null);
            this.validate();
            this.repaint();
        }
    }

    protected void setPageImage() {
        Image image;
        if (this.pageError) {
            image = this.getPageErrorImage();
        } else {
            try {
                image = JasperPrintManager.getInstance(this.viewerContext.getJasperReportsContext()).printToImage(this.viewerContext.getJasperPrint(), this.viewerContext.getPageIndex(), this.realZoom);
            }
            catch (Exception e2) {
                if (log.isErrorEnabled()) {
                    log.error("Print page to image error.", e2);
                }
                this.pageError = true;
                image = this.getPageErrorImage();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.displaying"));
            }
        }
        ImageIcon imageIcon = new ImageIcon(image);
        this.lblPage.setIcon(imageIcon);
    }

    protected Image getPageErrorImage() {
        PrintPageFormat pageFormat = this.viewerContext.getPageFormat();
        BufferedImage image = new BufferedImage((int)((float)pageFormat.getPageWidth().intValue() * this.realZoom) + 1, (int)((float)pageFormat.getPageHeight().intValue() * this.realZoom) + 1, 1);
        Graphics2D grx = (Graphics2D)((Image)image).getGraphics();
        AffineTransform transform = new AffineTransform();
        transform.scale(this.realZoom, this.realZoom);
        grx.transform(transform);
        this.drawPageError(grx);
        return image;
    }

    protected void zoomChanged() {
        this.realZoom = this.viewerContext.getZoom() * (float)this.screenResolution / 72.0f;
    }

    protected void createHyperlinks() {
        List<JRPrintPage> pages = this.viewerContext.getJasperPrint().getPages();
        JRPrintPage page = pages.get(this.viewerContext.getPageIndex());
        this.createHyperlinks(page.getElements(), 0, 0);
    }

    protected void createHyperlinks(List<JRPrintElement> elements, int offsetX, int offsetY) {
        if (elements != null && elements.size() > 0) {
            for (JRPrintElement element : elements) {
                boolean hasTooltip;
                Renderable renderer;
                ImageMapRenderable imageMap = null;
                if (element instanceof JRPrintImage && (renderer = ((JRPrintImage)element).getRenderable()) instanceof ImageMapRenderable && !(imageMap = (ImageMapRenderable)renderer).hasImageAreaHyperlinks()) {
                    imageMap = null;
                }
                boolean hasImageMap = imageMap != null;
                JRPrintHyperlink hyperlink = null;
                if (element instanceof JRPrintHyperlink) {
                    hyperlink = (JRPrintHyperlink)((Object)element);
                }
                boolean hasHyperlink = !hasImageMap && hyperlink != null && hyperlink.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE;
                boolean bl = hasTooltip = hyperlink != null && hyperlink.getHyperlinkTooltip() != null;
                if (hasHyperlink || hasImageMap || hasTooltip) {
                    JPanel link;
                    if (hasImageMap) {
                        Rectangle renderingArea = new Rectangle(0, 0, element.getWidth(), element.getHeight());
                        link = new ImageMapPanel(renderingArea, imageMap);
                    } else {
                        link = new JPanel();
                        if (hasHyperlink) {
                            link.addMouseListener(this.mouseListener);
                        }
                    }
                    if (hasHyperlink) {
                        link.setCursor(new Cursor(12));
                    }
                    link.setLocation((int)((float)(element.getX() + offsetX) * this.realZoom), (int)((float)(element.getY() + offsetY) * this.realZoom));
                    link.setSize((int)((float)element.getWidth() * this.realZoom), (int)((float)element.getHeight() * this.realZoom));
                    link.setOpaque(false);
                    String toolTip = this.getHyperlinkTooltip(hyperlink);
                    if (toolTip == null && hasImageMap) {
                        toolTip = "";
                    }
                    link.setToolTipText(toolTip);
                    this.pnlLinks.add(link);
                    this.linksMap.put(link, hyperlink);
                }
                if (!(element instanceof JRPrintFrame)) continue;
                JRPrintFrame frame = (JRPrintFrame)element;
                int frameOffsetX = offsetX + frame.getX() + frame.getLineBox().getLeftPadding();
                int frameOffsetY = offsetY + frame.getY() + frame.getLineBox().getTopPadding();
                this.createHyperlinks(frame.getElements(), frameOffsetX, frameOffsetY);
            }
        }
    }

    protected String getHyperlinkTooltip(JRPrintHyperlink hyperlink) {
        String toolTip = hyperlink.getHyperlinkTooltip();
        if (toolTip == null) {
            toolTip = this.getFallbackTooltip(hyperlink);
        }
        return toolTip;
    }

    protected String getFallbackTooltip(JRPrintHyperlink hyperlink) {
        String toolTip = null;
        switch (hyperlink.getHyperlinkTypeValue()) {
            case REFERENCE: {
                toolTip = hyperlink.getHyperlinkReference();
                break;
            }
            case LOCAL_ANCHOR: {
                if (hyperlink.getHyperlinkAnchor() == null) break;
                toolTip = "#" + hyperlink.getHyperlinkAnchor();
                break;
            }
            case LOCAL_PAGE: {
                if (hyperlink.getHyperlinkPage() == null) break;
                toolTip = "#page " + hyperlink.getHyperlinkPage();
                break;
            }
            case REMOTE_ANCHOR: {
                toolTip = "";
                if (hyperlink.getHyperlinkReference() != null) {
                    toolTip = toolTip + hyperlink.getHyperlinkReference();
                }
                if (hyperlink.getHyperlinkAnchor() == null) break;
                toolTip = toolTip + "#" + hyperlink.getHyperlinkAnchor();
                break;
            }
            case REMOTE_PAGE: {
                toolTip = "";
                if (hyperlink.getHyperlinkReference() != null) {
                    toolTip = toolTip + hyperlink.getHyperlinkReference();
                }
                if (hyperlink.getHyperlinkPage() == null) break;
                toolTip = toolTip + "#page " + hyperlink.getHyperlinkPage();
                break;
            }
        }
        return toolTip;
    }

    void hyperlinkClicked(MouseEvent evt) {
        JPanel link = (JPanel)evt.getSource();
        JRPrintHyperlink element = this.linksMap.get(link);
        this.hyperlinkClicked(element);
    }

    protected void hyperlinkClicked(JRPrintHyperlink hyperlink) {
        try {
            JRHyperlinkListener listener = null;
            for (int i2 = 0; i2 < this.hyperlinkListeners.size(); ++i2) {
                listener = this.hyperlinkListeners.get(i2);
                listener.gotoHyperlink(hyperlink);
            }
        }
        catch (JRException e2) {
            if (log.isErrorEnabled()) {
                log.error("Hyperlink click error.", e2);
            }
            JOptionPane.showMessageDialog(this, this.viewerContext.getBundleString("error.hyperlink"));
        }
    }

    protected void setRealZoomRatio(float newZoom) {
        if (newZoom > 0.0f && this.realZoom != newZoom) {
            float zoom = newZoom * 72.0f / (float)this.screenResolution;
            this.viewerContext.setZoomRatio(zoom);
        }
    }

    public void setFitWidthZoomRatio() {
        this.setRealZoomRatio(this.getPageCanvasWidth() / (float)this.viewerContext.getPageFormat().getPageWidth().intValue());
    }

    public void setFitPageZoomRatio() {
        this.setRealZoomRatio(this.getPageCanvasHeight() / (float)this.viewerContext.getPageFormat().getPageHeight().intValue());
    }

    protected void keyNavigate(KeyEvent evt) {
        boolean refresh = true;
        switch (evt.getKeyCode()) {
            case 34: 
            case 40: {
                this.dnNavigate(evt);
                break;
            }
            case 33: 
            case 38: {
                this.upNavigate(evt);
                break;
            }
            case 36: {
                this.homeEndNavigate(0);
                break;
            }
            case 35: {
                this.homeEndNavigate(this.viewerContext.getPageCount() - 1);
                break;
            }
            default: {
                refresh = false;
            }
        }
        if (refresh) {
            this.viewerContext.refreshPage();
        }
    }

    protected void dnNavigate(KeyEvent evt) {
        int bottomPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.dispatchEvent(evt);
        if ((this.scrollPane.getViewport().getHeight() > this.pnlPage.getHeight() || this.scrollPane.getVerticalScrollBar().getValue() == bottomPosition) && this.viewerContext.getPageIndex() < this.viewerContext.getPageCount() - 1) {
            this.viewerContext.setPageIndex(this.viewerContext.getPageIndex() + 1);
            if (this.scrollPane.isEnabled()) {
                this.scrollPane.getVerticalScrollBar().setValue(0);
            }
        }
    }

    protected void upNavigate(KeyEvent evt) {
        if ((this.scrollPane.getViewport().getHeight() > this.pnlPage.getHeight() || this.scrollPane.getVerticalScrollBar().getValue() == 0) && this.viewerContext.getPageIndex() > 0) {
            this.viewerContext.setPageIndex(this.viewerContext.getPageIndex() - 1);
            if (this.scrollPane.isEnabled()) {
                this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getMaximum());
            }
        } else {
            this.scrollPane.dispatchEvent(evt);
        }
    }

    protected void homeEndNavigate(int pageNumber) {
        this.viewerContext.setPageIndex(pageNumber);
        if (this.scrollPane.isEnabled()) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    @Override
    public void viewerEvent(JRViewerEvent event) {
        switch (event.getCode()) {
            case 5: {
                this.fitPage();
                break;
            }
            case 6: {
                this.fitWidth();
                break;
            }
            case 3: {
                this.pageChanged();
                break;
            }
            case 2: {
                this.refreshPage();
                break;
            }
            case 4: {
                this.zoomChanged();
                break;
            }
            case 1: 
            case 7: {
                this.refreshTabs();
            }
        }
    }

    protected class ImageMapPanel
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 10200L;
        protected final List<JRPrintImageAreaHyperlink> imageAreaHyperlinks;

        public ImageMapPanel(Rectangle renderingArea, ImageMapRenderable imageMap) {
            try {
                this.imageAreaHyperlinks = imageMap.getImageAreaHyperlinks(renderingArea);
            }
            catch (JRException e2) {
                throw new JRRuntimeException(e2);
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            String tooltip = null;
            JRPrintImageAreaHyperlink imageMapArea = this.getImageMapArea(event);
            if (imageMapArea != null) {
                tooltip = JRViewerPanel.this.getHyperlinkTooltip(imageMapArea.getHyperlink());
            }
            if (tooltip == null) {
                tooltip = super.getToolTipText(event);
            }
            return tooltip;
        }

        @Override
        public void mouseDragged(MouseEvent e2) {
            JRViewerPanel.this.pnlLinksMouseDragged(e2);
        }

        @Override
        public void mouseMoved(MouseEvent e2) {
            JRPrintImageAreaHyperlink imageArea = this.getImageMapArea(e2);
            if (imageArea != null && imageArea.getHyperlink().getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
                e2.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            } else {
                e2.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(MouseEvent e2) {
            return this.getImageMapArea((int)((float)e2.getX() / JRViewerPanel.this.realZoom), (int)((float)e2.getY() / JRViewerPanel.this.realZoom));
        }

        protected JRPrintImageAreaHyperlink getImageMapArea(int x2, int y) {
            JRPrintImageAreaHyperlink image = null;
            if (this.imageAreaHyperlinks != null) {
                ListIterator<JRPrintImageAreaHyperlink> it = this.imageAreaHyperlinks.listIterator(this.imageAreaHyperlinks.size());
                while (image == null && it.hasPrevious()) {
                    JRPrintImageAreaHyperlink area = it.previous();
                    if (!area.getArea().containsPoint(x2, y)) continue;
                    image = area;
                }
            }
            return image;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            JRPrintImageAreaHyperlink imageMapArea = this.getImageMapArea(e2);
            if (imageMapArea != null) {
                JRViewerPanel.this.hyperlinkClicked(imageMapArea.getHyperlink());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
            e2.getComponent().setCursor(Cursor.getPredefinedCursor(13));
            JRViewerPanel.this.pnlLinksMousePressed(e2);
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
            e2.getComponent().setCursor(Cursor.getDefaultCursor());
            JRViewerPanel.this.pnlLinksMouseReleased(e2);
        }
    }

    class PageRenderer
    extends JLabel {
        private static final long serialVersionUID = 10200L;
        private boolean renderImage;

        @Override
        public void paintComponent(Graphics g2) {
            if (this.isRenderImage()) {
                super.paintComponent(g2);
            } else {
                JRViewerPanel.this.paintPage((Graphics2D)g2.create());
            }
        }

        public boolean isRenderImage() {
            return this.renderImage;
        }

        public void setRenderImage(boolean renderImage) {
            this.renderImage = renderImage;
        }
    }
}

