/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;

public abstract class TimeContainer
extends TimedElement {
    protected List children = new LinkedList();

    public void addChild(TimedElement timedElement) {
        if (timedElement == this) {
            throw new IllegalArgumentException("recursive datastructure not allowed here!");
        }
        this.children.add(timedElement);
        timedElement.parent = this;
        this.setRoot(timedElement, this.root);
        this.root.fireElementAdded(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    protected void setRoot(TimedElement timedElement, TimedDocumentRoot timedDocumentRoot) {
        timedElement.root = timedDocumentRoot;
        if (timedElement instanceof TimeContainer) {
            TimeContainer timeContainer = (TimeContainer)timedElement;
            Iterator iterator = timeContainer.children.iterator();
            while (iterator.hasNext()) {
                TimedElement timedElement2 = (TimedElement)iterator.next();
                this.setRoot(timedElement2, timedDocumentRoot);
            }
        }
    }

    public void removeChild(TimedElement timedElement) {
        this.children.remove(timedElement);
        timedElement.parent = null;
        this.setRoot(timedElement, null);
        this.root.fireElementRemoved(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    public TimedElement[] getChildren() {
        return this.children.toArray(new TimedElement[0]);
    }

    protected float sampleAt(float f2, boolean bl) {
        super.sampleAt(f2, bl);
        return this.sampleChildren(f2, bl);
    }

    protected float sampleChildren(float f2, boolean bl) {
        float f3 = Float.POSITIVE_INFINITY;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TimedElement timedElement = (TimedElement)iterator.next();
            float f4 = timedElement.sampleAt(f2, bl);
            if (!(f4 < f3)) continue;
            f3 = f4;
        }
        return f3;
    }

    protected void reset(boolean bl) {
        super.reset(bl);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            TimedElement timedElement = (TimedElement)iterator.next();
            timedElement.reset(bl);
        }
    }

    protected boolean isConstantAnimation() {
        return false;
    }

    public abstract float getDefaultBegin(TimedElement var1);
}

