/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableNumberValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableAngleValue
extends AnimatableNumberValue {
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected short unit;

    public AnimatableAngleValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableAngleValue(AnimationTarget animationTarget, float f2, short s2) {
        super(animationTarget, f2);
        this.unit = s2;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatableAngleValue animatableAngleValue;
        AnimatableAngleValue animatableAngleValue2 = animatableValue == null ? new AnimatableAngleValue(this.target) : (AnimatableAngleValue)animatableValue;
        float f3 = this.value;
        short s2 = this.unit;
        if (animatableValue2 != null) {
            animatableAngleValue = (AnimatableAngleValue)animatableValue2;
            if (animatableAngleValue.unit != s2) {
                f3 = AnimatableAngleValue.rad(f3, s2);
                f3 += f2 * (AnimatableAngleValue.rad(animatableAngleValue.value, animatableAngleValue.unit) - f3);
                s2 = 3;
            } else {
                f3 += f2 * (animatableAngleValue.value - f3);
            }
        }
        if (animatableValue3 != null) {
            animatableAngleValue = (AnimatableAngleValue)animatableValue3;
            if (animatableAngleValue.unit != s2) {
                f3 += (float)n2 * AnimatableAngleValue.rad(animatableAngleValue.value, animatableAngleValue.unit);
                s2 = 3;
            } else {
                f3 += (float)n2 * animatableAngleValue.value;
            }
        }
        if (animatableAngleValue2.value != f3 || animatableAngleValue2.unit != s2) {
            animatableAngleValue2.value = f3;
            animatableAngleValue2.unit = s2;
            animatableAngleValue2.hasChanged = true;
        }
        return animatableAngleValue2;
    }

    public short getUnit() {
        return this.unit;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        AnimatableAngleValue animatableAngleValue = (AnimatableAngleValue)animatableValue;
        return Math.abs(AnimatableAngleValue.rad(this.value, this.unit) - AnimatableAngleValue.rad(animatableAngleValue.value, animatableAngleValue.unit));
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableAngleValue(this.target, 0.0f, 1);
    }

    public String getCssText() {
        return super.getCssText() + UNITS[this.unit];
    }

    public static float rad(float f2, short s2) {
        switch (s2) {
            case 3: {
                return f2;
            }
            case 4: {
                return (float)Math.PI * f2 / 200.0f;
            }
        }
        return (float)Math.PI * f2 / 180.0f;
    }
}

