/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableNumberListValue
extends AnimatableValue {
    protected float[] numbers;

    protected AnimatableNumberListValue(AnimationTarget animationTarget) {
        super(animationTarget);
    }

    public AnimatableNumberListValue(AnimationTarget animationTarget, float[] fArray) {
        super(animationTarget);
        this.numbers = fArray;
    }

    public AnimatableValue interpolate(AnimatableValue animatableValue, AnimatableValue animatableValue2, float f2, AnimatableValue animatableValue3, int n2) {
        AnimatableNumberListValue animatableNumberListValue;
        AnimatableNumberListValue animatableNumberListValue2 = (AnimatableNumberListValue)animatableValue2;
        AnimatableNumberListValue animatableNumberListValue3 = (AnimatableNumberListValue)animatableValue3;
        boolean bl = animatableValue2 != null;
        boolean bl2 = animatableValue3 != null;
        boolean bl3 = !(bl && animatableNumberListValue2.numbers.length != this.numbers.length || bl2 && animatableNumberListValue3.numbers.length != this.numbers.length);
        float[] fArray = !bl3 && bl && (double)f2 >= 0.5 ? animatableNumberListValue2.numbers : this.numbers;
        int n3 = fArray.length;
        if (animatableValue == null) {
            animatableNumberListValue = new AnimatableNumberListValue(this.target);
            animatableNumberListValue.numbers = new float[n3];
        } else {
            animatableNumberListValue = (AnimatableNumberListValue)animatableValue;
            if (animatableNumberListValue.numbers == null || animatableNumberListValue.numbers.length != n3) {
                animatableNumberListValue.numbers = new float[n3];
            }
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            float f3 = fArray[i2];
            if (bl3) {
                if (bl) {
                    f3 += f2 * (animatableNumberListValue2.numbers[i2] - f3);
                }
                if (bl2) {
                    f3 += (float)n2 * animatableNumberListValue3.numbers[i2];
                }
            }
            if (animatableNumberListValue.numbers[i2] == f3) continue;
            animatableNumberListValue.numbers[i2] = f3;
            animatableNumberListValue.hasChanged = true;
        }
        return animatableNumberListValue;
    }

    public float[] getNumbers() {
        return this.numbers;
    }

    public boolean canPace() {
        return false;
    }

    public float distanceTo(AnimatableValue animatableValue) {
        return 0.0f;
    }

    public AnimatableValue getZeroValue() {
        float[] fArray = new float[this.numbers.length];
        return new AnimatableNumberListValue(this.target, fArray);
    }

    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.numbers[0]);
        for (int i2 = 1; i2 < this.numbers.length; ++i2) {
            stringBuffer.append(' ');
            stringBuffer.append(this.numbers[i2]);
        }
        return stringBuffer.toString();
    }
}

