/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.MotionAnimation;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGAnimateElementBridge;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.SVGAnimatedPathDataSupport;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.SVGOMPathElement;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.AWTPathProducer;
import org.apache.batik.parser.AngleHandler;
import org.apache.batik.parser.AngleParser;
import org.apache.batik.parser.LengthArrayProducer;
import org.apache.batik.parser.LengthPairListParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGAnimateMotionElementBridge
extends SVGAnimateElementBridge {
    public String getLocalName() {
        return "animateMotion";
    }

    public Bridge getInstance() {
        return new SVGAnimateMotionElementBridge();
    }

    protected AbstractAnimation createAnimation(AnimationTarget animationTarget) {
        this.animationType = (short)2;
        this.attributeLocalName = "motion";
        AnimatableValue animatableValue = this.parseLengthPair("from");
        AnimatableValue animatableValue2 = this.parseLengthPair("to");
        AnimatableValue animatableValue3 = this.parseLengthPair("by");
        boolean bl = false;
        boolean bl2 = false;
        float f2 = 0.0f;
        short s2 = 0;
        String string = this.element.getAttributeNS(null, "rotate");
        if (string.length() != 0) {
            if (string.equals("auto")) {
                bl = true;
            } else if (string.equals("auto-reverse")) {
                bl = true;
                bl2 = true;
            } else {
                AngleParser angleParser = new AngleParser();
                class Handler
                implements AngleHandler {
                    float theAngle;
                    short theUnit = 1;

                    Handler() {
                    }

                    public void startAngle() throws ParseException {
                    }

                    public void angleValue(float f2) throws ParseException {
                        this.theAngle = f2;
                    }

                    public void deg() throws ParseException {
                        this.theUnit = (short)2;
                    }

                    public void grad() throws ParseException {
                        this.theUnit = (short)4;
                    }

                    public void rad() throws ParseException {
                        this.theUnit = (short)3;
                    }

                    public void endAngle() throws ParseException {
                    }
                }
                Handler handler = new Handler();
                angleParser.setAngleHandler(handler);
                try {
                    angleParser.parse(string);
                }
                catch (ParseException parseException) {
                    throw new BridgeException(this.ctx, this.element, parseException, "attribute.malformed", new Object[]{"rotate", string});
                }
                f2 = handler.theAngle;
                s2 = handler.theUnit;
            }
        }
        return new MotionAnimation(this.timedElement, this, this.parseCalcMode(), this.parseKeyTimes(), this.parseKeySplines(), this.parseAdditive(), this.parseAccumulate(), this.parseValues(), animatableValue, animatableValue2, animatableValue3, this.parsePath(), this.parseKeyPoints(), bl, bl2, f2, s2);
    }

    protected ExtendedGeneralPath parsePath() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals(node.getNamespaceURI()) || !"mpath".equals(node.getLocalName())) continue;
            String string = XLinkSupport.getXLinkHref((Element)node);
            Element element = this.ctx.getReferencedElement(this.element, string);
            if (!"http://www.w3.org/2000/svg".equals(element.getNamespaceURI()) || !"path".equals(element.getLocalName())) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
            }
            SVGOMPathElement sVGOMPathElement = (SVGOMPathElement)element;
            AWTPathProducer aWTPathProducer = new AWTPathProducer();
            SVGAnimatedPathDataSupport.handlePathSegList(sVGOMPathElement.getPathSegList(), aWTPathProducer);
            return (ExtendedGeneralPath)aWTPathProducer.getShape();
        }
        String string = this.element.getAttributeNS(null, "path");
        if (string.length() == 0) {
            return null;
        }
        try {
            AWTPathProducer aWTPathProducer = new AWTPathProducer();
            PathParser pathParser = new PathParser();
            pathParser.setPathHandler(aWTPathProducer);
            pathParser.parse(string);
            return (ExtendedGeneralPath)aWTPathProducer.getShape();
        }
        catch (ParseException parseException) {
            throw new BridgeException(this.ctx, this.element, parseException, "attribute.malformed", new Object[]{"path", string});
        }
    }

    protected float[] parseKeyPoints() {
        String string = this.element.getAttributeNS(null, "keyPoints");
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(7);
        int n3 = 0;
        int n4 = 0;
        block2: while (n3 < n2) {
            while (string.charAt(n3) == ' ') {
                if (++n3 != n2) continue;
                break block2;
            }
            n4 = n3++;
            if (n3 != n2) {
                char c2 = string.charAt(n3);
                while (c2 != ' ' && c2 != ';' && c2 != ',' && ++n3 != n2) {
                    c2 = string.charAt(n3);
                }
            }
            int n5 = n3++;
            try {
                float f2 = Float.parseFloat(string.substring(n4, n5));
                arrayList.add(new Float(f2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(this.ctx, this.element, numberFormatException, "attribute.malformed", new Object[]{"keyPoints", string});
            }
        }
        n2 = arrayList.size();
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray[i2] = ((Float)arrayList.get(i2)).floatValue();
        }
        return fArray;
    }

    protected int getDefaultCalcMode() {
        return 2;
    }

    protected AnimatableValue[] parseValues() {
        String string = this.element.getAttributeNS(null, "values");
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        return this.parseValues(string);
    }

    protected AnimatableValue[] parseValues(String string) {
        try {
            LengthPairListParser lengthPairListParser = new LengthPairListParser();
            LengthArrayProducer lengthArrayProducer = new LengthArrayProducer();
            lengthPairListParser.setLengthListHandler(lengthArrayProducer);
            lengthPairListParser.parse(string);
            short[] sArray = lengthArrayProducer.getLengthTypeArray();
            float[] fArray = lengthArrayProducer.getLengthValueArray();
            AnimatableValue[] animatableValueArray = new AnimatableValue[sArray.length / 2];
            for (int i2 = 0; i2 < sArray.length; i2 += 2) {
                float f2 = this.animationTarget.svgToUserSpace(fArray[i2], sArray[i2], (short)1);
                float f3 = this.animationTarget.svgToUserSpace(fArray[i2 + 1], sArray[i2 + 1], (short)2);
                animatableValueArray[i2 / 2] = new AnimatableMotionPointValue(this.animationTarget, f2, f3, 0.0f);
            }
            return animatableValueArray;
        }
        catch (ParseException parseException) {
            throw new BridgeException(this.ctx, this.element, parseException, "attribute.malformed", new Object[]{"values", string});
        }
    }

    protected AnimatableValue parseLengthPair(String string) {
        String string2 = this.element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return null;
        }
        return this.parseValues(string2)[0];
    }

    public AnimatableValue getUnderlyingValue() {
        return new AnimatableMotionPointValue(this.animationTarget, 0.0f, 0.0f, 0.0f);
    }

    protected void initializeAnimation() {
        Node node;
        String string = XLinkSupport.getXLinkHref(this.element);
        if (string.length() == 0) {
            node = this.element.getParentNode();
        } else {
            node = this.ctx.getReferencedElement(this.element, string);
            if (node.getOwnerDocument() != this.element.getOwnerDocument()) {
                throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
            }
        }
        this.animationTarget = null;
        if (node instanceof SVGOMElement) {
            this.targetElement = (SVGOMElement)node;
            this.animationTarget = this.targetElement;
        }
        if (this.animationTarget == null) {
            throw new BridgeException(this.ctx, this.element, "uri.badTarget", new Object[]{string});
        }
        this.timedElement = this.createTimedElement();
        this.animation = this.createAnimation(this.animationTarget);
        this.eng.addAnimation(this.animationTarget, (short)2, this.attributeNamespaceURI, this.attributeLocalName, this.animation);
    }
}

